#include "ssapre.h"

void ExprPRE::Set_var_phis(PhiNode *phi) {
  debug("called Set_var_phis(%d)\n", phi);
  CfgNode *cn = ssa->phi_node_block(phi);
  int n = get_number(cn);
  if(PHI_for_block[n] == NULL) {
    add_PHI(n);
    for(int i = 0; i < phi->srcs_size(); i++) {
      Operation op = ssa->unique_def(phi->get_src(i));
      if(op.is_phi_node()) {
	Set_var_phis(op.get_phi_node());
      }
    }
  }
}

void ExprPRE::add_PHI(int n) {
  debug("Called add_PHI(%d)\n", n);
  if(PHI_for_block[n] == NULL && get_exit_node(ssa->unit_cfg) != get_node(ssa->unit_cfg, n)) {
    PHINode *F = new PHINode(ssa, n);
    all.push_back(F);
    PHI.push_back(F);
    PHI_for_block[n] = F;
    if (occ_for_block[n] == NULL) occ_for_block[n] = new deque<Occ *>();
    occ_for_block[n]->push_front(F);
    for(int l = 0; l < F->num_opnds(); l++) {
      PhiOp *op = (PhiOp *)F->get_opnd(l);
      all.push_back(op);
      if(occ_for_block[op->block] == NULL) {
	occ_for_block[op->block] = new deque<Occ *>();
      }
      occ_for_block[op->block]->push_back(op);
    }
  }
}


void ExprPRE::do_PHI_insertion() {
  debug("called phi insertion\n");

  for(int i = 0; i < all.size() && all[i]->is_a() == Occ::REAL; ++i) {
    debug("PHI insertion first loop iteration %d\n", i);
    if(occ_for_block[all[i]->block] == NULL) { 
      occ_for_block[all[i]->block] = new deque<Occ *>();
    }
    occ_for_block[all[i]->block]->push_back(all[i]);
  }

  for(int i = 0; i < all.size() && all[i]->is_a() == Occ::REAL; ++i) {
    debug("PHI insertion second loop iteration %d\n", i);
    // Next, get iterated dominance frontier for X
    CfgNode *b = get_node(ssa->unit_cfg, all[i]->block);
    const NatSet *s = ssa->dominator_analysis->dom_frontier(b);
    
    NatSetIter it = s->iter();
    while(it.is_valid()) {
      unsigned n = it.current();
      add_PHI(n);
      it.next();
    }

    for(int j = 0; j < ((RealOcc*)all[i])->num_args(); j++) {
      Opnd vj = ((RealOcc *)all[i])->new_arg_name(j);
      Operation op = ssa->unique_def(vj);
      if(op.is_phi_node()) {
	Set_var_phis(op.get_phi_node());
      }
    }
  }
  debug("Finished do_PHI_insertion()\n");
}





