#include "ssapre.h"



typedef reverse_iterator< Vector<Occ *>::iterator > rev;

void ExprPRE::finalize_visit(int block, Opnd *args) {
  debug("Called finalize_visit(%d, .)\n", block);
  Opnd *arg = new Opnd[arg_ct];
  for(int i = 0; i < arg_ct; i++) {
    arg[i] = update_opnd(block, i, args[i]);
  }
  debug("finished with update_opnd.\n");

  deque<Occ *> *list = occ_for_block[block];
  if (list != NULL) {
    deque<Occ *>::iterator it = list->begin();
    debug("finalizing all occs in this block\n");
    while(it != list->end()) {
      Occ *X = *it;
      X->save = false;
      X->reload = false;
      int x = X->version;
      debug("Got an occ X = %d, version = %d\n",X, x);
      if (X->is_a() == Occ::PHI) {
	debug("X is a PHI\n");
	if (((PHINode *)X)->will_be_avail()) {
	  avail_def[x] = X;
	}
      } else if(avail_def[x]->version == Occ::BOTTOM ||
		!dominates(avail_def[x], X)) {
	debug("X is not a PHI, but its avail_def is bottom or doesn't dominate this block\n"); 
	avail_def[x] = X;
      } else if(avail_def[x]->is_a() == Occ::REAL) {
	debug("avail_def[X] is a REAL\n");
	avail_def[x]->save = true;
	X->reload = true;
      }
      it++;
    }
    debug("Now processing PHIs in successor blocks\n");
    CfgNode *n = get_node(ssa->unit_cfg, block);
    RealOcc *inserted = NULL;
    Instr *new_inst = NULL;
    for(int i = 0; i < succs_size(n); i++) {
      debug("looking for PHI in successor %d\n", i);
      CfgNode *S = get_succ(n, i);
      int j = 0; 
      while(j < preds_size(S) && get_pred(S,j) != n) j++;
      // n is the jth predecessor of S
      debug("Block %d's %dth successor is %d, which has this block as its %dth pred out of %d\n",
	    block, i, get_number(S), j, preds_size(S));
      // Corresponds to strange notation "for each expr-PHI F in S"
      // from [CCK+97]
      PHINode *F = PHI_for_block[get_number(S)];
      debug("PHINode for block %d = %d\n", get_number(S), F);
      if(F != NULL) {
	Occ *op = F->get_opnd(j);
	debug("PHINode's %dth operand = %d\n", j, op);
	if (F->will_be_avail() && op->is_a() == Occ::PHIOP) {
	  debug("%d (version %d) believes it is a phiop\n", op, op->version);
	  PhiOp  *opj = (PhiOp *) F->get_opnd(j);
	  if (opj->insert(def_point)) {
	    if (inserted == NULL) {
	      debug("Inserting a new occurrence\n");
	      new_inst = new_instr_alm(opcode);
	      debug("Constructed new_instr_alm(opcode) = %d\n", new_inst);
	      set_dst(new_inst, t);
	      debug("Did set_dst(.,%d)\n", t);
	      for(int k = 0; k < arg_ct; k++) {
		append_src(new_inst, arg[k]);
	      }
	      debug("Finished with append_src\n");
	      inserted = new RealOcc(new_inst, Occ::END, ssa);
	      inserted->block = opj->block;
	      debug("constructed new occurrence");
	      list->push_back(inserted);
	      inserted->save = true;
	      inserted->version = NextVersion;
	      NextVersion++;
	      avail_def.push_back(inserted);
	      def_point.push_back(inserted);
	      all.push_back(inserted);
	    }
	    // replace operand j with inserted
	    F->set_opnd(j, inserted);
	    list->erase(find(list->rbegin(),list->rend(),opj).base());
	  }
	} else {
	  int x = op->version;
	  debug("the %dth operand is no longer a PhiOp. version = %d\n", j, x);
	  if(avail_def[x]->is_a() == Occ::REAL) {
	    avail_def[x]->save = true;
	    F->set_opnd(j, avail_def[x]);
	    list->erase(find(list->rbegin(),list->rend(),op).base());
	  }
	}
      }
    }
  }
  debug("Got outside of successor block loop\n");
  DominanceChild *K = ssa->dominator_children[block];
  debug("Got Dominance children = %d\n", K);
  while(K != NULL) { finalize_visit(K->block_number, arg); K = K->next; }
  debug("Finished with dominator children\n");
  delete [] arg;
  debug("Done with finalize_visit(%d,.)\n", block);
} 

void ExprPRE::do_Finalize() {
  avail_def.resize(NextVersion, NULL);
  int num_fake_defs = NextVersion;
  PhiOp **adef = new PhiOp*[num_fake_defs];

  for(int x = 0; x < NextVersion; x++) {
    adef[x] = new PhiOp(ssa, NULL);
    adef[x]->version = Occ::BOTTOM;
    avail_def[x] = adef[x];
  }

  Opnd *opnds = new Opnd[arg_ct];
  for(int i = 0; i < arg_ct; i++) opnds[i] = ssa->old_opnd_table[arg_ids[i]];
  

  finalize_visit(get_number(get_entry_node(ssa->unit_cfg)), opnds);
  for(int i = 0; i < num_fake_defs; i++) {
    delete adef[i];
  }
  delete [] adef;
  delete [] opnds;
}

bool ExprPRE::dominates(Occ *x1, Occ *x2) {
  if (x1->block == x2->block) {
    switch(x1->pos) {
    case Occ::END:
      return false;
      break;
    case Occ::TOP:
      return true;
      break;
    default:
      switch(x2->pos) {
      case Occ::TOP:
	return false; break;
      case Occ::END:
	return true; break;
      default:
	return (x1->pos > x2->pos); break;
      }
      break;
    }
  } else {
    return ssa->dominator_analysis->dominates(x1->block, x2->block);
  }
}

Opnd ExprPRE::update_opnd(int block, int arg, Opnd old) {
  // if(!has_def[block][arg]) return old;

  debug("Called opdate_upnd(%d,%d,.)\n", block, arg);
  Opnd old_name = ssa->old_opnd_table[arg_ids[arg]];
  List<PhiNode*> phis = ssa->block_phi_nodes[block];
  List<PhiNode*>::iterator it = phis.begin();
  Opnd new_name = old;
  debug("Iterating through phis for block\n");
  while(it != phis.end()) {
    PhiNode *p =*it;
    if(p->get_old_name() == old_name) new_name =  p->get_new_name();
    it++;
  }
  debug("Finished with phis, iterating through instructions\n");
  CfgNode *n = get_node(ssa->unit_cfg, block);
  InstrHandle ih = instrs_start(n);
  for(int i = 0; i < instrs_size(n); ih++, i++) {
    Instr *mi = *ih;
    if (dsts_size(mi) > 0) {
      Opnd dst = get_dst(mi);
      int value_id = ssa->lookup_new_opnd(dst);
      if (value_id >= 0) {
	Opnd old_dst = ssa->name_map[value_id];
	if(old_dst == old_name) new_name = dst;
      }
    }
  }
  debug("finished with instructions\n");
  return new_name;
}

void ExprPRE::do_Extraneous_PHI_removal() {
  // Initially all PHI are extraneous
  for(int i = 0; i < PHI.size(); i++) {
    PHI[i]->live = false;
  }
  // Mark all PHI on the DF+ of the real, saved occurrences as non-extraneous
  for(int i = 0; i < all.size(); i++) {
    Occ* occ = all[i];
    if(occ->is_a() == Occ::REAL && occ->save) {
      CfgNode *b = get_node(ssa->unit_cfg, occ->block);
      const NatSet *s = ssa->dominator_analysis->dom_frontier(b);
      NatSetIter it = s->iter();
      while(it.is_valid()) {
	unsigned n = it.current();
	if (PHI_for_block[n] != NULL) {
	  PHI_for_block[n]->live = true;
	}
	it.next();
      }
    }
  }
  
  // now do replacing versions:

  // Collect extraneous PHIs
  deque<PHINode *> extraneous;
  Vector<Occ *>::iterator i = all.begin();
  Vector<PHINode *>::iterator p = PHI.begin();
  while(i != all.end()) {
    Occ *f = *i;
    if (f->is_a() == Occ::PHI) {
      PHINode *F = (PHINode *) f;
      if (F->live) {
	p++; i++;
      } else {
	extraneous.push_back(F);
	p = PHI.erase(p);
	i = all.erase(i);
      }
    } else {
      i++;
    }
  }
  
  while(extraneous.size() > 0) {
    PHINode *F = extraneous.front();
    extraneous.pop_front();
    for(int i = 0; i < F->num_opnds(); i++) {
      
    }
  }

}
