#include "ssapre.h"


void ExprPRE::do_DeadStoreElim() {
  vector<Occ *> elim;
  Vector<Occ *>::iterator i = all.begin(); 
  Vector<PHINode *>::iterator p = PHI.begin();
  while(i != all.end()) {
    Occ *f = *i;
    deque<Occ *>& bb(*occ_for_block[f->block]);
    if (!f->live) {
      elim.push_back(f);
      // if f is a PHI, we need to remove its operands from the list of occurrences
      // Note that this works only because the operands were added to "all" after f
      // during PHI-insertion
      if (f->is_a() == Occ::PHI) {
	PHINode *F = (PHINode *)f;
	for(int j = 0; j < F->num_opnds(); j++) {
	  PhiOp *o = (PhiOp *)F->get_opnd(j);
	  o->live = false;
	}
	p = PHI.erase(p);
	PHI_for_block.erase(PHI_for_block.find(f->block));
	bb.erase(find(bb.begin(), bb.end(), f));
      } else {
	// f is a PhiOp
	// remove f from the list of occs for its block
	// search backwards because we added all of the PhiOps after the RealOccs
	bb.erase(find(bb.rbegin(), bb.rend(), f).base());
	if (bb.size() == 0) {
	  occ_for_block.erase(f->block);
	}
      }
      i = all.erase(i);
    } else {
      i++;
      if (f->is_a() == Occ::PHI) p++;
    }
  }

  for(int j = 0; j < elim.size(); j++) delete elim[j];
}


// JUNK from original Occ heirarchy + old renaming.
/*
void old_do_DeadStoreElim() {
  deque<OCCURRENCE *> wlist;
  
  // All instr use/defs of h are alive
  for(int i = 0; i < all.size(); i++) {
    if(all[i]->is_instr()) wlist.push_back(all[i]);
  }

  // For each live occurence of h,
  while(!wlist.empty()) {
    OCCURRENCE *next = wlist.front();
    wlist.pop_front();
    // if we haven't processed it before
    if (!next->is_alive()) {
      next->set_alive();
      if(next->is_instr()) {
	int ver = version[next->get_id()];
	OCCURRENCE *def = def_point[ver];
	wlist.push_back(def);
      } else {
	PHINode *phi = next->get_phi();
	for(int i = 0; i < phi->num_srcs(); i++) {
	  int ver = phi->get_src(i);
	  if (ver != BOTTOM) {
	    wlist.push_back(def_point[ver]);
	  }
	} 
      }
    }
  }
  // Now go through and remove anything that's dead, fixing up all of
  // the accounting data as we go.  Yech.

  // First, we'll fix up everyone's id to be his new id when things get erased
  int new_id = 0;
  int phi_num = 0;
  for(int i = 0; i < all.size(); i++) {
    if(all[i]->is_alive()) {
      if(all[i]->is_phi_node()) {
	phi_num++;
      } 
      all[i]->set_id(new_id);
      new_id++;
    } else {
      // since all instrs are alive, this is a dead PHI
      PHI.erase(PHI.begin() + phi_num);
      has_real_use.erase(has_real_use.begin() + phi_num);
      down_safe.erase(down_safe.begin() + phi_num);
    }
  }
  
  Vector<OCCURRENCE *>::iterator i = all.begin(); 
  Vector<int>::iterator j = version.begin();
  while(i != all.end()) {
    if(!(*i)->is_alive()) {
      PHINode *p = (*i)->get_phi();
      int n = p->get_block();
      PHI_for_block[n] = NULL;
      delete p;
      i = all.erase(i);
      j = version.erase(j);
    } else {
      i++;
      j++;
    }
  }


  // A little setup for the rest of the dataflow analyses can now be done:
  save.resize(all.size(), false);
  reload.resize(all.size(), false);
  avail_def.resize(def_point.size());
  later.resize(PHI.size(), true);
  can_be_avail.resize(PHI.size(), true);
}
*/
