#include "ssapre.h"
#include <pair.h>

void ExprPRE::reset_downsafe(PhiOp *X) {
  debug("called reset_downsafe(%d), version %d, def_point %d\n", X, X->version, def_point[X->version]);
  if(X->has_real_use || X->version == Occ::BOTTOM || def_point[X->version]->is_a() != Occ::PHI)
    return;
  debug("reset_downsafe called on a PhiOp that has no real use and is defined by a PHI\n");
  PHINode *F = (PHINode *)def_point[X->version];
  if (!F->down_safe) return;
  F->down_safe = false;
  for(int j = 0; j < F->num_opnds(); j++) reset_downsafe((PhiOp *)F->get_opnd(j));
}

void ExprPRE::do_DownSafety() {
  for(unsigned i = 0; i < PHI.size(); i++) {
    PHINode *F = PHI[i];
    debug("down_safety considers PHINode in block %d, live=%d\n", F->block, F->live);
    if (!F->down_safe) {
      for(int j = 0; j < F->num_opnds(); j++) {
	reset_downsafe((PhiOp *)F->get_opnd(j));
      }
    }
  }
}

typedef multimap<Occ *, PhiOp *> mm;
typedef pair<Occ *, PhiOp *> pp;
typedef mm::iterator mmit;

void ExprPRE::compute_can_be_avail() {
  for(unsigned i = 0; i < PHI.size(); i++) {
    PHINode *F = PHI[i];
    if (!F->down_safe && F->can_be_avail) {
      for(int j = 0; j < F->num_opnds(); j++) {
	PhiOp *op = (PhiOp*) F->get_opnd(j);
	if (op->version == Occ::BOTTOM) {
	  reset_can_be_avail(F);
	  break;
	}
      }
    }
  }
}

void ExprPRE::reset_can_be_avail(PHINode *G) {
  G->can_be_avail = false;
  pair<mmit, mmit> fl = uses.equal_range(G);
  mmit it = fl.first;
  while(it != fl.second) {
    PhiOp *opnd = (*it).second;
    PHINode *F = opnd->get_phi();
    if(!opnd->has_real_use) {
      // set opnd to BOTTOM
      opnd->version = Occ::BOTTOM;
      // This means we have to remove it from the list of uses of G - (note use of post-++ semantics)
      mmit save = it++;
      uses.erase(save);
      // now do the rest of reset_can_be_avail
      if(!F->down_safe && F->can_be_avail) reset_can_be_avail(F);
    } else {
      it++;
    }
  }
}

void ExprPRE::compute_later() {
  PHINode *F;
  for(unsigned i = 0; i < PHI.size(); i++) {
    F = PHI[i];
    F->later = F->can_be_avail;
  }
  for(unsigned i = 0; i < PHI.size(); i++) {
    F = PHI[i];
    if(F->later) {
      bool exists = false;
      for(int j = 0; j < F->num_opnds(); j++) { 
	PhiOp *op = (PhiOp *) F->get_opnd(j); 
	exists = exists || (op->version != Occ::BOTTOM && op->has_real_use);
      }
      if(exists) reset_later(F);
    }
  }
}

void ExprPRE::reset_later(PHINode *G) {
  debug("Called Reset_later(%d)\n", G->block);
  G->later = false;
  pair<mmit, mmit> fl = uses.equal_range(G);
  mmit it = fl.first;
  while(it != fl.second) {
    PhiOp *opnd = (*it).second;
    PHINode *F = opnd->get_phi();
    if(F->later) reset_later(F);
    it++;
  }
}

void ExprPRE::do_WillBeAvail() {
  compute_can_be_avail();
  compute_later();
}
