#include "ssapre.h"

ExprKey::ExprKey( const ExprKey &a ) {
  ct = a.ct;
  opcode = a.opcode;
  opnd_list = new int[ct];
  for( int i = 0; i < ct; i++ ) {
    opnd_list[i] = a.opnd_list[i];
  }
}

ExprKey::ExprKey( RegSymCatalog *c, int op, RealOcc *ro ) {
  cerr << "Constructor for exprkey..." << endl;
  opcode = op;
  ct = ro->num_args();;
  opnd_list = new int[ct];
  cerr << "Adding " << ct << "args." << endl;
  for( int i = 0; i < ct; i++ ) {
    cerr << "Old arg name is" ; fprint( stderr, ro->old_arg_name(i)); cerr << endl;
    fflush(stderr);
    cerr.flush();
    opnd_list[i] = -1;
    c->lookup( ro->old_arg_name(i), &opnd_list[i] );
    cerr << "Operand " << i << " = " << opnd_list[i] << endl;
  }

  
}

ExprKey::~ExprKey() {
  if( opnd_list != NULL ) delete opnd_list;
}

bool ExprKey::operator==( const ExprKey &a ) const {
  if( ct != a.ct || opcode != a.opcode ) {
    return false;
  }

  for( int i = 0; i < ct; i++ ) {
    if( opnd_list[i] != a.opnd_list[i] ) {
      return false;
    }
  }

  return true;
}

bool ExprKey::operator<( const ExprKey &a ) const {
  if( opcode < a.opcode ) {
    return true;
  } else if( opcode > a.opcode ) {
    return false;
  }

  // Check each element in the list
  for( int i = 0; i < a.ct; i++ ) { 
    if( i >= ct ) return true;        // this list ends before a
    if( opnd_list[i] < a.opnd_list[i] ) {
      return true;
    } else if( opnd_list[i] > a.opnd_list[i] ) {
      return false;
    }
  }

  return false;  // a ends before this list, or a == this
}

Vector<int> *ExprKey::makeVec() {
  Vector<int> *l = new Vector<int>;
  for( int i = 0; i < ct; i++ ) {
    l->push_back( opnd_list[i] );
  }

  return l;
}


