echo on
clc

%%%%%%%%%%%%%%%%%%%%%%
%% Scalar Operators %%
%%%%%%%%%%%%%%%%%%%%%%

        1 + 3 * 7^2/2
    
        a = 1; b = 3; c = 7;
    
        a + b * c^2/2   %% Similar to other languages
        
        pause
        clc
        
        c = (b > a)

        whos c
        
        d = c + 5     %% Automatic type conversion
        
        whos d
        
pause
clc

        %% Other things that should be familiar from other languages
        a = 1; b = 3; c = 7;
        
        d = (b > a || false & true) %% Short-circuited Logic
        
        e = (a >= b | (b*c-a == 20 & b^3 < c*(3+a)) );  %% full-circuit

        %% What is the value of e?  What is the type?
pause
        e
        
        a = [1 2 3]; b = [3 2 1]; c = [7 8 9];
        
        %% How about now?
pause
        %% Oops, this breaks!  Matrix arithmetic isn't the same!

pause
clc

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Matrix Arithmetic Operators %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        [1 2 3; 4 5 6] + ones(2,3)
        
        [1 2 3; 4 5 6] * ones(3,2)   %% Must have same inner dimension
        
        [1 2; 3 4]^2  %% Must be a square matrix
        
        [1 2; 3 4]^-1  %% Matrix inversion, must be square
        
        inv([1 2; 3 4]) %% Same thing
pause
clc

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Element by Element Arithmetic %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

        [1 2 3] .* [2 3 4]    %% Must be same size
        
        [12 13 14] ./ [5 4 3]
        
        [1 2 3] .^ 2
        
pause
clc
        
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  Matrix Logical and Relational Operators %% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

        rand(2,8) >= rand(2,8)

        rand(2,8) ~= rand(2,8)     %% not equal
        
        ~(rand(2,8) >= rand(2,8))    %% not operator
        
        (rand(2,8) > .5 | rand(2,8) > .5)  %% element-wise logical OR
        
pause
clc

%%%%%%%%%%%%%%%%%%%%%%%
%%  Matrix Functions %%
%%%%%%%%%%%%%%%%%%%%%%%
        A = rand(2,5)

        sin((0:.25:2)*pi)    %% trig functions
        
        sum(A)    %% column sum
        sum(A,2)  %% row sum


        min(A)

        max(A, 3)
        
        min(A, [], 2)
pause
clc
        
        size([1 2 3; 4 5 6])
        
        length([1 2 3; 4 5 6])
        
        isempty([1 2 3])
        
        isempty([])
pause
clc
        A = rand(3,4)

        A'
        
        reshape([1 2 3; 4 5 6], [3 2])  %% fill new matrix by array order 
        
        reshape(1:9, [3 3])
        
pause
clc

%%%%%%%%%%%%%%%
%%  Sorting  %%
%%%%%%%%%%%%%%%
        A = rand(3,8)

        B = sort(A)      %% sorts on each column
                
        pause
        
        [B,y] = sort(A);  %% Can also return two values
        
        y
        
        C = sortrows(A,2) %% sort rows by column 2

        %% How can matrix C be created using A and y?
                
pause
        C
        
        C = A(y(:,2),:)
        
pause
clc

%%%%%%%%%%%%%%%%%%%
%% Control Flow  %%
%%%%%%%%%%%%%%%%%%%

%        if (rand() > .5)   %% conditional
%            1
%        elseif (rand() > .5)
%            2
%        else
%            3
%        end

pause

        if (rand() > .5)   %% conditional 
            1
        elseif (rand() > .5)
            2
        else
            3
        end
pause
clc
        
%        for i=1:3        %% for loop
%            i*(i+1)
%        end
pause

        for i=1:3        %% for loop 
            i*(i+1)
        end
        
pause
clc

        i = 0;
%        while(rand() < .7)
%            i=i+1
%        end

pause

        while(rand() < .7)
            i=i+1
        end
pause
echo my_function on
clc

%%%%%%%%%%%%%%%%%%%%%%%%
%% Writing Functions  %%
%%%%%%%%%%%%%%%%%%%%%%%%

        %% Each function goes into a new file with the function name
pause
        edit my_function.m
pause

        x = 5; y = 6;
        
        [a,b] = my_function(x,y)    %% Calling the function
     
        %% What do x and y equal?
pause
        [x y]   %% didn't change!  Why?  MATLAB is pass by value*
                %% and each function has its own variable scope
pause
clc
        
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  You should now know how to:                        %% 
%%      Do Mathematics and logical operations for:     %%
%%         - scalars (1x1 matrix)                      %%
%%         - matrices                                  %%
%%      Use some built-in functions                    %%
%%      Have control flow (conditionals and loops)     %%
%%      Create your own functions                      %%
%%      (and know that parameters are passed by value) %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%    QUESTION BREAK     %%%%%%%%%%%%%%%
pause