/*
 * Decompiled with CFR 0.152.
 */
package converttext2bow;

import converttext2bow.StopWords;
import converttext2bow.Tokenizer;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class WordBag
extends Hashtable {
    private static boolean isStemmed;
    private static boolean removeStopWord;
    private static final String suffix = ".txt";
    private int sumOfFrequency = 0;
    private static HashSet stopWordSet;

    public WordBag() {
        isStemmed = false;
        removeStopWord = true;
    }

    public void clears() {
        this.sumOfFrequency = 0;
        this.clear();
    }

    public void merge(WordBag bag) {
        Enumeration e = bag.keys();
        while (e.hasMoreElements()) {
            String word = (String)e.nextElement();
            this.put(word, new Integer(bag.GetWordFreq(word) + this.GetWordFreq(word)));
        }
        this.sumOfFrequency += bag.sumOfFrequency();
    }

    public void copy(WordBag bag) {
        this.clear();
        Enumeration e = bag.keys();
        while (e.hasMoreElements()) {
            String word = (String)e.nextElement();
            this.put(word, new Integer(bag.GetWordFreq(word) + this.GetWordFreq(word)));
        }
        this.sumOfFrequency = bag.sumOfFrequency();
    }

    public void add(String oneToken) {
        if (this.get(oneToken) == null) {
            this.put(oneToken, new Integer(1));
        } else {
            Integer count = (Integer)this.get(oneToken);
            int incCount = count + 1;
            this.put(oneToken, new Integer(incCount));
        }
    }

    public void append(String input) {
        if (input.length() == 0) {
            return;
        }
        String inTokens = Tokenizer.process(input);
        StringTokenizer st = new StringTokenizer(inTokens);
        while (st.hasMoreTokens()) {
            String oneToken = st.nextToken();
            if (!this.isAllLetterOrDigit(oneToken) || oneToken.length() <= 1) continue;
            oneToken = oneToken.toLowerCase();
            if (removeStopWord && stopWordSet.contains(oneToken)) continue;
            if (this.get(oneToken) == null) {
                this.put(oneToken, new Integer(1));
                continue;
            }
            Integer count = (Integer)this.get(oneToken);
            int incCount = count + 1;
            this.put(oneToken, new Integer(incCount));
        }
    }

    private static final void readAllStopWordList() {
        int i;
        for (i = 0; i < StopWords.XML.length; ++i) {
            stopWordSet.add(StopWords.XML[i]);
        }
        for (i = 0; i < StopWords.LONG.length; ++i) {
            stopWordSet.add(StopWords.LONG[i]);
        }
    }

    public int sumOfFrequency() {
        if (this.sumOfFrequency == 0) {
            this.ComSumOfFrequency();
        }
        return this.sumOfFrequency;
    }

    public int ComSumOfFrequency() {
        this.sumOfFrequency = 0;
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            Integer f = (Integer)e.nextElement();
            this.sumOfFrequency += f.intValue();
        }
        return this.sumOfFrequency;
    }

    public int GetWordFreq(String word) {
        if (this.containsKey(word)) {
            return (Integer)this.get(word);
        }
        return 0;
    }

    public boolean isAllLetterOrDigit(String token) {
        boolean flag = false;
        char[] alphabetAndDigit = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        token = token.toLowerCase();
        for (int i = 0; i < token.length(); ++i) {
            flag = false;
            char c = token.charAt(i);
            for (int j = 0; j < alphabetAndDigit.length; ++j) {
                if (c != alphabetAndDigit[j]) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            return false;
        }
        return true;
    }

    static {
        stopWordSet = new HashSet();
        WordBag.readAllStopWordList();
    }
}

