/*
 * Decompiled with CFR 0.152.
 */
package converttext2bow;

import converttext2bow.WordBag;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Iterator;
import java.util.Vector;

public class Main {
    public static void main(String[] args) {
        String inputFile = "tom-pageText.txt";
        String resultFile = "bow.txt";
        WordBag fileBag = new WordBag();
        BufferedReader in = null;
        if (args.length < 1) {
            System.out.println("You should give the input file name for converting into BOW!");
        } else {
            inputFile = args[0];
        }
        if (args.length > 1) {
            resultFile = args[1];
        }
        try {
            in = new BufferedReader(new FileReader(inputFile));
            if (in == null) {
                System.out.println("no name file found!");
                System.exit(0);
            }
            while (in.ready()) {
                String oneLine = in.readLine();
                fileBag.append(oneLine.trim());
            }
            in.close();
            Vector vocabulary = Main.getVocabulary("vocabulary.txt");
            Main.writeFeatureToVector(fileBag, resultFile, vocabulary);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeFeatureToVector(WordBag eFeature, String fileName, Vector vocVector) {
        int tf = 0;
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(new File(fileName)));
            Iterator it = vocVector.iterator();
            int counter = 0;
            while (it.hasNext()) {
                String element = (String)it.next();
                tf = eFeature.containsKey(element) ? (Integer)eFeature.get(element) : 0;
                if (counter == 0) {
                    out.write(String.valueOf(tf));
                } else {
                    out.write(" " + tf);
                }
                ++counter;
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Vector getVocabulary(String file) {
        File ld = new File(file);
        if (!ld.exists()) {
            System.out.println("You should have " + file + " in your current directory");
            System.exit(0);
        }
        Vector<String> voc = new Vector<String>();
        try {
            String oneLine;
            BufferedReader in = new BufferedReader(new FileReader(file));
            while ((oneLine = in.readLine()) != null) {
                voc.add(oneLine);
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return voc;
    }
}

