% creates smoothed derivative filters of length k
% Returns [fx, fy, gauss] = [ x derivative, y derivative, blur ]

function [fx, fy, gauss] = filters(k)

oversample = 5;
kk = k*oversample;
lim = pi;

step = (2*lim/kk);
xs = ones(kk,1) * ((-lim+.5*step):step:lim);
ys = xs';

r2s = xs.^2 + ys.^2;
gauss = exp(-0.5 * r2s);
%gauss = gauss / sum(gauss(:));

fx = -xs .* gauss;
fy = -ys .* gauss;

downsample = kron(eye(k), ones(1, oversample)) / oversample;
gauss = downsample * gauss * downsample';
xs = downsample * xs * downsample';
ys = downsample * ys * downsample';
fx = downsample * fx * downsample';
fy = downsample * fy * downsample';



%fxx = gauss .* (xs.^2 - 1);
%fyy = gauss .* (ys.^2 - 1);
%fxy = gauss .* xs .* ys;
%fxx = downsample * fxx * downsample';
%fxy = downsample * fxy * downsample';
%fyy = downsample * fyy * downsample';

