% gradient viewer

frame1 = imread('b06_0906.jpg');
gr1 = intensity(frame1);
gradview(gr1, 5, 9)

% 1d filtering

scan = [zeros(50,1); ones(50,1); zeros(50,1)];
plot(scan);
pause;
scan = scan + .25*randn(150,1);
plot(scan);
pause;
g1 = exp(-(-3:.4:3).^2/2);
plot(g1);
pause;
plot(conv(g1,scan))
pause;
plot(conv([-1 1],conv(g1,scan)))

% deriv-of-gaussian filters

k = 15;
[fx, fy, gauss] = filters(k);

figure(1); 
clf;
surfl(fx);
shading interp; colormap copper;
axis([1 k 1 k -.5 .5]);
%print -depsc dx.eps
%print -dpng -r72 dx.png

figure(2); 
clf;
surfl(fy);
shading interp; colormap copper;
axis([1 k 1 k -.5 .5]);
%print -depsc dy.eps
%print -dpng -r72 dy.png

figure(3)
clf;
surfl(cos(pi/3)*fx + sin(pi/3)*fy)
shading interp; colormap copper;
axis([1 k 1 k -.5 .5]);
%print -depsc drot.eps
%print -dpng -r72 drot.png

% barcode finding

k = 15;
[fx, fy, gauss] = filters(k);

Ix = conv2(gr1, fx, 'same');
Iy = conv2(gr1, fy, 'same');

mask = Ix < 0;
Ix(mask) = -Ix(mask);
Iy(mask) = -Iy(mask);

box = ones(50,1);
Sx = conv2(box, box, Ix, 'same');
Sy = conv2(box, box, Iy, 'same');

edge = Sx.^2 + Sy.^2;
imagesc(edge);
pause;
edge = edge(1:20:end, 1:20:end);
imagesc(edge > .5*max(edge(:)));

% corner finding

k = 7;
[fx, fy, gauss] = filters(k);

Ix = conv2(gr1, fx, 'same');
Iy = conv2(gr1, fy, 'same');

Ixx = Ix .* Ix;
Ixy = Ix .* Iy;
Iyy = Iy .* Iy;

Sxx = conv2(Ixx, gauss, 'same');
Syy = conv2(Iyy, gauss, 'same');
Sxy = conv2(Ixy, gauss, 'same');

imagesc(Sxx.*Syy-Sxy.^2)

pause;
box = ones(20,1);
scor = conv2(box, box, Sxx.*Syy-Sxy.^2, 'same');
scor = scor(1:10:end, 1:10:end);
imagesc(scor)
pause;
imagesc(scor > .9*max(scor(:)))
%pause;

