(* Terminal symbols *)

(* Interface between lexer and parser *)
(* Authors: Frank Pfenning <fp@cs.cmu.edu>
 *          Ankush Das <ankushd@cs.cmu.edu>
 *)

signature TERMINAL =
sig

datatype terminal =
         LPAREN | RPAREN | LBRACKET | RBRACKET | LBANANA | RBANANA
       | BACKSLASH | DOT | EQ | EXCL | QUEST | DOLLAR | COLON
       | BAR | RIGHTARROW | COMMA
       | ARROW | SLASHBACK
       | MINUS | SLASH  (* unused *)
       | STAR | PLUS | AMPERSAND
       | CASE | OF | FOLD | UNFOLD
       | TYPE | DECL | DEFN | CONV | NORM | EVAL | FAIL
       | IDENT of string | NAT of int | LABEL of string
       | EOF | LEX_ERROR
       | PRAGMA of string * string (* pragma and rest of line *)

val toString : terminal -> string

end

structure Terminal :> TERMINAL =
struct

datatype terminal =
         LPAREN | RPAREN | LBRACKET | RBRACKET | LBANANA | RBANANA
       | BACKSLASH | DOT | EQ | EXCL | QUEST | DOLLAR | COLON
       | BAR | RIGHTARROW | COMMA
       | ARROW | SLASHBACK
       | MINUS | SLASH  (* unused *)
       | STAR | PLUS | AMPERSAND
       | CASE | OF | FOLD | UNFOLD
       | TYPE | DECL | DEFN | CONV | NORM | EVAL | FAIL
       | IDENT of string | NAT of int | LABEL of string
       | EOF | LEX_ERROR
       | PRAGMA of string * string (* pragma and rest of line *)

fun toString t =
    case t
     of LPAREN => "(" | RPAREN => ")" | LBRACKET => "[" | RBRACKET => "]"
      | LBANANA => "(|" | RBANANA => "|)"
      | BACKSLASH => "\\" | DOT => "." | EQ => "=" | EXCL => "!" | QUEST => "?" | DOLLAR => "$" | COLON => ":"
      | BAR => "|" | RIGHTARROW => "=>" | COMMA => ","
      | ARROW => "->" | SLASHBACK => "/\\"
      | MINUS => "-" | SLASH => "/"
      | STAR => "*" | PLUS => "+" | AMPERSAND => "&"
      | CASE => "case" | OF => "of" | FOLD => "fold" | UNFOLD => "unfold"
      | TYPE => "type" | DECL => "decl" | DEFN => "defn" | CONV => "conv" | NORM => "norm" | EVAL => "eval"
      | FAIL => "fail"
      | IDENT(s) => s | NAT(n) => Int.toString n | LABEL(l) => "'" ^ l
      | EOF => "<eof>" | LEX_ERROR => "<lex error>"
      | PRAGMA(pragma,line) => pragma ^ line

end (* structure Terminal *)
