(* L1 Compiler
 * Pretty Print
 * Author: Kaustuv Chaudhuri <kaustuv+@cs.cmu.edu>
 * Modified: Frank Pfenning <fp@cs.cmu.edu>
 *
 * please read the PP documentation or signatures to learn more
 *)

(* uses (from $/smlnj-lib/PP/):
   structure TextIOPP devices/textio-pp.sml
   signature PP_DESC  from src/pp-desc-sig.sml
   functor PPDescFn   from src/pp-desc-fn.sml
 *)

structure PP :> sig
		  include PP_DESC
                  val output : TextIO.outstream * pp_desc -> unit
	        end =
struct
 structure PPD : PP_DESC = PPDescFn (TextIOPP)
 open PPD

 fun output (outstream, dsc) =
     let val stream = TextIOPP.openOut {dst = outstream, wid = 80}
         val _ = PPD.description(stream, dsc)
	 val _ = TextIOPP.closeStream stream
     in
	 ()
     end
end
