(* L1 Compiler
 * Canonical Forms
 * Author: Alex Vaynberg <alv@andrew.cmu.edu>
 * Modified: Frank Pfenning <fp@cs.cmu.edu>
 *
 * This is quite trivial here, just turning
 * a tree with SEQ and NOP into a list
 *)

signature CANON =
sig
  (* linearize stm = stms, where stms is a list
   * of statements no longer containing SEQ or NOP
   *)
  val linearize : Tree.stm -> Tree.stm list
end

structure Canon =
struct

  fun linearize (Tree.SEQ(s1,s2)) = linearize s1 @ linearize s2
    | linearize (Tree.NOP) = nil
    | linearize (s) = [s]		(* MOVE or RETURN *)

end
