#! /usr/bin/env ruby
#
#   2
#  / \
# 1-5-4
#  \ / \
#   3---6
#
# rdaemon1.adduser("dga")
# rdaemon4.adduser("srini")
# rdaemon5.adduser("vyass")
# rdaemon6.adduser("gnychis")
#

## SKELETON STOLEN FROM http://www.bigbold.com/snippets/posts/show/1785
require 'socket'
require 'rdaemon'
#$SAFE = 1

$total_points = 0
$total_tests = 0

##
# The main program.  Tests are listed below this point.  All tests
# should call the "result" function to report if they pass or fail.
##

def write_config()
    File.open("final_grading1.conf", "w") { |afile|
	afile.puts "1 127.0.0.1 34100 34101 34102"
	afile.puts "2 127.0.0.1 34103 34104 34105"
	afile.puts "3 127.0.0.1 34106 34107 34108"
	afile.puts "5 127.0.0.1 34112 34113 34114"
    }

    File.open("final_grading2.conf", "w") { |afile|
	afile.puts "1 127.0.0.1 34100 34101 34102"
	afile.puts "2 127.0.0.1 34103 34104 34105"
	afile.puts "4 127.0.0.1 34109 34110 34111"
    }

    File.open("final_grading3.conf", "w") { |afile|
	afile.puts "1 127.0.0.1 34100 34101 34102"
	afile.puts "3 127.0.0.1 34106 34107 34108"
	afile.puts "4 127.0.0.1 34109 34110 34111"
	afile.puts "6 127.0.0.1 34115 34116 34117"
    }

    File.open("final_grading4.conf", "w") { |afile|
	afile.puts "4 127.0.0.1 34109 34110 34111"
	afile.puts "2 127.0.0.1 34103 34104 34105"
	afile.puts "3 127.0.0.1 34106 34107 34108"
	afile.puts "5 127.0.0.1 34112 34113 34114"
	afile.puts "6 127.0.0.1 34115 34116 34117"
    }
    
		File.open("final_grading5.conf", "w") { |afile|
	afile.puts "1 127.0.0.1 34100 34101 34102"
	afile.puts "4 127.0.0.1 34109 34110 34111"
	afile.puts "5 127.0.0.1 34112 34113 34114"
    }
    
		File.open("final_grading6.conf", "w") { |afile|
	afile.puts "4 127.0.0.1 34109 34110 34111"
	afile.puts "3 127.0.0.1 34106 34107 34108"
	afile.puts "6 127.0.0.1 34115 34116 34117"
    }
end

# Go through the config file, looking for the "id" passed,
# and spawn it
def spawn_daemon(file,id)
afile = File.open(file, "r")
afile.each_line do |line|
	line.chomp!
	(nodeid, ip, lport, dport, sport)=line.split
	if(nodeid.to_i == id)  # dont forget to convert to int
		puts "./srouted -i #{id} -c #{file} -a 1 &"
	        system("./srouted -i #{id} -c #{file} -a 1 &> /dev/null &")
		return 1 
	end
end
end

def conn_daemon(file,id)
afile = File.open(file, "r")
afile.each_line do |line|
	line.chomp!
	(nodeid, ip, lport, dport, sport)=line.split
	if(nodeid.to_i == id)  # dont forget to convert to int
		rdaemon = RDAEMON.new(ip, dport.to_i, '', '')
		rdaemon.connect()
		return rdaemon 
	end
end
end
		
def usertable_at1(rdaemon)
	rval=true
	rdaemon.send("USERTABLE")
	data=rdaemon.recv_data_from_rdaemon(1)

	#if(!rdaemon.checksize(data,3))
	#	rval=false
	#end

	responsehash = rdaemon.createuserhash(data)
	if(!rdaemon.checkuserhash(responsehash, "gnychis", 3, 2))
		rval=false
	elsif(!rdaemon.checkuserhash(responsehash, "vyass", 5, 1))
		rval=false
	elsif(!rdaemon.checkuserhash(responsehash, "srini", 2, 2))
		rval=false
	end

	return rval  # You must have survived!
end

def usertable_at2(rdaemon)
	rval=true
	rdaemon.send("USERTABLE")
	data=rdaemon.recv_data_from_rdaemon(1)

	#if(!rdaemon.checksize(data,4))
	#	puts "Fail due to checksize"
	#	rval=false
	#end

	responsehash = rdaemon.createuserhash(data)
	if(!rdaemon.checkuserhash(responsehash, "gnychis", 4, 2))
		puts "Fail due to gnychis"
		rval=false
	elsif(!rdaemon.checkuserhash(responsehash, "vyass", 1, 2))
		puts "Fail due to vyass"
		rval=false
	elsif(!rdaemon.checkuserhash(responsehash, "dga", 1, 1))
		puts "Fail due to dga"
		rval=false
	elsif(!rdaemon.checkuserhash(responsehash, "srini", 4, 1))
		puts "Fail due to srini"
		rval=false
	end

	return rval  # You must have survived!
end

def usertable_at3(rdaemon)
	rval=true
	rdaemon.send("USERTABLE")
	data=rdaemon.recv_data_from_rdaemon(1)

	#if(!rdaemon.checksize(data,4))
	#	rval=false
	#end

	responsehash = rdaemon.createuserhash(data)
	if(!rdaemon.checkuserhash(responsehash, "gnychis", 6, 1))
		rval=false
	elsif(!rdaemon.checkuserhash(responsehash, "vyass", 1, 2))
		rval=false
	elsif(!rdaemon.checkuserhash(responsehash, "dga", 1, 1))
		rval=false
	elsif(!rdaemon.checkuserhash(responsehash, "srini", 4, 1))
		rval=false
	end

	return rval  # You must have survived!
end

def usertable_at4(rdaemon)
	rval=true
	rdaemon.send("USERTABLE")
	data=rdaemon.recv_data_from_rdaemon(1)

	#if(!rdaemon.checksize(data,3))
	#	rval=false
	#end

	responsehash = rdaemon.createuserhash(data)
	if(!rdaemon.checkuserhash(responsehash, "gnychis", 6, 1))
		rval=false
	elsif(!rdaemon.checkuserhash(responsehash, "vyass", 5, 1))
		rval=false
	elsif(!rdaemon.checkuserhash(responsehash, "dga", 2, 2))
		rval=false
	end

	return rval  # You must have survived!
end

def usertable_at5(rdaemon)
	rval=true
	rdaemon.send("USERTABLE")
	data=rdaemon.recv_data_from_rdaemon(1)

	#if(!rdaemon.checksize(data,3))
	#	rval=false
	#end

	responsehash = rdaemon.createuserhash(data)
	if(!rdaemon.checkuserhash(responsehash, "gnychis", 4, 2))
		rval=false
	elsif(!rdaemon.checkuserhash(responsehash, "srini", 4, 1))
		rval=false
	elsif(!rdaemon.checkuserhash(responsehash, "dga", 1, 1))
		rval=false
	end

	return rval  # You must have survived!
end

def usertable_at6(rdaemon)
	rval=true
	rdaemon.send("USERTABLE")
	data=rdaemon.recv_data_from_rdaemon(1)

	#if(!rdaemon.checksize(data,3))
	#	rval=false
	#end

	responsehash = rdaemon.createuserhash(data)
	if(!rdaemon.checkuserhash(responsehash, "vyass", 4, 2))
		rval=false
	elsif(!rdaemon.checkuserhash(responsehash, "srini", 4, 1))
		rval=false
	elsif(!rdaemon.checkuserhash(responsehash, "dga", 3, 2))
		rval=false
	end

	return rval  # You must have survived!
end


def test_name(n)
    puts "////// #{n} \\\\\\\\\\\\"
    return n
end

def result(n, passed_exp, failed_exp, passed, points)
    explanation = nil
	$total_tests += 1
    if (passed)
	puts "(+) #{n} passed"
	$total_points += points
	explanation = passed_exp
    else
	puts "(-) #{n} failed"
	explanation = failed_exp
    end

    if (explanation)
	puts ": #{explanation}"
    else
	puts ""
    end
end

def eval_test(n, passed_exp, failed_exp, passed, points = 1)
    result(n, passed_exp, failed_exp, passed, points)
#    exit(0) if !passed
end

#### WRITE CONFIG FILE
#
# YOU MAY EDIT THE PORT NUMBERS HERE ONLY
# (to avoid port collisions while testing on andrew)
write_config()

begin

# Spawn the daemons.  This runs command lines of
# ./srouted -i ## -c cprnode##.conf  (where ## == 1 through 4)
spawn_daemon("final_grading1.conf", 1)
sleep(3)
rdaemon1 = conn_daemon("final_grading1.conf", 1)
spawn_daemon("final_grading2.conf", 2)
sleep(3)
rdaemon2 = conn_daemon("final_grading2.conf", 2)
spawn_daemon("final_grading3.conf", 3)
sleep(3)
rdaemon3 = conn_daemon("final_grading3.conf", 3)
spawn_daemon("final_grading4.conf", 4)
sleep(3)
rdaemon4 = conn_daemon("final_grading4.conf", 4)
spawn_daemon("final_grading5.conf", 5)
sleep(3)
rdaemon5 = conn_daemon("final_grading5.conf", 5)
spawn_daemon("final_grading6.conf", 6)
sleep(3)
rdaemon6 = conn_daemon("final_grading6.conf", 6)

puts "Sleeping for 5 seconds to let everything settle."
sleep(5)

# Setting up users for the test
rdaemon1.adduser("dga")
sleep(2)
rdaemon4.adduser("srini")
sleep(2)
rdaemon5.adduser("vyass")
sleep(2)
rdaemon6.adduser("gnychis")
sleep(2)
rdaemon1.ignore_reply()
rdaemon4.ignore_reply()
rdaemon5.ignore_reply()
rdaemon6.ignore_reply()
sleep(5)

############ RANDOM NEXTHOP #########################
# Check some random next hops before going to the
# user table
	tn = test_name("NEXTHOP gnychis @ 1")
	eval_test(tn, nil, nil, rdaemon1.nexthop("gnychis", 3, 2))
	tn = test_name("NEXTHOP dga @ 6")
	eval_test(tn, nil, nil, rdaemon6.nexthop("dga", 3, 2))
	tn = test_name("NEXTHOP vyass @ 3")
	eval_test(tn, nil, nil, rdaemon3.nexthop("vyass", 1, 2))
	tn = test_name("NEXTHOP gnychis @ 2")
	eval_test(tn, nil, nil, rdaemon2.nexthop("gnychis", 4, 2))
	tn = test_name("NEXTHOP dga @ 4")
	eval_test(tn, nil, nil, rdaemon4.nexthop("dga", 2, 2))
	tn = test_name("NEXTHOP gnychis @ 5")
	eval_test(tn, nil, nil, rdaemon5.nexthop("gnychis", 4, 2))



################## USERTABLE TEST #################
# I am going to add a user on node1 and node4,
# then test the USERTABLE response at 2 and 3
	tn = test_name("USERTABLE @ Node 1")
	eval_test(tn, nil, nil, usertable_at1(rdaemon1))
	
	tn = test_name("USERTABLE @ Node 2")
	eval_test(tn, nil, nil, usertable_at2(rdaemon2))

	tn = test_name("USERTABLE @ Node 3")
	eval_test(tn, nil, nil, usertable_at3(rdaemon3))

	tn = test_name("USERTABLE @ Node 4")
	eval_test(tn, nil, nil, usertable_at4(rdaemon4))

	tn = test_name("USERTABLE @ Node 5")
	eval_test(tn, nil, nil, usertable_at5(rdaemon5))
	
	tn = test_name("USERTABLE @ Node 6")
	eval_test(tn, nil, nil, usertable_at6(rdaemon6))


rescue Interrupt
rescue Exception => detail
    puts detail.message()
    print detail.backtrace.join("\n")
ensure
#    rdaemon.disconnect()
		system("killall srouted")
		puts "\nTests passed: #{$total_points} / #{$total_tests}\n"
end
