#! /usr/bin/env ruby
#
#   2
#  / \
# 1-5-4
#  \ / \
#   3---6
#
# rdaemon1.adduser("dga")
# rdaemon4.adduser("srini")
# rdaemon5.adduser("vyass")
# rdaemon6.adduser("gnychis")
#

## SKELETON STOLEN FROM http://www.bigbold.com/snippets/posts/show/1785
require 'socket'
#$SAFE = 1
require 'rdaemon'

$total_points = 0
$total_tests = 0

##
# The main program.  Tests are listed below this point.  All tests
# should call the "result" function to report if they pass or fail.
##

def write_config()
    File.open("final_grading1.conf", "w") { |afile|
	afile.puts "1 127.0.0.1 34100 34101 34102"
	afile.puts "2 127.0.0.1 34103 34104 34105"
	afile.puts "3 127.0.0.1 34106 34107 34108"
	afile.puts "5 127.0.0.1 34112 34113 34114"
    }

    File.open("final_grading2.conf", "w") { |afile|
	afile.puts "1 127.0.0.1 34100 34101 34102"
	afile.puts "2 127.0.0.1 34103 34104 34105"
	afile.puts "4 127.0.0.1 34109 34110 34111"
    }

    File.open("final_grading3.conf", "w") { |afile|
	afile.puts "1 127.0.0.1 34100 34101 34102"
	afile.puts "3 127.0.0.1 34106 34107 34108"
	afile.puts "4 127.0.0.1 34109 34110 34111"
	afile.puts "6 127.0.0.1 34115 34116 34117"
    }

    File.open("final_grading4.conf", "w") { |afile|
	afile.puts "4 127.0.0.1 34109 34110 34111"
	afile.puts "2 127.0.0.1 34103 34104 34105"
	afile.puts "3 127.0.0.1 34106 34107 34108"
	afile.puts "5 127.0.0.1 34112 34113 34114"
	afile.puts "6 127.0.0.1 34115 34116 34117"
    }
    
		File.open("final_grading5.conf", "w") { |afile|
	afile.puts "1 127.0.0.1 34100 34101 34102"
	afile.puts "4 127.0.0.1 34109 34110 34111"
	afile.puts "5 127.0.0.1 34112 34113 34114"
    }
    
		File.open("final_grading6.conf", "w") { |afile|
	afile.puts "4 127.0.0.1 34109 34110 34111"
	afile.puts "3 127.0.0.1 34106 34107 34108"
	afile.puts "6 127.0.0.1 34115 34116 34117"
    }
end

# Go through the config file, looking for the "id" passed,
# and spawn it
def spawn_daemon(file,id)
afile = File.open(file, "r")
afile.each_line do |line|
	line.chomp!
	(nodeid, ip, lport, dport, sport)=line.split
	if(nodeid.to_i == id)  # dont forget to convert to int
		puts "./srouted -i #{id} -c #{file} -a 1 &"
	        system("./srouted -i #{id} -c #{file} -a 1 &> /dev/null &")
		return 1 
	end
end
end

def conn_daemon(file,id)
afile = File.open(file, "r")
afile.each_line do |line|
	line.chomp!
	(nodeid, ip, lport, dport, sport)=line.split
	if(nodeid.to_i == id)  # dont forget to convert to int
		rdaemon = RDAEMON.new(ip, dport.to_i, '', '')
		rdaemon.connect()
		return rdaemon 
	end
end
end


def test_name(n)
    puts "////// #{n} \\\\\\\\\\\\"
    return n
end

def result(n, passed_exp, failed_exp, passed, points)
    explanation = nil
  $total_tests += 1  
	if (passed)
	puts "(+) #{n} passed"
	$total_points += points
	explanation = passed_exp
    else
	puts "(-) #{n} failed"
	explanation = failed_exp
    end

    if (explanation)
	puts ": #{explanation}"
    else
	puts ""
    end
end

def eval_test(n, passed_exp, failed_exp, passed, points = 1)
    result(n, passed_exp, failed_exp, passed, points)
#   exit(0) if !passed
end
		
def chantable_at1(rdaemon)
	rval=true
	rdaemon.send("CHANTABLE")
	data=rdaemon.recv_data_from_rdaemon(1)

	rdaemon.checksize(data, 8)
	data.delete_at(0)
	
	if(!rdaemon.checknexthops(data, "#ruby", 5, "3 2"))
		rval=false
	end
	if(!rdaemon.checknexthops(data, "#ruby", 3, "5 2"))
		rval=false
	end
	if(!rdaemon.checknexthops(data, "#ruby", 2, "5 3"))
		rval=false
	end
	if(!rdaemon.checknexthops(data, "#ruby", 1, "5 3 2"))
		rval=false
	end
	if(!rdaemon.checknexthops(data, "#linux", 1, "3 2"))
		rval=false
	end
	
	return rval
end

def chantable_at2(rdaemon)
	rval=true
	rdaemon.send("CHANTABLE")
	data=rdaemon.recv_data_from_rdaemon(1)

	rdaemon.checksize(data, 7)
	data.delete_at(0)

	if(!rdaemon.checknexthops(data, "#ruby", 2, "1"))
		rval=false
	end
	if(!rdaemon.checknexthops(data, "#linux", 4, "1"))
		rval=false
	end
	if(!rdaemon.checknexthops(data, "#linux", 1, "4"))
		rval=false
	end
	
	return rval
end

def chantable_at3(rdaemon)
	rval=true
	rdaemon.send("CHANTABLE")
	data=rdaemon.recv_data_from_rdaemon(1)

	rdaemon.checksize(data, 7)
	data.delete_at(0)

	if(!rdaemon.checknexthops(data, "#linux", 6, "1"))
		rval=false
	end
	if(!rdaemon.checknexthops(data, "#linux", 1, "6"))
		rval=false
	end
	if(!rdaemon.checknexthops(data, "#linux", 3, "6 4 1"))
		rval=false
	end
	if(!rdaemon.checknexthops(data, "#ruby", 3, "1"))
		rval=false
	end
	
	return rval
end

def chantable_at4(rdaemon)
	rval=true
	rdaemon.send("CHANTABLE")
	data=rdaemon.recv_data_from_rdaemon(1)

	rdaemon.checksize(data, 8)
	data.delete_at(0)

	if(!rdaemon.checknexthops(data, "#15441", 4, "6"))
		rval=false
	end
	if(!rdaemon.checknexthops(data, "#linux", 4, "2 6 3"))
		rval=false
	end
	
	return rval
end

def chantable_at5(rdaemon)
	rval=true
	rdaemon.send("CHANTABLE")
	data=rdaemon.recv_data_from_rdaemon(1)

	rdaemon.checksize(data, 3)
	data.delete_at(0)

	if(!rdaemon.checknexthops(data, "#ruby", 5, "1"))
		rval=false
	end
	
	return rval
end

def chantable_at6(rdaemon)
	rval=true
	rdaemon.send("CHANTABLE")
	data=rdaemon.recv_data_from_rdaemon(1)

	rdaemon.checksize(data, 3)
	data.delete_at(0)

	if(!rdaemon.checknexthops(data, "#15441", 6, "4"))
		rval=false
	end
	if(!rdaemon.checknexthops(data, "#linux", 6, "4 3"))
		rval=false
	end
	
	return rval
end
		

#### WRITE CONFIG FILE
#
# YOU MAY EDIT THE PORT NUMBERS HERE ONLY
# (to avoid port collisions while testing on andrew)
write_config()

begin

# Spawn the daemons.  This runs command lines of
# ./srouted -i ## -c cprnode##.conf  (where ## == 1 through 4)
spawn_daemon("final_grading1.conf", 1)
sleep(3)
rdaemon1 = conn_daemon("final_grading1.conf", 1)

spawn_daemon("final_grading2.conf", 2)
sleep(3)
rdaemon2 = conn_daemon("final_grading2.conf", 2)

spawn_daemon("final_grading3.conf", 3)
sleep(3)
rdaemon3 = conn_daemon("final_grading3.conf", 3)

spawn_daemon("final_grading4.conf", 4)
sleep(3)
rdaemon4 = conn_daemon("final_grading4.conf", 4)

spawn_daemon("final_grading5.conf", 5)
sleep(3)
rdaemon5 = conn_daemon("final_grading5.conf", 5)

spawn_daemon("final_grading6.conf", 6)
sleep(3)
rdaemon6 = conn_daemon("final_grading6.conf", 6)

puts "Sleeping for 5 seconds to let everything settle."
sleep(5)

# Setting up users for the test
rdaemon1.addchan("#linux")
sleep(2)
rdaemon1.addchan("#ruby")
sleep(2)
rdaemon1.ignore_reply()
sleep(2)
rdaemon2.addchan("#ruby")
sleep(2)
rdaemon2.ignore_reply()
sleep(2)
rdaemon3.addchan("#linux")
sleep(2)
rdaemon3.addchan("#ruby")
sleep(2)
rdaemon3.ignore_reply()
sleep(2)
rdaemon4.addchan("#linux")
sleep(2)
rdaemon4.addchan("#15441")
sleep(2)
rdaemon4.ignore_reply()
sleep(2)
rdaemon5.addchan("#ruby")
sleep(2)
rdaemon5.ignore_reply()
sleep(2)
rdaemon6.addchan("#linux")
sleep(2)
rdaemon6.addchan("#15441")
sleep(2)
rdaemon6.ignore_reply()

puts "Letting chan tables settle"
sleep(5)

############ RANDOM NEXTHOPS #########################
# Check some random next hops before going to the
# user table
	tn = test_name("NEXTHOP #linux @ 1")
	eval_test(tn, nil, nil, rdaemon1.nexthops("#linux", 1, "3 2"))
	tn = test_name("NEXTHOP #ruby @ 6")
	eval_test(tn, nil, nil, rdaemon6.nexthops("#ruby", 6, "4 3"))
	tn = test_name("NEXTHOP #15441 @ 3")
	eval_test(tn, nil, nil, rdaemon3.nexthops("#15441", 3, "6 4"))
	tn = test_name("NEXTHOP #linux @ 2")
	eval_test(tn, nil, nil, rdaemon2.nexthops("#linux", 2, "4 1"))
	tn = test_name("NEXTHOP #ruby @ 4")
	eval_test(tn, nil, nil, rdaemon4.nexthops("#ruby", 4, "5 3 2"))
	tn = test_name("NEXTHOP #linux @ 5")
	eval_test(tn, nil, nil, rdaemon5.nexthops("#linux", 5, "4 1"))

################## CHANTABLE TEST #################
	tn = test_name("CHANTABLE @ Node 1")
	eval_test(tn, nil, nil, chantable_at1(rdaemon1))
	
	tn = test_name("CHANTABLE @ Node 2")
	eval_test(tn, nil, nil, chantable_at2(rdaemon2))
	
	tn = test_name("CHANTABLE @ Node 3")
	eval_test(tn, nil, nil, chantable_at3(rdaemon3))

	tn = test_name("CHANTABLE @ Node 4")
	eval_test(tn, nil, nil, chantable_at4(rdaemon4))

	tn = test_name("CHANTABLE @ Node 5")
	eval_test(tn, nil, nil, chantable_at5(rdaemon5))
	
	tn = test_name("CHANTABLE @ Node 6")
	eval_test(tn, nil, nil, chantable_at6(rdaemon6))


rescue Interrupt
rescue Exception => detail
    puts detail.message()
    print detail.backtrace.join("\n")
ensure
#    rdaemon.disconnect()
		system("killall srouted")
		puts "\nTests passed: #{$total_points} / #{$total_tests}\n"
end
