package edu.cmu.cs.cs214.streamio;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;

public class TransferThread extends Thread {
	private final BufferedReader reader;
	private final PrintWriter writer;

	public TransferThread(InputStream in, OutputStream out) {
		reader = new BufferedReader(new InputStreamReader(in));
		writer = new PrintWriter(out, true);		
	}
	
	/** Reads one line at a time and transfers to the writer */
	public void run() {
		try {
			String line = reader.readLine();
			while (line != null) {				
				writer.println(line);
				line = reader.readLine();
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
