package edu.cmu.cs.cs214.streamio;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class NetworkServer implements Runnable {
	final int port;
	ExecutorService pool;
	
	private static final int DEFAULT_POOL_SIZE = 100;
	private static final int DEFAULT_PORT = 8000;
	
	public NetworkServer(int port, int poolSize) {
		this.port = port;
		this.pool = Executors.newFixedThreadPool(poolSize);
	}
	
	public NetworkServer(int port) {
		this(port, DEFAULT_POOL_SIZE);
	}
	
	public NetworkServer() {
		this(DEFAULT_PORT, DEFAULT_POOL_SIZE);
	}

	public void run() {
		ServerSocket s = null;
		try {
			try {
				s = new ServerSocket(port);
			} catch (IOException e) {
				System.err.println("Could not open server socket:  ");
				e.printStackTrace();
				return;
			}
			
			while (true) {
				try {
					Socket newClient = s.accept();  // accepts a new connection
					pool.submit(new RequestHandler(newClient));
				} catch (IOException e) {

				}
			}
			
		} finally {
			try {
				s.close();
			} catch (IOException e) {
				// ignore because we are exiting
			}
		}
	}
	
	public static void main(String[] args) {
		NetworkServer s = new NetworkServer();
		s.run();
	}
	
	private class RequestHandler implements Runnable {
		final Socket s;
		public RequestHandler(Socket s) {
			this.s = s;
		}
		public void run() {
			// Do something useful to handle a single request
			System.out.println("Got a connection");
			
			// and then...
			try {
				s.close();
			} catch (IOException e) {
				System.err.println("Could not close socket for connection.");
				e.printStackTrace();
			}
		}
	}
	

	
}
