package edu.cmu.cs.cs214.streamio;

import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;

public class ComputeServer implements Compute {
	public static final String NAME = "Compute Server";
	
	private int value = 0;
	
	@Override
	public String done() throws RemoteException {
		return "The final result was " + value + ".  Goodbye!";
	}

	@Override
	public int execute(Operation o) throws RemoteException {
		value = o.compute(value);
		return value;
	}

	@Override
	public void set(int i) throws RemoteException {
		value = i;
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// allows the server to download any needed classes from the client
		if (System.getSecurityManager() == null) {
			System.setSecurityManager (new RMISecurityManager() {
				@Override public void checkConnect (String host, int port) {}
			    @Override public void checkConnect (String host, int port, Object context) {}
			    @Override public void checkAccept(String host, int port) {}
			});
		}
		ComputeServer server = new ComputeServer();
		try {
            Compute stub = (Compute) UnicastRemoteObject.exportObject(server, 0);
            Registry registry = LocateRegistry.getRegistry();
            registry.rebind(NAME, stub);
            System.out.println("Compute Server bound");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
