package edu.cmu.cs.cs214.lect26.streams;

import java.util.*;

enum ClassStanding {
    FRESHMAN, SOPHOMORE,
    JUNIOR, SENIOR
}

class Student {
	Student(String n, int a, ClassStanding y) { name = n; age = a; year = y; }
    String name;
    int age;
    ClassStanding year;
}

public class SeniorMinimum {

	public static void main(String[] args) {
		List<Student> roster = Arrays.asList(
				new Student("a", 2, ClassStanding.FRESHMAN),
				new Student("d", 7, ClassStanding.SENIOR),
				new Student("b", 3, ClassStanding.SOPHOMORE),
				new Student("e", 11, ClassStanding.SENIOR),
				new Student("c", 5, ClassStanding.JUNIOR),
				new Student("f", 13, ClassStanding.SENIOR)
				);
		// in-class solution
		int min =
		      roster.stream()
		            .filter(s -> s.year == ClassStanding.SENIOR)
		            .reduce((s1,s2) -> s1.age < s2.age ? s1 : s2)
		            .get().age;
		System.out.println("The minimum age of a senior is " + min);
		
		// alternate solution
		OptionalInt optMin =
			roster.stream()
		          .filter(s -> s.year == ClassStanding.SENIOR)
		          .mapToInt(s -> s.age)
		          .reduce(Integer::min);
        	    //.min();
		System.out.println("The minimum age of a senior is " + optMin.getAsInt());
	}

}
