package edu.cmu.cs.cs214.lect26.streams;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.regex.Pattern;

public class GetWords {

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.err.println("usage: java GetWords <letter> <length>");
            System.exit(-1);
        }
        
        int len = Integer.parseInt(args[1]);
        Pattern wordPattern = Pattern.compile("\\p{Alpha}*");
        
        // NOTE: because of the path below, this program will only work on Unix
        BufferedReader reader = Files.newBufferedReader(Paths.get("/usr/share/dict/words"));
        reader.lines()
              .filter(s -> s.startsWith(args[0]))
              .filter(s -> s.length() == len)
              .filter(s -> wordPattern.matcher(s).matches())
              .forEach(System.out::println);
    }
}
