package edu.cmu.cs.cs214.lect26.streams;

import java.util.stream.Stream;

public class ComputeANumber {
	public static long fact(long n) {
		long f = 1;
		while (n > 0) {
			f = f * n;
			n = n - 1;
		}
		return f;
	}
	
	public static void main(String args[]) {
		/*Stream.iterate(0, n -> n + 1)
		      .limit(10)
		      .forEach(System.out::println);
		System.out.println();
		
		Stream.iterate(0, n -> n + 1)
		      .map(n -> fact(n))
              .limit(10)
              .forEach(System.out::println);
		System.out.println();
		
		Stream.iterate(0, n -> n + 1)
			  .map(n -> 1.0/fact(n))
	          .limit(10)
	          .forEach(System.out::println);		
		System.out.println();
		*/
		// Compute the sum of inverses of factorials from 0..LIMIT
		final int LIMIT = 60;
		double d = Stream.iterate(0L, n -> n + 1)		// non-negative numbers
			             .map(n -> 1.0/fact(n))			// inverse of factorials
			             .limit(LIMIT)					// take LIMIT of them
			             .reduce(0.0, (d1,d2)->d1+d2);	// sum
		
		System.out.println("What is the number " + d + "?");
	}
}
