package edu.cmu.cs.cs214.lect26.streams;

import java.util.stream.Stream;
import java.math.*;

public class ComputeABigNumber {
	public static BigInteger fact(int n) {
		BigInteger f = BigInteger.ONE;
		while (n > 0) {
			f = f.multiply(BigInteger.valueOf(n));
			n = n - 1;
		}
		return f;
	}
	
	public static void main(String args[]) {
		// Compute the sum of inverses of factorials from 0..LIMIT
		final int LIMIT = 2000;
		long t = System.currentTimeMillis();
		BigDecimal d = Stream.iterate(0, n -> n+1)		// non-negative numbers
	                     .limit(LIMIT)					// take LIMIT of them
	                     .parallel()
			             .map(n -> BigDecimal.ONE.divide(new BigDecimal(fact(n)),100,RoundingMode.HALF_UP))			// inverse of factorials
			             .reduce(BigDecimal.ZERO, (d1,d2)->d1.add(d2));	// sum
		long deltaT = System.currentTimeMillis()-t;
		
		System.out.println("What is the number " + d + "?");
		System.out.println("Elapsed time " + deltaT + " ms");
	}
}
