package edu.cmu.cs.cs214.lect01.trees;

/** Represents a Lodgepole Pine tree in the simulation */
public class LodgepolePine implements Agent {
	/** Creates a LodgepolePine of age a at Location l */
	public LodgepolePine(int a, Location l) {
		age = a;
		location = l;
	}
	
	private int age;
	private final Location location;

	@Override
	public void timeStep(Simulation simulation) {
		// adjust age
		age++;
		
		// chance to die naturally
		if (simulation.chance(Constants.PROB_NATURAL_DEATH)) {
			simulation.remove(this);
		}
		
		// chance to breed in nearby empty spots
		Location[] emptySpots = simulation.getEmptySpots(location, Constants.SEEDLING_DISTANCE);
		for (Location loc : emptySpots) {
			int distance = location.distanceTo(loc);
			if (simulation.chance(Constants.PROB_SEEDLING * (Constants.SEEDLING_DISTANCE + 1 - distance) / Constants.SEEDLING_DISTANCE)) {
				Agent seedling = new LodgepolePine(Constants.INITIAL_AGE, loc);
				simulation.add(seedling);
			}
		}
	}

	@Override
	public boolean isLodgepolePine() {
		return true;
	}

	@Override
	public boolean isInfested() {
		return false;
	}

	@Override
	public int getAge() {
		return age;
	}

	@Override
	public int getInfestation() {
		return 0;
	}

	@Override
	public Location getLocation() {
		return location;
	}

	@Override
	public void logState() {
		//System.out.println("Lodgepole Pine age " + age + " at " + location.x + "," + location.y);
	}

}
