package edu.cmu.cs.cs214.lect01.trees;

/** Represents a location in an x,y coordinate system */
public class Location {
	/** Creates a location at nx, ny */
	public Location(int nx, int ny) {
		x = nx;
		y = ny;
	}
	public final int x;
	public final int y;
	
	/** Distance is the number of steps--horizontal, vertical, or diagonal--to get from this Location to loc
	 */
	public int distanceTo(Location loc) {
		return Math.max(Math.abs(loc.x - x), Math.abs(loc.y-y));
	}
}
