package edu.cmu.cs.cs214.lect01.trees;

/** The interface of an agent in the simulation */
public interface Agent {
	/** Update the state of this agent and others in the simulation s to reflect this agent's
	 * actions in one time step.
	 */
    void timeStep(Simulation s);
    
    /** Log the state of the agent to standard output.  Note: a more realistic choice would
     * be to accept a stream parameter for output; we will consider this later in the course.
     */
	void logState();

	/** @return true if this agent is a Lodgepole Pine tree (including infected trees) */
	boolean isLodgepolePine();
	
	/** @return true if this agent is an infacted Lodgepole Pine tree */
	boolean isInfested();

	/** @return the age of this tree */
	int getAge();
	
	/** @return the level of infestation of this tree, if any */
	int getInfestation();
	
	/** @return the Location of this tree */
	Location getLocation();
}
