import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;

abstract class App extends JFrame {
	protected abstract String getApplicationTitle();

	protected abstract String getButtonText();

	protected String getInititalText() {
		return "";
	}

	protected void buttonClicked() {
	}

	private JTextField textfield;

	public App() {
		init();
	}

	protected void init() {
		JPanel contentPane = new JPanel(new BorderLayout());
		contentPane.setBorder(new BevelBorder(BevelBorder.LOWERED));
		JButton button = new JButton();
		button.setText(getButtonText());
		contentPane.add(button, BorderLayout.EAST);
		textfield = new JTextField("");
		textfield.setText(getInititalText());
		textfield.setPreferredSize(new Dimension(200, 20));
		contentPane.add(textfield, BorderLayout.WEST);
		button.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				buttonClicked();
			}
		});
		this.setContentPane(contentPane);
		this.pack();
		this.setLocation(100, 100);
		this.setTitle(getApplicationTitle());
		// code for closing the window
	}

	protected String getInput() {
		return textfield.getText();
	}
}
