import java.util.List;

interface EncoderPlugin {
	boolean canProcess(Message m);

	Message encode(Message m);

	void register(App a);
}

interface FilterPlugin {
	boolean veto(Message msg);
}

interface Message {
}

public class App {
	private List<EncoderPlugin> encoders;
	private List<FilterPlugin> filters;

	public App(List<EncoderPlugin> encoders, List<FilterPlugin> filters) {
		this.encoders = encoders;
		for (EncoderPlugin plugin : encoders)
			plugin.register(this);
		this.filters = filters;
	}

	public Message processMsg(Message msg) {
		for (EncoderPlugin plugin : encoders)
			if (plugin.canProcess(msg))
				msg = plugin.encode(msg);
		boolean isVeto = false;
		for (FilterPlugin plugin : filters)
			isVeto = isVeto || plugin.veto(msg);
		return msg;
	}
}
