import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;

class App extends JFrame implements InputProvider {
	private JTextField textfield;
	private Plugin plugin;

	public App(Plugin p) {
		this.plugin = p;
		p.register(this);
		init();
	}

	protected void init() {
		JPanel contentPane = new JPanel(new BorderLayout());
		contentPane.setBorder(new BevelBorder(BevelBorder.LOWERED));
		JButton button = new JButton();
		button.setText(plugin.getButtonText());
		contentPane.add(button, BorderLayout.EAST);
		textfield = new JTextField("");
		textfield.setText(plugin.getInititalText());
		textfield.setPreferredSize(new Dimension(200, 20));
		contentPane.add(textfield, BorderLayout.WEST);
		button.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				plugin.buttonClicked();
			}
		});
		this.setContentPane(contentPane);
		this.setTitle(plugin.getAppTitle());
	}

	public String getInput() {
		return textfield.getText();
	}
}
