import javax.swing.*;
import javax.swing.event.*;
import javax.swing.tree.*;

import java.io.File;

public class TreeDemo {
	public static void main(String[] args) {
		// Figure out where in the filesystem to start displaying
		File root;
		if (args.length > 0)
			root = new File(args[0]);
		else
			root = new File(System.getProperty("user.home"));

		// Create a TreeModel object to represent our tree of files
		FileTreeModel model = new FileTreeModel(root);

		DefaultMutableTreeNode treeData = new DefaultMutableTreeNode(root);
		treeData.add(new DefaultMutableTreeNode(root.listFiles()[0]));
		treeData.add(new DefaultMutableTreeNode(root.listFiles()[1]));
		
		// Create a JTree and tell it to display our model
		JTree tree = new JTree();
		tree.setModel(new DefaultTreeModel(treeData));

//		ImageIcon leafIcon = createImageIcon("images/middle.gif");
//		if (leafIcon != null) {
//		    DefaultTreeCellRenderer renderer = 
//		        new DefaultTreeCellRenderer();
//		    renderer.setLeafIcon(leafIcon);
//		    tree.setCellRenderer(renderer);
//		}
		
		// The JTree can get big, so allow it to scroll
		JScrollPane scrollpane = new JScrollPane(tree);

		// Display it all in a window and make the window appear
		JFrame frame = new JFrame("FileTreeDemo");
		frame.getContentPane().add(scrollpane, "Center");
		frame.setSize(400, 600);
		frame.setVisible(true);
	}
}
