// SimpleSet-soln2.dfy

class SimpleSet {
  var contents:array<int>;
  var size:int;
  
  function valid() : bool
    reads this, contents;
  {
    size >= 0
    && contents != null
    && contents.Length >= size
  }
  
  function mset() : set<int>
    reads this, contents;
    requires valid();
  {
    set j:int | 0 <= j < size :: contents[j]
  }
  
  method init(capacity:int)
    requires capacity >=0;
    modifies this;
    ensures valid();
    ensures size == 0;
    ensures contents.Length == capacity;
    ensures fresh(contents);
  {
    contents := new int[capacity];
    size := 0;
  }
  
  method contains(i:int) returns (b: bool)
    requires valid();
    ensures b <==> i in mset();
  {
    var j := 0;
    while (j < size)
      invariant 0 <= j <= size;
      invariant !(i in set k:int | 0 <= k < j :: contents[k]);
      decreases size - j;
    {
      if (contents[j] == i) {
        return true;
      }
      j := j + 1;
    }
    return false;
  }
  
  method add(i:int)
    requires valid();
    requires size < contents.Length || i in mset();
    modifies this, contents;
    ensures valid();
    ensures mset() == old(mset()) + {i};
    ensures contents == old(contents);
    ensures i in old(mset()) ==> size == old(size);
    ensures !(i in old(mset())) ==> size == old(size)+1;
  {
    var alreadyIn := contains(i);
    if (alreadyIn) {
      return;
    }
    contents[size] := i;
    size := size + 1;
  }
}

method SimpleSetDriver() {
  var s := new SimpleSet.init(2);
  var has5 := s.contains(5);
  assert !has5;
  s.add(5);
  has5 := s.contains(5);
  assert has5;
  var has4 := s.contains(4);
  assert !has4;
  s.add(4);
  has4 := s.contains(4);
  assert has4;
  s.add(4);
}