// SimpleSet-soln1.dfy

class SimpleSet {
  var contents:array<int>;
  var size:int;
  
  function valid() : bool
    reads this, contents;
  {
    size >= 0
    && contents != null
    && contents.Length >= size
  }
  
  function mset() : set<int>
    reads this, contents;
    requires valid();
  {
    set j:int | 0 <= j < size :: contents[j]
  }
  
  method init(arr:array<int>)
    requires arr != null;
    modifies this;
    ensures valid();
    ensures size == 0;
    ensures contents == arr;
  {
    contents := arr;
    size := 0;
  }
  
  method contains(i:int) returns (b: bool)
    requires valid();
    ensures b <==> i in mset();
  {
    var j := 0;
    while (j < size)
      invariant 0 <= j <= size;
      invariant !(i in set k:int | 0 <= k < j :: contents[k]);
      decreases size - j;
    {
      if (contents[j] == i) {
        return true;
      }
      j := j + 1;
    }
    return false;
  }
  
  method add(i:int)
    requires valid();
    requires size < contents.Length || i in mset();
    modifies this, contents;
    ensures valid();
    ensures mset() == old(mset()) + {i};
    ensures contents == old(contents);
    ensures i in old(mset()) ==> size == old(size);
    ensures !(i in old(mset())) ==> size == old(size)+1;
  {
    var alreadyIn := contains(i);
    if (alreadyIn) {
      return;
    }
    contents[size] := i;
    size := size + 1;
  }
}

method SimpleSetDriver() {
  var arr := new int[2];
  var s := new SimpleSet.init(arr);
  var has5 := s.contains(5);
  assert !has5;
  s.add(5);
  has5 := s.contains(5);
  assert has5;
  
  //messAround(arr);
  var has4 := s.contains(4);
  assert !has4;
  s.add(4);
  has4 := s.contains(4);
  assert has4;
  s.add(4);
}

method messAround(arr:array<int>)
  requires arr != null && arr.Length > 0;
  modifies arr;
{
  var s2 := new SimpleSet.init(arr);
  s2.add(4);  
}