/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class StateInfo {
    private Vector[] preds = new Vector[4];
    StateActionInfo[] actionSuccs = new StateActionInfo[4];

    public StateInfo() {
        int i = 0;
        while (i < 4) {
            this.actionSuccs[i] = new StateActionInfo();
            this.preds[i] = new Vector();
            ++i;
        }
    }

    public void addSuccs(int action, State st, double reward) {
        this.actionSuccs[action].updateData(st, reward);
    }

    public double getMinQsa() {
        double min = this.actionSuccs[0].qsa;
        int i = 1;
        while (i < this.actionSuccs.length) {
            min = this.actionSuccs[i].qsa < min ? this.actionSuccs[i].qsa : min;
            ++i;
        }
        return min;
    }

    public int getBestAction() {
        int bestAction = 0;
        double min = this.actionSuccs[0].qsa;
        int i = 1;
        while (i < this.actionSuccs.length) {
            if (this.actionSuccs[i].qsa < min) {
                min = this.actionSuccs[i].qsa;
                bestAction = i;
            }
            ++i;
        }
        return bestAction;
    }

    public void addPreds(State st, int action) {
        StateAndVisits snv = new StateAndVisits(st);
        int position = this.preds[action].indexOf(snv);
        if (-1 == position) {
            this.preds[action].add(snv);
        } else {
            snv = (StateAndVisits)this.preds[action].get(position);
            snv.incrementVisits();
        }
    }

    public Vector getSuccs(int action) {
        return this.actionSuccs[action].succs;
    }

    public Vector[] getPreds() {
        return this.preds;
    }
}

