/*
 * Decompiled with CFR 0.152.
 */
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Random;
import java.util.Vector;

public class PrioritizedSweeping {
    private double epsilon;
    private double discountFactor;
    private double pjog;
    private final int PATH_COST = 1;
    private int BACKUPS_ALLOWED;
    private Maze myMaze;
    private StateInfo[][] model;
    private int[][] policy;
    private int[][] selectedAction;
    private double[][][] qsa;
    private ValueFunction currValues;
    public boolean isBestAct = true;
    public boolean receivedPenalty = false;
    State start;
    State curr;
    State next;
    double priority;
    PSSimulator ui;
    DecimalFormat df = new DecimalFormat("0.0");
    Vector backedUpStates;
    PriorityQueue pQueue;
    double tinyThreshold;
    final int NUMBER_OF_BACKUPS = 10;
    ValueFunction optVals;
    boolean isOptValCalc;
    double PRECISION = 0.01;
    double policyScore;
    int numEpisodes;
    long startTime;
    long stopTime;
    Random rand = new Random();
    public int totalBackups = 0;
    public int numSteps = 0;
    public int maxCounter;
    public int maxCounterLast = 0;
    public int averageBackups;
    private static final int Min_Transition_Required = 3;

    public PrioritizedSweeping(Maze _maze, double _pjog, double _epsilon, int MaxBackUps, double _tinyThreshold) {
        this.myMaze = _maze;
        this.start = new State(0, 0);
        this.curr = new State(0, 0);
        this.pjog = _pjog;
        this.epsilon = _epsilon;
        this.BACKUPS_ALLOWED = MaxBackUps;
        this.model = new StateInfo[this.myMaze.width][this.myMaze.height];
        this.policy = new int[this.myMaze.width][this.myMaze.height];
        this.selectedAction = new int[this.myMaze.width][this.myMaze.height];
        this.tinyThreshold = _tinyThreshold;
        this.qsa = new double[this.myMaze.width][this.myMaze.height][4];
        this.optVals = new ValueFunction(this.myMaze.width, this.myMaze.height);
        this.isOptValCalc = false;
        this.calcTrueValues();
        this.initialize();
    }

    public void setSeed(long seed) {
        this.rand.setSeed(seed);
    }

    public void initialize() {
        int j;
        this.pQueue = new PriorityQueue();
        int i = 0;
        while (i < this.model.length) {
            j = 0;
            while (j < this.model[i].length) {
                this.model[i][j] = new StateInfo();
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.policy.length) {
            j = 0;
            while (j < this.policy[i].length) {
                this.policy[i][j] = -1;
                this.selectedAction[i][j] = -1;
                ++j;
            }
            ++i;
        }
        this.currValues = new ValueFunction(this.myMaze.width, this.myMaze.height);
        i = 0;
        while (i < this.qsa.length) {
            j = 0;
            while (j < this.qsa[i].length) {
                int k = 0;
                while (k < this.qsa[i][j].length) {
                    this.qsa[i][j][k] = 0.0;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.backedUpStates = new Vector();
        this.numEpisodes = 0;
        this.policyScore = 0.0;
        this.maxCounter = 0;
    }

    public void setProperty(int name, String value) {
        if (name == Properties.PJOG) {
            this.pjog = Double.parseDouble(value);
        } else if (name == Properties.Epsilon) {
            this.epsilon = Double.parseDouble(value);
        } else if (name == Properties.MaxBackups) {
            this.BACKUPS_ALLOWED = Integer.parseInt(value);
        } else if (name == Properties.TinyThreshold) {
            this.tinyThreshold = Double.parseDouble(value);
        }
    }

    public ValueFunction getValueFunction() {
        int i = 0;
        while (i < this.currValues.stateValue.length) {
            int j = 0;
            while (j < this.currValues.stateValue[i].length) {
                this.currValues.stateValue[i][j] = this.model[i][j].getMinQsa();
                ++j;
            }
            ++i;
        }
        return this.currValues;
    }

    public int[][] getPolicy() {
        int i = 0;
        while (i < this.policy.length) {
            int j = 0;
            while (j < this.policy[i].length) {
                this.policy[i][j] = this.model[i][j].getBestAction();
                ++j;
            }
            ++i;
        }
        return this.policy;
    }

    public double[][][] getQsa() {
        return this.qsa;
    }

    public State getCurrState() {
        return this.curr;
    }

    private boolean reachedGoal(State s) {
        return this.myMaze.goals.contains(s);
    }

    public void execute(int numIterations) {
        this.curr.copy(this.start);
        while (!this.reachedGoal(this.curr)) {
            this.step();
        }
    }

    private State getStart() {
        int x = this.rand.nextInt(this.myMaze.width);
        int y = this.rand.nextInt(this.myMaze.height);
        State start = new State(x, y);
        return start;
    }

    public boolean step() {
        double reward;
        if (this.reachedGoal(this.curr)) {
            this.maxCounterLast = this.maxCounter;
            this.maxCounter = 0;
            ++this.numEpisodes;
            this.curr = this.getStart();
            this.averageBackups = this.numSteps != 0 ? this.totalBackups / this.numSteps : 0;
            this.totalBackups = 0;
            this.numSteps = 0;
            return true;
        }
        int currAction = this.chooseAction(this.curr, Math.random());
        this.next = Action.performAction(this.curr, currAction, this.pjog);
        if (!this.myMaze.isValidTransition(this.curr, this.next)) {
            reward = this.myMaze.getReward(this.curr, this.next);
            this.receivedPenalty = true;
            this.next.copy(this.curr);
        } else {
            reward = 1.0;
            this.receivedPenalty = false;
        }
        this.model[this.curr.x][this.curr.y].addSuccs(currAction, this.next, reward);
        this.model[this.next.x][this.next.y].addPreds(this.curr, currAction);
        this.pQueue.placeOnTop(this.curr, this.priority);
        this.processQueue();
        this.curr.copy(this.next);
        ++this.numSteps;
        return false;
    }

    private int chooseAction(State curr, double randNum) {
        int bestAction;
        this.selectedAction[curr.x][curr.y] = bestAction = this.model[curr.x][curr.y].getBestAction();
        double d = this.epsilon / 4.0;
        int choosenAction = bestAction;
        int i = 0;
        while (i < 4) {
            if (randNum < (double)(i + 1) * d) {
                choosenAction = i;
                break;
            }
            ++i;
        }
        Utility.show("BestAction:" + bestAction);
        Utility.show("Rand" + randNum);
        Utility.show("ChoosenAction:" + choosenAction);
        this.isBestAct = choosenAction == bestAction;
        return choosenAction;
    }

    private void processQueue() {
        int counter = 0;
        while (!this.pQueue.isEmpty() && counter <= this.BACKUPS_ALLOWED) {
            State top = this.pQueue.pop();
            double jOldVal = this.model[top.x][top.y].getMinQsa();
            double roMin = Double.MAX_VALUE;
            int minAction = 0;
            int i = 0;
            while (i < 4) {
                this.model[top.x][top.y].actionSuccs[i].qsa = this.calcExpectedVal(top, i);
                if (this.model[top.x][top.y].actionSuccs[i].qsa < roMin) {
                    roMin = this.model[top.x][top.y].actionSuccs[i].qsa;
                    minAction = i;
                }
                ++i;
            }
            double deltaMax = Math.abs(roMin - jOldVal);
            Vector[] preds = this.model[top.x][top.y].getPreds();
            int i2 = 0;
            while (i2 < 4) {
                Vector predStates = preds[i2];
                int j = 0;
                while (j < predStates.size()) {
                    StateAndVisits snv = (StateAndVisits)predStates.get(j);
                    int num = snv.getVisits();
                    StateActionInfo temp = this.model[snv.state.x][snv.state.y].actionSuccs[i2];
                    int den = temp.actionCounter;
                    double prob = (double)num / (double)den;
                    double priority = prob * deltaMax;
                    if (priority > this.tinyThreshold) {
                        this.pQueue.insert(snv.state, priority);
                    }
                    ++j;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < 4) {
                this.qsa[top.x][top.y][i2] = this.model[top.x][top.y].actionSuccs[i2].qsa;
                ++i2;
            }
            ++counter;
        }
        this.totalBackups += counter - 1;
        if (counter - 1 > this.maxCounter) {
            this.maxCounter = counter - 1;
        }
    }

    private double calcExpectedVal(State s, int a) {
        StateInfo currStInfo = this.model[s.x][s.y];
        int actionCtr = currStInfo.actionSuccs[a].actionCounter;
        if (actionCtr == 0) {
            return 0.0;
        }
        double estReward = currStInfo.actionSuccs[a].totalReward / (double)actionCtr;
        Vector succs = currStInfo.getSuccs(a);
        double sum = 0.0;
        int i = 0;
        while (i < succs.size()) {
            StateAndVisits temp = (StateAndVisits)succs.get(i);
            int num = temp.getVisits();
            int den = actionCtr;
            double prob = (double)num / (double)den;
            double jVal = this.model[temp.state.x][temp.state.y].getMinQsa();
            sum += prob * jVal;
            ++i;
        }
        double val = estReward + sum;
        return val;
    }

    void printPredecessors(Vector preds) {
    }

    void printBackedUpStates() {
        System.out.println("printing backedup states");
        int i = 0;
        while (i < this.backedUpStates.size()) {
            State st = (State)this.backedUpStates.get(i);
            st.printState();
            ++i;
        }
        System.out.println();
    }

    public Vector getBackedUpStates() {
        return this.backedUpStates;
    }

    public double evalPolicy() {
        double score = 0.0;
        int[][] currPolicy = this.getPolicy();
        ValueFunction evalVals = new ValueFunction(this.myMaze.width, this.myMaze.height);
        ValueFunction prevEvalVals = new ValueFunction(this.myMaze.width, this.myMaze.height);
        prevEvalVals.initialize();
        double maxDelta = 0.0;
        double delta = 0.0;
        double v = 0.0;
        double minV = 10000.0;
        boolean valueConverged = false;
        int valueIters = 0;
        int MAX_VALUE_ALLOWED = 1000;
        while (!valueConverged) {
            int j;
            evalVals.initialize();
            maxDelta = 0.0;
            double maxV = 0.0;
            int i = 0;
            while (i < this.myMaze.width) {
                j = 0;
                while (j < this.myMaze.height) {
                    v = 0.0;
                    State currState = new State(i, j);
                    if (this.myMaze.goals.contains(currState)) {
                        evalVals.stateValue[i][j] = 0.0;
                    } else {
                        Vector allNext = new Vector(this.myMaze.getSuccessors(currState));
                        if (-1 == this.policy[i][j]) {
                            evalVals.stateValue[i][j] = 0.0;
                        } else {
                            State desiredNextState = Action.performAction(currState, this.policy[i][j]);
                            int m = 0;
                            while (m < allNext.size()) {
                                State s = (State)allNext.get(m);
                                double prob = !desiredNextState.equals(s) ? this.pjog / 3.0 : 1.0 - this.pjog;
                                double safe = this.myMaze.isValidTransition(currState, s) ? prevEvalVals.stateValue[s.x][s.y] : this.myMaze.getReward(currState, s) + prevEvalVals.stateValue[i][j];
                                v += prob * safe;
                                ++m;
                            }
                            evalVals.stateValue[i][j] = v += 1.0;
                            maxV = maxV < v ? v : maxV;
                            delta = Math.abs(evalVals.stateValue[i][j] - prevEvalVals.stateValue[i][j]);
                            if (maxDelta < delta) {
                                maxDelta = delta;
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
            ++valueIters;
            if (maxDelta < this.PRECISION) {
                valueConverged = true;
            }
            if (maxV > (double)MAX_VALUE_ALLOWED) {
                valueConverged = true;
            }
            i = 0;
            while (i < this.myMaze.width) {
                j = 0;
                while (j < this.myMaze.height) {
                    prevEvalVals.stateValue[i][j] = evalVals.stateValue[i][j];
                    ++j;
                }
                ++i;
            }
        }
        score = this.computeScore(evalVals);
        return score;
    }

    private double computeScore(ValueFunction evalVals) {
        double netScore = 0.0;
        int i = 0;
        while (i < evalVals.stateValue.length) {
            int j = 0;
            while (j < evalVals.stateValue[i].length) {
                netScore += Math.abs(this.optVals.stateValue[i][j] - evalVals.stateValue[i][j]);
                ++j;
            }
            ++i;
        }
        return netScore /= (double)(this.myMaze.height * this.myMaze.width);
    }

    public double getScore() {
        return this.policyScore;
    }

    public double getTime() {
        return this.stopTime - this.startTime;
    }

    private void calcTrueValues() {
        ValueIteration valitr = new ValueIteration(this.myMaze, this.pjog, this.PRECISION);
        while (!valitr.step()) {
        }
        this.optVals = valitr.getValueFunction();
        this.isOptValCalc = true;
    }

    public void recordStartTime() {
        this.startTime = new Date().getTime();
    }

    public void recordStopTime() {
        this.stopTime = new Date().getTime();
    }

    public void setEpsilon(double _eps) {
        this.epsilon = _eps;
    }

    static class Properties {
        public static int PJOG = 1;
        public static int MaxBackups = 2;
        public static int Epsilon = 3;
        public static int TinyThreshold = 4;

        Properties() {
        }
    }
}

