/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.text.DecimalFormat;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class PSSimulator
extends JFrame
implements ActionListener {
    private JPanel jPanel;
    private JButton jLoadButton;
    private JSeparator jSeparator1;
    private JComboBox jComboBox1;
    private JButton jStepButton;
    private JButton jExecuteButton;
    private JFileChooser fc;
    private JLabel jLabelSqSize;
    private JTextField jDelayTextField;
    private JLabel jDelayLabel;
    private JLabel jMaxBULabel;
    private JTextField jMaxBackUpsTextField;
    private JCheckBox jPolicyCheckBox;
    private JCheckBox jValuesCheckBox;
    private JButton jResetButton;
    private JButton jRefreshButton;
    private JLabel jStatusLabel;
    private JTextField jFileNameTextField;
    private JTextField jCyclesTextField;
    private JLabel jCyclesLabel;
    private JTextField sqSizeTextField;
    private JTextField jEpsilonTextField;
    private JTextField pjogTextField;
    private JLabel JLabelPJOG;
    private JLabel jLabelEpsilon;
    private Maze myMaze = null;
    private PrioritizedSweeping ps;
    private boolean ShowValue = true;
    private boolean ShowPolicy = true;
    private boolean Animate = true;
    private boolean Analyze = true;
    DecimalFormat df = new DecimalFormat("0.0");
    private JScrollPane jScrollPane;
    private String mazeStatus = "Load Maze First...";
    private String algorithmStatus = "";
    private JCheckBox jAnimateCheckBox;
    private JButton jCycleButton;
    private JButton jEpisodeButton;
    private JButton jInitializeButton;
    private JButton jUpdateButton;
    public int sqSize = 80;
    int X = 186;
    int Y = 100;
    Color GoldColor = new Color(200, 100, 55);
    private JLabel jLabelTinyThreshold;
    private JTextField jTinyThresholdTextField;

    public static void main(String[] args) {
        PSSimulator inst = new PSSimulator();
        inst.setVisible(true);
    }

    public PSSimulator() {
        super("RL-MDP:Simulation");
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setSize(1000, 800);
            this.setExtendedState(6);
            this.setDefaultCloseOperation(2);
            this.jPanel = new JPanel();
            this.jPanel.setLayout(null);
            this.jPanel.setBackground(new Color(235, 241, 238));
            this.jPanel.setPreferredSize(new Dimension(900, 700));
            this.getContentPane().add((Component)this.jPanel, "Center");
            this.jLoadButton = new JButton();
            this.jPanel.add(this.jLoadButton);
            this.jLoadButton.setText("LoadMaze...");
            this.jLoadButton.setBounds(25, 62, 110, 28);
            this.jLoadButton.setActionCommand("LoadMaze");
            this.jLoadButton.addActionListener(this);
            this.JLabelPJOG = new JLabel();
            this.jPanel.add(this.JLabelPJOG);
            this.JLabelPJOG.setText("PJOG");
            this.JLabelPJOG.setBounds(20, 126, 70, 21);
            this.JLabelPJOG.setHorizontalAlignment(4);
            this.pjogTextField = new JTextField();
            this.jPanel.add(this.pjogTextField);
            this.pjogTextField.setText("0.3");
            this.pjogTextField.setBounds(95, 125, 40, 20);
            this.pjogTextField.setHorizontalAlignment(4);
            this.jMaxBULabel = new JLabel();
            this.jPanel.add(this.jMaxBULabel);
            this.jMaxBULabel.setText("Max BackUps");
            this.jMaxBULabel.setBounds(20, 147, 70, 21);
            this.jMaxBULabel.setHorizontalAlignment(4);
            this.jMaxBackUpsTextField = new JTextField();
            this.jPanel.add(this.jMaxBackUpsTextField);
            this.jMaxBackUpsTextField.setText("50");
            this.jMaxBackUpsTextField.setBounds(95, 149, 40, 20);
            this.jMaxBackUpsTextField.setHorizontalAlignment(4);
            this.jLabelEpsilon = new JLabel();
            this.jPanel.add(this.jLabelEpsilon);
            this.jLabelEpsilon.setText("Epsilon");
            this.jLabelEpsilon.setBounds(20, 171, 70, 21);
            this.jLabelEpsilon.setHorizontalAlignment(4);
            this.jEpsilonTextField = new JTextField();
            this.jPanel.add(this.jEpsilonTextField);
            this.jEpsilonTextField.setText("0.1");
            this.jEpsilonTextField.setBounds(95, 174, 40, 20);
            this.jEpsilonTextField.setHorizontalAlignment(4);
            this.jLabelTinyThreshold = new JLabel();
            this.jPanel.add(this.jLabelTinyThreshold);
            this.jLabelTinyThreshold.setText("Tiny Threshold");
            this.jLabelTinyThreshold.setBounds(20, 195, 70, 21);
            this.jLabelTinyThreshold.setHorizontalAlignment(4);
            this.jTinyThresholdTextField = new JTextField();
            this.jPanel.add(this.jTinyThresholdTextField);
            this.jTinyThresholdTextField.setText("0.01");
            this.jTinyThresholdTextField.setBounds(95, 198, 40, 20);
            this.jTinyThresholdTextField.setHorizontalAlignment(4);
            this.jInitializeButton = new JButton();
            this.jPanel.add(this.jInitializeButton);
            this.jInitializeButton.setText("Initialize");
            this.jInitializeButton.setBounds(25, 223, 110, 28);
            this.jInitializeButton.addActionListener(this);
            this.jInitializeButton.setActionCommand("Initialize");
            this.jUpdateButton = new JButton();
            this.jPanel.add(this.jUpdateButton);
            this.jUpdateButton.setText("Update");
            this.jUpdateButton.setBounds(25, 258, 110, 28);
            this.jUpdateButton.setActionCommand("Update");
            this.jUpdateButton.addActionListener(this);
            this.jStepButton = new JButton();
            this.jPanel.add(this.jStepButton);
            this.jStepButton.setText("Step");
            this.jStepButton.setBounds(25, 314, 110, 28);
            this.jStepButton.addActionListener(this);
            this.jStepButton.setActionCommand("Step");
            this.jEpisodeButton = new JButton();
            this.jPanel.add(this.jEpisodeButton);
            this.jEpisodeButton.setText("Episode");
            this.jEpisodeButton.setBounds(25, 350, 110, 28);
            this.jEpisodeButton.addActionListener(this);
            this.jEpisodeButton.setActionCommand("Episode");
            this.jCyclesTextField = new JTextField();
            this.jPanel.add(this.jCyclesTextField);
            this.jCyclesTextField.setText("1000");
            this.jCyclesTextField.setBounds(25, 387, 35, 26);
            this.jCycleButton = new JButton();
            this.jPanel.add(this.jCycleButton);
            this.jCycleButton.setText("Cycles");
            this.jCycleButton.setBounds(65, 386, 70, 28);
            this.jCycleButton.addActionListener(this);
            this.jCycleButton.setActionCommand("Cycles");
            this.jLabelSqSize = new JLabel();
            this.jPanel.add(this.jLabelSqSize);
            this.jLabelSqSize.setText("Square Size");
            this.jLabelSqSize.setBounds(20, 445, 70, 21);
            this.jLabelSqSize.setHorizontalAlignment(4);
            this.sqSizeTextField = new JTextField();
            this.jPanel.add(this.sqSizeTextField);
            this.sqSizeTextField.setText("80");
            this.sqSizeTextField.setBounds(96, 446, 40, 20);
            this.sqSizeTextField.setHorizontalAlignment(4);
            this.sqSizeTextField.addActionListener(this);
            this.jDelayLabel = new JLabel();
            this.jPanel.add(this.jDelayLabel);
            this.jDelayLabel.setText("Delay(in ms)");
            this.jDelayLabel.setBounds(22, 470, 70, 21);
            this.jDelayLabel.setHorizontalAlignment(4);
            this.jDelayTextField = new JTextField();
            this.jPanel.add(this.jDelayTextField);
            this.jDelayTextField.setText("30");
            this.jDelayTextField.setBounds(96, 472, 40, 20);
            this.jDelayTextField.setHorizontalAlignment(4);
            this.jRefreshButton = new JButton();
            this.jPanel.add(this.jRefreshButton);
            this.jRefreshButton.setText("Refresh");
            this.jRefreshButton.setBounds(26, 500, 110, 28);
            this.jRefreshButton.setActionCommand("Refresh");
            this.jRefreshButton.addActionListener(this);
            this.jValuesCheckBox = new JCheckBox();
            this.jPanel.add(this.jValuesCheckBox);
            this.jValuesCheckBox.setText("Show Values");
            this.jValuesCheckBox.setBounds(35, 553, 93, 17);
            this.jValuesCheckBox.setOpaque(false);
            this.jValuesCheckBox.setSelected(true);
            this.jValuesCheckBox.addActionListener(this);
            this.jPolicyCheckBox = new JCheckBox();
            this.jPanel.add(this.jPolicyCheckBox);
            this.jPolicyCheckBox.setText("Show Policy");
            this.jPolicyCheckBox.setBounds(35, 573, 85, 17);
            this.jPolicyCheckBox.setOpaque(false);
            this.jPolicyCheckBox.setSelected(true);
            this.jPolicyCheckBox.addActionListener(this);
            this.jAnimateCheckBox = new JCheckBox();
            this.jPanel.add(this.jAnimateCheckBox);
            this.jAnimateCheckBox.setText("Animate");
            this.jAnimateCheckBox.setBounds(35, 593, 85, 17);
            this.jAnimateCheckBox.setOpaque(false);
            this.jAnimateCheckBox.setSelected(true);
            this.jAnimateCheckBox.addActionListener(this);
            this.jSeparator1 = new JSeparator();
            this.jPanel.add(this.jSeparator1);
            this.jSeparator1.setBounds(161, 2, 4, 400);
            this.jSeparator1.setBorder(BorderFactory.createTitledBorder(null, "", 4, 2, new Font("MS Sans Serif", 0, 11), new Color(0, 0, 0)));
            this.jStatusLabel = new JLabel();
            this.jPanel.add(this.jStatusLabel);
            this.jStatusLabel.setText("Load Maze First...");
            this.jStatusLabel.setBounds(182, 14, 770, 34);
            this.jStatusLabel.setBackground(new Color(192, 192, 192));
            this.jStatusLabel.setBorder(BorderFactory.createTitledBorder(null, "", 4, 2, new Font("MS Sans Serif", 0, 11), new Color(0, 0, 0)));
            this.jStatusLabel.setFont(new Font("Georgia", 1, 12));
            this.jStatusLabel.setDebugGraphicsOptions(-1);
            this.jStatusLabel.setOpaque(true);
            this.jStatusLabel.setHorizontalAlignment(0);
            this.jStatusLabel.setPreferredSize(new Dimension(984, 35));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void actionPerformed(ActionEvent evt) {
        block19: {
            block24: {
                block23: {
                    block22: {
                        block21: {
                            block20: {
                                block18: {
                                    if (!evt.getActionCommand().equals("LoadMaze")) break block18;
                                    Utility.show("Loading maze");
                                    this.fc = new JFileChooser("./mazes/");
                                    returnVal = this.fc.showOpenDialog(this);
                                    if (returnVal == 0) {
                                        try {
                                            file = this.fc.getSelectedFile();
                                            fis = new FileInputStream(file);
                                            gzis = new GZIPInputStream(fis);
                                            in = new ObjectInputStream(gzis);
                                            this.myMaze = (Maze)in.readObject();
                                            in.close();
                                            this.mazeStatus = " [ " + this.myMaze.width + " X " + this.myMaze.height + " Maze, Wall Penalty:" + ((Wall)this.myMaze.walls.get((int)0)).penalty + "] | ";
                                            this.algorithmStatus = " Prioritized Sweeping --> Click Initialize";
                                            this.sqSize = (int)Math.min(Math.floor((this.getSize().width - this.X - 10) / this.myMaze.width), Math.floor((this.getSize().height - this.Y - 10) / this.myMaze.height));
                                            if (this.sqSize > 200) {
                                                this.sqSize = 200;
                                            }
                                            this.sqSizeTextField.setText("" + this.sqSize);
                                        }
                                        catch (Exception e) {
                                            Utility.show(e.getMessage());
                                        }
                                        this.ps = null;
                                    }
                                    this.repaint();
                                    break block19;
                                }
                                if (!evt.getActionCommand().equals("Initialize") || this.myMaze == null) break block20;
                                Utility.show("prioritized sweeping");
                                pjog = Double.parseDouble(this.pjogTextField.getText());
                                MaxBackUps = Integer.parseInt(this.jMaxBackUpsTextField.getText());
                                epsilon = Double.parseDouble(this.jEpsilonTextField.getText());
                                tinyThreshold = Double.parseDouble(this.jEpsilonTextField.getText());
                                this.ps = new PrioritizedSweeping(this.myMaze, pjog, epsilon, MaxBackUps, tinyThreshold);
                                this.algorithmStatus = " Prioritized Sweeping ";
                                this.repaint();
                                break block19;
                            }
                            if (!evt.getActionCommand().equals("Update") || this.ps == null) break block21;
                            this.ps.setProperty(PrioritizedSweeping.Properties.PJOG, this.pjogTextField.getText());
                            this.ps.setProperty(PrioritizedSweeping.Properties.Epsilon, this.jEpsilonTextField.getText());
                            this.ps.setProperty(PrioritizedSweeping.Properties.MaxBackups, this.jMaxBackUpsTextField.getText());
                            this.ps.setProperty(PrioritizedSweeping.Properties.TinyThreshold, this.jTinyThresholdTextField.getText());
                            break block19;
                        }
                        if (!evt.getActionCommand().equals("Episode")) break block22;
                        Utility.show("Episode");
                        delay = Integer.parseInt(this.jDelayTextField.getText());
                        if (this.ps != null) {
                            while (!this.ps.step()) {
                                if (!this.Animate) continue;
                                Utility.delay(delay);
                                this.myUpdate(this.getGraphics());
                            }
                            this.repaint();
                        }
                        break block19;
                    }
                    if (!evt.getActionCommand().equals("Step")) break block23;
                    Utility.show("step");
                    if (this.ps != null && this.ps.step()) {
                        this.jStatusLabel.setText("Goal Reached");
                    }
                    this.repaint();
                    break block19;
                }
                if (!evt.getActionCommand().equals("Cycles")) break block24;
                Utility.show("Cycles");
                delay = Integer.parseInt(this.jDelayTextField.getText());
                numCycles = Integer.parseInt(this.jCyclesTextField.getText());
                if (this.ps == null) break block19;
                i = 0;
                ** GOTO lbl76
                {
                    if (this.Animate) {
                        Utility.delay(delay);
                        this.myUpdate(this.getGraphics());
                    }
                    do {
                        if (!this.ps.step()) continue block3;
                        ++i;
lbl76:
                        // 2 sources

                    } while (i < numCycles);
                }
                this.repaint();
                break block19;
            }
            if (evt.getActionCommand().equals("Refresh")) {
                Utility.show("Refresh");
                this.repaint();
            } else if (evt.getSource().getClass().getName().equals("javax.swing.JTextField")) {
                this.repaint();
            } else if (evt.getSource().getClass().getName().equals("javax.swing.JCheckBox")) {
                jcb = (JCheckBox)evt.getSource();
                if (jcb.getText().equals("Show Values")) {
                    this.ShowValue = jcb.isSelected();
                }
                if (jcb.getText().equals("Show Policy")) {
                    this.ShowPolicy = jcb.isSelected();
                }
                if (jcb.getText().equals("Animate")) {
                    this.Animate = jcb.isSelected();
                }
                this.repaint();
            }
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.myUpdate(g);
    }

    public void myUpdate(Graphics g) {
        this.jSeparator1.setSize(4, this.jPanel.getBounds().height - 2);
        this.jStatusLabel.setText(String.valueOf(this.mazeStatus) + this.algorithmStatus);
        this.showGrid(this.getGraphics());
    }

    public void showGrid(Graphics g) {
        this.sqSize = Integer.parseInt(this.sqSizeTextField.getText());
        if (this.ps != null) {
            this.drawValues(g);
            if (this.ShowPolicy) {
                this.drawPolicy(g);
            }
        }
        if (this.myMaze != null) {
            this.drawMaze(g);
            this.drawGoal(g);
            this.drawWalls(g);
        }
        if (this.ps != null) {
            this.drawCurrPosition(g, this.ps.getCurrState());
        }
        if (this.ps != null) {
            this.ps.getClass();
        }
    }

    void drawMaze(Graphics g) {
        g.setColor(Color.black);
        int counter = 0;
        while (counter <= this.myMaze.width) {
            g.drawLine(this.X + this.sqSize * counter, this.Y + 0, this.X + this.sqSize * counter, this.Y + this.sqSize * this.myMaze.height);
            ++counter;
        }
        counter = 0;
        while (counter <= this.myMaze.height) {
            g.drawLine(this.X + 0, this.Y + this.sqSize * counter, this.X + this.sqSize * this.myMaze.width, this.Y + this.sqSize * counter);
            ++counter;
        }
    }

    void drawGoal(Graphics g) {
        Vector goals = this.myMaze.goals;
        int i = 0;
        while (i < goals.size()) {
            State s = (State)goals.get(i);
            GraphicsUtil.fillRect(g, this.X + s.x * this.sqSize + 1, this.Y + (this.myMaze.height - 1 - s.y) * this.sqSize + 1, this.sqSize - 2, this.sqSize - 2, this.GoldColor);
            ++i;
        }
    }

    void drawWalls(Graphics g) {
        GraphicsUtil gr = new GraphicsUtil();
        int i = 0;
        while (i < this.myMaze.walls.size()) {
            Wall w = (Wall)this.myMaze.walls.get(i);
            int nodeX = w.x;
            int nodeY = w.y;
            switch (w.dir) {
                case 0: {
                    int aX = nodeX * this.sqSize;
                    int bX = (nodeX + 1) * this.sqSize;
                    int aY = (this.myMaze.height - nodeY - 1) * this.sqSize;
                    int bY = (this.myMaze.height - nodeY - 1) * this.sqSize;
                    GraphicsUtil.drawLine(g, this.X + aX, this.Y + aY, this.X + bX, this.Y + bY, 5);
                    break;
                }
                case 2: {
                    int aX = nodeX * this.sqSize;
                    int bX = (nodeX + 1) * this.sqSize;
                    int aY = (this.myMaze.height - nodeY) * this.sqSize;
                    int bY = (this.myMaze.height - nodeY) * this.sqSize;
                    GraphicsUtil.drawLine(g, this.X + aX, this.Y + aY, this.X + bX, this.Y + bY, 5);
                    break;
                }
                case 1: {
                    int aX = (nodeX + 1) * this.sqSize;
                    int bX = (nodeX + 1) * this.sqSize;
                    int aY = (this.myMaze.height - nodeY - 1) * this.sqSize;
                    int bY = (this.myMaze.height - nodeY) * this.sqSize;
                    GraphicsUtil.drawLine(g, this.X + aX, this.Y + aY, this.X + bX, this.Y + bY, 5);
                    break;
                }
                case 3: {
                    int aX = nodeX * this.sqSize;
                    int bX = nodeX * this.sqSize;
                    int aY = (this.myMaze.height - nodeY) * this.sqSize;
                    int bY = (this.myMaze.height - nodeY - 1) * this.sqSize;
                    GraphicsUtil.drawLine(g, this.X + aX, this.Y + aY, this.X + bX, this.Y + bY, 5);
                }
            }
            ++i;
        }
    }

    void drawCurrPosition(Graphics g, State s) {
        int centreX = this.sqSize * s.x + this.sqSize / 2;
        int centreY = this.sqSize * (this.myMaze.height - 1 - s.y) + this.sqSize / 2;
        int radius = this.sqSize / 5;
        Color c = Color.MAGENTA;
        if (!this.ps.isBestAct) {
            c = Color.YELLOW;
        }
        GraphicsUtil.fillCircle(g, this.X + centreX, this.Y + centreY, radius, c);
        GraphicsUtil.drawCircle(g, this.X + centreX, this.Y + centreY, radius, 1, Color.black);
        GraphicsUtil.drawCircle(g, this.X + centreX - radius / 3, this.Y + centreY - radius / 3, radius / 6, 1, Color.black);
        GraphicsUtil.drawCircle(g, this.X + centreX - radius / 3, this.Y + centreY - radius / 3, 1, 1, Color.black);
        GraphicsUtil.drawCircle(g, this.X + centreX + radius / 3, this.Y + centreY - radius / 3, radius / 6, 1, Color.black);
        GraphicsUtil.drawCircle(g, this.X + centreX + radius / 3, this.Y + centreY - radius / 3, 1, 1, Color.black);
        if (this.ps.receivedPenalty) {
            GraphicsUtil.drawArc(g, this.X + centreX - radius / 2, this.Y + centreY + radius / 3, radius, 2 * radius / 3, 0, 180, Color.black);
        } else {
            GraphicsUtil.drawArc(g, this.X + centreX - radius / 2, this.Y + centreY, radius, 2 * radius / 3, 0, -180, Color.black);
        }
    }

    void drawPolicy(Graphics g) {
        int[][] p = this.ps.getPolicy();
        int x1 = 0;
        int x2 = 0;
        int y1 = 0;
        int y2 = 0;
        g.setColor(Color.WHITE);
        int i = 0;
        while (i < p.length) {
            int j = 0;
            while (j < p[i].length) {
                block8: {
                    x1 = i * this.sqSize + this.sqSize / 2;
                    y1 = (this.myMaze.height - 1 - j) * this.sqSize + this.sqSize / 2;
                    switch (p[i][j]) {
                        case 0: {
                            x2 = x1;
                            y2 = (this.myMaze.height - 1 - j) * this.sqSize;
                            break;
                        }
                        case 3: {
                            x2 = i * this.sqSize;
                            y2 = y1;
                            break;
                        }
                        case 2: {
                            x2 = x1;
                            y2 = (this.myMaze.height - 1 - j) * this.sqSize + this.sqSize;
                            break;
                        }
                        case 1: {
                            x2 = i * this.sqSize + this.sqSize;
                            y2 = y1;
                            break;
                        }
                        default: {
                            break block8;
                        }
                    }
                    g.drawLine(this.X + x1, this.Y + y1, this.X + x2, this.Y + y2);
                }
                ++j;
            }
            ++i;
        }
    }

    void drawValues(Graphics g) {
        ValueFunction valuefunc = this.ps.getValueFunction();
        double[][] values = valuefunc.stateValue;
        int max = 1 + (int)Math.ceil(valuefunc.getMax());
        double[][][] qsa = this.ps.getQsa();
        Vector backedUpStates = this.ps.getBackedUpStates();
        int xval = 0;
        while (xval < this.myMaze.width) {
            int y = 0;
            while (y < this.myMaze.height) {
                int yval = this.myMaze.height - 1 - y;
                if (values[xval][y] >= 0.0) {
                    int red = 155 - Math.min((int)(255.0 * values[xval][y] / (double)max), 155);
                    int green = 155 - Math.min((int)(255.0 * values[xval][y] / (double)max), 155);
                    int b = 255 - Math.min((int)(255.0 * values[xval][y] / (double)max), 220);
                    g.setColor(new Color(red, green, b));
                } else {
                    g.setColor(this.GoldColor);
                }
                g.fillRect(this.X + xval * this.sqSize + 1, this.Y + yval * this.sqSize + 1, this.sqSize - 1, this.sqSize - 1);
                ++y;
            }
            ++xval;
        }
        if (!this.ShowValue) {
            return;
        }
        g.setColor(Color.WHITE);
        int i = 0;
        while (i < backedUpStates.size()) {
            State temp = (State)backedUpStates.get(i);
            g.drawString("*", this.X + temp.x * this.sqSize + 5, this.Y + (this.myMaze.height - 1 - temp.y) * this.sqSize + 15);
            ++i;
        }
        i = 0;
        while (i < qsa.length) {
            int j = 0;
            while (j < qsa[i].length) {
                g.drawString(this.df.format(qsa[i][j][0]), this.X + i * this.sqSize + this.sqSize / 2 - 5, this.Y + (this.myMaze.height - j) * this.sqSize - this.sqSize + 15);
                g.drawString(this.df.format(qsa[i][j][1]), this.X + i * this.sqSize + this.sqSize - 20, this.Y + (this.myMaze.height - j) * this.sqSize - this.sqSize / 2);
                g.drawString(this.df.format(qsa[i][j][2]), this.X + i * this.sqSize + this.sqSize / 2 - 5, this.Y + (this.myMaze.height - j) * this.sqSize - 5);
                g.drawString(this.df.format(qsa[i][j][3]), this.X + i * this.sqSize + 5, this.Y + (this.myMaze.height - j) * this.sqSize - this.sqSize / 2);
                ++j;
            }
            ++i;
        }
    }
}

