/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class MazeEditor
extends JFrame
implements ActionListener {
    private JPanel jPanel;
    private JButton jHeight;
    private JButton jWidth;
    private JButton jWalls;
    private JButton jSetPenalty;
    private JButton jAddGoals;
    private JButton jSaveMaze;
    private JButton jBoxSize;
    private JButton jResetMaze;
    private JTextField jHeightTextField;
    private JTextField jWidthTextField;
    private JTextField jPenaltyTextField;
    private JTextField jBoundaryPenaltyTextField;
    private JTextField jBoxSizeTextField;
    private JPanel jGridPanel;
    private JSeparator jSeparator1;
    private SymMouse aSymMouse;
    private Maze myMaze;
    private int penalty = 0;
    private int boundaryPenalty = 0;
    int nodeLength = 40;
    private boolean boundariesAdded = false;
    private int edit_state;
    public static int EDIT_WALLS = 1;
    public static int ADD_GOALS = 2;
    public static int ADD_START = 3;
    public static int ASSIGN_REWARD = 4;
    private JButton jLoadMaze;

    public static void main(String[] args) {
        MazeEditor inst = new MazeEditor();
        inst.setVisible(true);
    }

    public MazeEditor() {
        super("RL-MDP:Maze Editor");
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.myMaze = new Maze(2, 2);
            this.setSize(600, 600);
            this.setExtendedState(6);
            this.setDefaultCloseOperation(2);
            this.aSymMouse = new SymMouse();
            this.jPanel = new JPanel();
            this.getContentPane().add((Component)this.jPanel, "Center");
            this.jPanel.setBackground(new Color(235, 241, 238));
            this.jPanel.setLayout(null);
            this.jHeight = new JButton();
            this.jPanel.add(this.jHeight);
            this.jHeight.setText("Height");
            this.jHeight.setBounds(70, 5, 90, 25);
            this.jHeight.addActionListener(this);
            this.jHeightTextField = new JTextField("2");
            this.jHeightTextField.setBounds(5, 5, 65, 25);
            this.jPanel.add(this.jHeightTextField);
            this.jWidth = new JButton();
            this.jPanel.add(this.jWidth);
            this.jWidth.setText("Width");
            this.jWidth.setBounds(70, 35, 90, 25);
            this.jWidth.addActionListener(this);
            this.jWidthTextField = new JTextField("2");
            this.jWidthTextField.setBounds(5, 35, 65, 25);
            this.jPanel.add(this.jWidthTextField);
            this.jSetPenalty = new JButton();
            this.jPanel.add(this.jSetPenalty);
            this.jSetPenalty.setText("Set Penalty");
            this.jSetPenalty.setBounds(70, 65, 90, 25);
            this.jSetPenalty.addActionListener(this);
            this.jPenaltyTextField = new JTextField("50");
            this.jPenaltyTextField.setBounds(5, 65, 65, 25);
            this.jPanel.add(this.jPenaltyTextField);
            this.jWalls = new JButton();
            this.jPanel.add(this.jWalls);
            this.jWalls.setText("Add Walls");
            this.jWalls.setBounds(5, 95, 155, 25);
            this.jWalls.addActionListener(this);
            this.jAddGoals = new JButton();
            this.jPanel.add(this.jAddGoals);
            this.jAddGoals.setText("Add Goals");
            this.jAddGoals.setBounds(5, 125, 155, 25);
            this.jAddGoals.addActionListener(this);
            this.jSaveMaze = new JButton();
            this.jPanel.add(this.jSaveMaze);
            this.jSaveMaze.setText("Save Maze");
            this.jSaveMaze.setBounds(5, 155, 155, 25);
            this.jSaveMaze.addActionListener(this);
            this.jBoxSize = new JButton();
            this.jPanel.add(this.jBoxSize);
            this.jBoxSize.setText("Box Size");
            this.jBoxSize.setBounds(75, 185, 85, 25);
            this.jBoxSize.addActionListener(this);
            this.jBoxSizeTextField = new JTextField("40");
            this.jBoxSizeTextField.setBounds(5, 185, 65, 25);
            this.jPanel.add(this.jBoxSizeTextField);
            this.jResetMaze = new JButton();
            this.jPanel.add(this.jResetMaze);
            this.jResetMaze.setText("Reset Maze");
            this.jResetMaze.setBounds(5, 215, 155, 25);
            this.jResetMaze.addActionListener(this);
            this.jLoadMaze = new JButton();
            this.jPanel.add(this.jLoadMaze);
            this.jLoadMaze.setText("Load Maze");
            this.jLoadMaze.setBounds(5, 245, 155, 25);
            this.jLoadMaze.addActionListener(this);
            this.jSeparator1 = new JSeparator();
            this.jPanel.add(this.jSeparator1);
            this.jSeparator1.setBounds(188, 2, 2, 363);
            this.jSeparator1.setBorder(BorderFactory.createTitledBorder(null, "", 4, 2, new Font("MS Sans Serif", 0, 11), new Color(0, 0, 0)));
            this.jGridPanel = new GridPanel();
            this.jPanel.add(this.jGridPanel);
            this.jGridPanel.addMouseListener(this.aSymMouse);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.jLoadMaze) {
            this.loadFile();
            this.repaint();
        } else if (evt.getSource() == this.jHeight) {
            int a;
            this.myMaze.height = a = Integer.parseInt(this.jHeightTextField.getText());
            this.repaint();
        } else if (evt.getSource() == this.jWidth) {
            int a;
            this.myMaze.width = a = Integer.parseInt(this.jWidthTextField.getText());
            this.repaint();
        } else if (evt.getSource() == this.jWalls) {
            this.edit_state = 1;
            if (!this.boundariesAdded) {
                this.addBoundaries();
            }
            this.repaint();
        } else if (evt.getSource() == this.jSetPenalty) {
            this.penalty = Integer.parseInt(this.jPenaltyTextField.getText());
        } else if (evt.getSource() == this.jAddGoals) {
            this.edit_state = 2;
        } else if (evt.getSource() == this.jSaveMaze) {
            this.saveFile();
        } else if (evt.getSource() == this.jBoxSize) {
            this.nodeLength = Integer.parseInt(this.jBoxSizeTextField.getText());
            this.repaint();
        } else if (evt.getSource() == this.jResetMaze) {
            this.myMaze.height = 2;
            this.myMaze.width = 2;
            this.myMaze.walls.clear();
            this.myMaze.goals.clear();
            this.boundariesAdded = false;
            this.repaint();
        }
    }

    void plotMaze(Graphics2D g) {
        boolean startx = false;
        boolean starty = false;
        int i = 0;
        while (i <= this.nodeLength * this.myMaze.width) {
            g.drawLine(i + 0, 0, i + 0, 0 + this.nodeLength * this.myMaze.height);
            i += this.nodeLength;
        }
        i = 0;
        while (i <= this.nodeLength * this.myMaze.height) {
            g.drawLine(0, i + 0, 0 + this.nodeLength * this.myMaze.width, i + 0);
            i += this.nodeLength;
        }
    }

    void drawWalls(Graphics g) {
        GraphicsUtil gr = new GraphicsUtil();
        Vector wall = new Vector(this.myMaze.walls);
        Wall w = new Wall();
        this.myMaze.printWalls();
        int i = 0;
        while (i < this.myMaze.walls.size()) {
            w = (Wall)wall.get(i);
            int nodeX = w.x;
            int nodeY = w.y;
            switch (w.dir) {
                case 0: {
                    int aX = nodeX * this.nodeLength;
                    int bX = (nodeX + 1) * this.nodeLength;
                    int aY = (this.myMaze.height - nodeY - 1) * this.nodeLength;
                    int bY = (this.myMaze.height - nodeY - 1) * this.nodeLength;
                    GraphicsUtil.drawLine(g, aX, aY, bX, bY, 5);
                    break;
                }
                case 2: {
                    int aX = nodeX * this.nodeLength;
                    int bX = (nodeX + 1) * this.nodeLength;
                    int aY = (this.myMaze.height - nodeY) * this.nodeLength;
                    int bY = (this.myMaze.height - nodeY) * this.nodeLength;
                    GraphicsUtil.drawLine(g, aX, aY, bX, bY, 5);
                    break;
                }
                case 1: {
                    int aX = (nodeX + 1) * this.nodeLength;
                    int bX = (nodeX + 1) * this.nodeLength;
                    int aY = (this.myMaze.height - nodeY - 1) * this.nodeLength;
                    int bY = (this.myMaze.height - nodeY) * this.nodeLength;
                    GraphicsUtil.drawLine(g, aX, aY, bX, bY, 5);
                    break;
                }
                case 3: {
                    int aX = nodeX * this.nodeLength;
                    int bX = nodeX * this.nodeLength;
                    int aY = (this.myMaze.height - nodeY) * this.nodeLength;
                    int bY = (this.myMaze.height - nodeY - 1) * this.nodeLength;
                    GraphicsUtil.drawLine(g, aX, aY, bX, bY, 5);
                }
            }
            ++i;
        }
    }

    void drawGoals(Graphics g) {
        int i = 0;
        while (i < this.myMaze.goals.size()) {
            State curr = (State)this.myMaze.goals.get(i);
            int left = curr.x * this.nodeLength;
            int top = (this.myMaze.height - curr.y - 1) * this.nodeLength;
            int width = this.nodeLength;
            int height = this.nodeLength;
            GraphicsUtil.fillRect(g, left, top, width, height, new Color(252, 139, 37));
            ++i;
        }
    }

    void loadFile() {
        JFileChooser fc = new JFileChooser("./mazes/");
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            try {
                File file = fc.getSelectedFile();
                FileInputStream fis = new FileInputStream(file);
                GZIPInputStream gzis = new GZIPInputStream(fis);
                ObjectInputStream in = new ObjectInputStream(gzis);
                this.myMaze = (Maze)in.readObject();
                in.close();
            }
            catch (Exception e) {
                Utility.show(e.getMessage());
            }
        }
    }

    void saveFile() {
        JFileChooser fc = new JFileChooser("./mazes/");
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            try {
                File file = fc.getSelectedFile();
                FileOutputStream fos = new FileOutputStream(file);
                GZIPOutputStream gzos = new GZIPOutputStream(fos);
                ObjectOutputStream out = new ObjectOutputStream(gzos);
                out.writeObject(this.myMaze);
                out.flush();
                out.close();
            }
            catch (Exception e) {
                Utility.show(e.getMessage());
            }
        }
    }

    void addBoundaries() {
        this.boundariesAdded = true;
        int j = 0;
        this.boundaryPenalty = this.penalty;
        int i = 0;
        while (i < this.myMaze.width) {
            this.myMaze.addWall(new Wall(i, j, 2, this.boundaryPenalty));
            ++i;
        }
        j = this.myMaze.height - 1;
        i = 0;
        while (i < this.myMaze.width) {
            this.myMaze.addWall(new Wall(i, j, 0, this.boundaryPenalty));
            ++i;
        }
        i = 0;
        j = 0;
        while (j < this.myMaze.width) {
            this.myMaze.addWall(new Wall(i, j, 3, this.boundaryPenalty));
            ++j;
        }
        i = this.myMaze.width - 1;
        j = 0;
        while (j < this.myMaze.width) {
            this.myMaze.addWall(new Wall(i, j, 1, this.boundaryPenalty));
            ++j;
        }
    }

    private class GridPanel
    extends JPanel {
        public GridPanel() {
            GridLayout jGridPanelLayout = new GridLayout(15, 15);
            jGridPanelLayout.setRows(10);
            jGridPanelLayout.setColumns(10);
            this.setLayout(jGridPanelLayout);
            this.setLocation(230, 50);
            this.setSize(10, 10);
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            this.setSize(((MazeEditor)MazeEditor.this).myMaze.width * MazeEditor.this.nodeLength + 4, ((MazeEditor)MazeEditor.this).myMaze.height * MazeEditor.this.nodeLength + 4);
            MazeEditor.this.drawGoals(g);
            MazeEditor.this.plotMaze(g2);
            MazeEditor.this.drawWalls(g2);
        }
    }

    class SymMouse
    extends MouseAdapter {
        SymMouse() {
        }

        public void mouseClicked(MouseEvent event) {
            Object object = event.getSource();
            int clickX = event.getX();
            int clickY = MazeEditor.this.nodeLength * ((MazeEditor)MazeEditor.this).myMaze.height - event.getY();
            int nodeX = clickX / MazeEditor.this.nodeLength;
            int nodeY = clickY / MazeEditor.this.nodeLength;
            switch (MazeEditor.this.edit_state) {
                case 1: {
                    int lowerLimX = nodeX * MazeEditor.this.nodeLength + (int)(0.1 * (double)MazeEditor.this.nodeLength);
                    int upperLimX = (nodeX + 1) * MazeEditor.this.nodeLength - (int)(0.1 * (double)MazeEditor.this.nodeLength);
                    if (clickX < lowerLimX) {
                        MazeEditor.this.myMaze.addWall(new Wall(nodeX, nodeY, 3, MazeEditor.this.penalty));
                        MazeEditor.this.myMaze.addWall(new Wall(nodeX - 1, nodeY, 1, MazeEditor.this.penalty));
                    } else if (clickX > upperLimX) {
                        MazeEditor.this.myMaze.addWall(new Wall(nodeX, nodeY, 1, MazeEditor.this.penalty));
                        MazeEditor.this.myMaze.addWall(new Wall(nodeX + 1, nodeY, 3, MazeEditor.this.penalty));
                    }
                    int lowerLimY = nodeY * MazeEditor.this.nodeLength + (int)(0.1 * (double)MazeEditor.this.nodeLength);
                    int upperLimY = (nodeY + 1) * MazeEditor.this.nodeLength - (int)(0.1 * (double)MazeEditor.this.nodeLength);
                    if (clickY < lowerLimY) {
                        MazeEditor.this.myMaze.addWall(new Wall(nodeX, nodeY, 2, MazeEditor.this.penalty));
                        MazeEditor.this.myMaze.addWall(new Wall(nodeX, nodeY - 1, 0, MazeEditor.this.penalty));
                    } else if (clickY > upperLimY) {
                        MazeEditor.this.myMaze.addWall(new Wall(nodeX, nodeY, 0, MazeEditor.this.penalty));
                        MazeEditor.this.myMaze.addWall(new Wall(nodeX, nodeY + 1, 2, MazeEditor.this.penalty));
                    }
                    MazeEditor.this.repaint();
                    break;
                }
                case 2: {
                    System.out.print("trying to add goals at ");
                    System.out.println("nodeX,nodeY= " + nodeX + "," + nodeY);
                    MazeEditor.this.myMaze.addGoal(new State(nodeX, nodeY));
                    MazeEditor.this.myMaze.printGoals();
                    MazeEditor.this.repaint();
                    break;
                }
                case 3: {
                    System.out.println("trying to add starts");
                    break;
                }
                case 4: {
                    System.out.println("trying to assign rewards");
                }
            }
        }
    }
}

