/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;
import java.io.Serializable;
import java.util.Vector;

public class Maze
implements Serializable {
    public int height;
    public int width;
    public Vector goals;
    public Vector starts;
    Vector walls;

    public Maze(int _width, int _height) {
        this.width = _width;
        this.height = _height;
        this.walls = new Vector();
        this.goals = new Vector();
        this.starts = new Vector();
    }

    void addStart(State st) {
        this.starts.add(st);
    }

    void addGoal(State st) {
        if (st.x < 0 || st.y < 0 || st.x >= this.width || st.y >= this.height) {
            return;
        }
        if (!this.goals.contains(st)) {
            this.goals.add(st);
        } else {
            this.goals.remove(st);
        }
    }

    void display() {
        int y = 0;
        while (y < this.height) {
            int x = 0;
            while (x < this.width) {
                Point curr = new Point(y, x);
                if (this.walls.indexOf(curr) == -1) {
                    System.out.print("0 ");
                } else {
                    System.out.print("1 ");
                }
                ++x;
            }
            System.out.println();
            ++y;
        }
    }

    public boolean isValidTransition(State curr, State st) {
        Wall possibleWall = new Wall(curr.x, curr.y, this.getDirection(curr, st));
        return !this.walls.contains(possibleWall);
    }

    public int getDirection(State curr, State st) {
        switch (curr.x - st.x) {
            case -1: {
                return 1;
            }
            case 1: {
                return 3;
            }
        }
        switch (curr.y - st.y) {
            case -1: {
                return 0;
            }
            case 1: {
                return 2;
            }
        }
        return 0;
    }

    Vector getValidSuccessors(State currState) {
        Vector<State> succs = new Vector<State>();
        int i = 0;
        while (i < 4) {
            State newState = Action.performAction(currState, i);
            if (this.isValidTransition(currState, newState)) {
                succs.add(newState);
            }
            ++i;
        }
        return succs;
    }

    Vector getSuccessors(State currState) {
        Vector<State> succs = new Vector<State>();
        int i = 0;
        while (i < 4) {
            State newState = Action.performAction(currState, i);
            succs.add(newState);
            ++i;
        }
        return succs;
    }

    void addWall(Wall newWall) {
        if (newWall.x < 0 || newWall.y < 0 || newWall.x >= this.width || newWall.y >= this.height) {
            return;
        }
        if (!this.isWallPresent(newWall)) {
            this.walls.add(newWall);
        } else {
            this.walls.remove(newWall);
        }
    }

    double getReward(State curr, State st) {
        Wall possibleWall = new Wall(curr.x, curr.y, this.getDirection(curr, st));
        int index = this.walls.indexOf(possibleWall);
        if (index != -1) {
            Wall w = (Wall)this.walls.get(index);
            return w.penalty;
        }
        return 0.0;
    }

    boolean isWallPresent(Wall newWall) {
        boolean wallPresent = false;
        Wall w = new Wall();
        int i = 0;
        while (i < this.walls.size()) {
            w = (Wall)this.walls.get(i);
            if (w.x == newWall.x && w.y == newWall.y && w.dir == newWall.dir) {
                wallPresent = true;
                break;
            }
            ++i;
        }
        return wallPresent;
    }

    void printWalls() {
        Wall w = new Wall();
        Utility.show("------------printing walls------------");
        if (this.walls.isEmpty()) {
            Utility.show("no walls yet");
        }
        int i = 0;
        while (i < this.walls.size()) {
            w = (Wall)this.walls.get(i);
            Utility.show("wall at " + w.x + " " + w.y + " " + w.dir + " " + w.penalty);
            ++i;
        }
        Utility.show("------------done------------");
    }

    void printGoals() {
        State st = new State(0, 0);
        Utility.show("-------------------------");
        if (this.goals.isEmpty()) {
            Utility.show("no goals yet");
        }
        int i = 0;
        while (i < this.goals.size()) {
            st = (State)this.goals.get(i);
            Utility.show("goal at " + st.x + " " + st.y);
            ++i;
        }
    }
}

