/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Polygon;

public class GraphicsUtil {
    public static void drawArc(Graphics g, int left, int top, int width, int height, int startAngle, int deltaAngle, int lineWidth) {
        left -= lineWidth / 2;
        top -= lineWidth / 2;
        width += lineWidth;
        height += lineWidth;
        int i = 0;
        while (i < lineWidth) {
            g.drawArc(left, top, width, height, startAngle, deltaAngle);
            if (i + 1 < lineWidth) {
                g.drawArc(left, top, width - 1, height - 1, startAngle, deltaAngle);
                g.drawArc(left + 1, top, width - 1, height - 1, startAngle, deltaAngle);
                g.drawArc(left, top + 1, width - 1, height - 1, startAngle, deltaAngle);
                g.drawArc(left + 1, top + 1, width - 1, height - 1, startAngle, deltaAngle);
                ++left;
                ++top;
                width -= 2;
                height -= 2;
            }
            ++i;
        }
    }

    public static void drawArc(Graphics g, int left, int top, int width, int height, int startAngle, int deltaAngle, int lineWidth, Color c) {
        Color origColor = g.getColor();
        g.setColor(c);
        GraphicsUtil.drawArc(g, left, top, width, height, startAngle, deltaAngle, lineWidth);
        g.setColor(origColor);
    }

    public static void drawArc(Graphics g, int left, int top, int width, int height, int startAngle, int deltaAngle, Color c) {
        Color origColor = g.getColor();
        g.setColor(c);
        g.drawArc(left, top, width, height, startAngle, deltaAngle);
        g.setColor(origColor);
    }

    public static void fillArc(Graphics g, int left, int top, int width, int height, int startAngle, int deltaAngle, Color c) {
        Color origColor = g.getColor();
        g.setColor(c);
        g.fillArc(left, top, width, height, startAngle, deltaAngle);
        g.setColor(origColor);
    }

    public static void drawChars(Graphics g, char[] chars, int start, int numChars, int x, int y, Color c) {
        Color origColor = g.getColor();
        g.setColor(c);
        g.drawChars(chars, start, numChars, x, y);
        g.setColor(origColor);
    }

    public static void drawChars(Graphics g, char[] chars, int start, int numChars, int x, int y, Font f) {
        Font origFont = g.getFont();
        g.setFont(f);
        g.drawChars(chars, start, numChars, x, y);
        g.setFont(origFont);
    }

    public static void drawChars(Graphics g, char[] chars, int start, int numChars, int x, int y, Font f, Color c) {
        Font origFont = g.getFont();
        g.setFont(f);
        GraphicsUtil.drawChars(g, chars, start, numChars, x, y, c);
        g.setFont(origFont);
    }

    public static void drawCircle(Graphics g, int x, int y, int r) {
        g.drawOval(x - r, y - r, 2 * r, 2 * r);
    }

    public static void drawCircle(Graphics g, int x, int y, int r, int lineWidth) {
        r += lineWidth / 2;
        int i = 0;
        while (i < lineWidth) {
            GraphicsUtil.drawCircle(g, x, y, r);
            if (i + 1 < lineWidth) {
                GraphicsUtil.drawCircle(g, x + 1, y, r - 1);
                GraphicsUtil.drawCircle(g, x - 1, y, r - 1);
                GraphicsUtil.drawCircle(g, x, y + 1, r - 1);
                GraphicsUtil.drawCircle(g, x, y - 1, r - 1);
                --r;
            }
            ++i;
        }
    }

    public static void drawCircle(Graphics g, int x, int y, int r, int lineWidth, Color c) {
        Color origColor = g.getColor();
        g.setColor(c);
        GraphicsUtil.drawCircle(g, x, y, r, lineWidth);
        g.setColor(origColor);
    }

    public static void drawCircle(Graphics g, int x, int y, int r, Color c) {
        GraphicsUtil.drawCircle(g, x, y, r, 1, c);
    }

    public static void fillCircle(Graphics g, int x, int y, int r) {
        g.fillOval(x - r, y - r, 2 * r, 2 * r);
    }

    public static void fillCircle(Graphics g, int x, int y, int r, Color c) {
        Color origColor = g.getColor();
        g.setColor(c);
        GraphicsUtil.fillCircle(g, x, y, r);
        g.setColor(origColor);
    }

    public static void drawLine(Graphics g, int x1, int y1, int x2, int y2, int lineWidth) {
        if (lineWidth == 1) {
            g.drawLine(x1, y1, x2, y2);
        } else {
            double halfWidth = (double)lineWidth / 2.0;
            double deltaX = x2 - x1;
            double deltaY = y2 - y1;
            double angle = x1 == x2 ? Math.PI : Math.atan(deltaY / deltaX) + 1.5707963267948966;
            int xOffset = (int)(halfWidth * Math.cos(angle));
            int yOffset = (int)(halfWidth * Math.sin(angle));
            int[] xCorners = new int[]{x1 - xOffset, x2 - xOffset + 1, x2 + xOffset + 1, x1 + xOffset};
            int[] yCorners = new int[]{y1 - yOffset, y2 - yOffset, y2 + yOffset + 1, y1 + yOffset + 1};
            g.fillPolygon(xCorners, yCorners, 4);
        }
    }

    public static void drawLine(Graphics g, int x1, int y1, int x2, int y2, int lineWidth, Color c) {
        Color origColor = g.getColor();
        g.setColor(c);
        GraphicsUtil.drawLine(g, x1, y1, x2, y2, lineWidth);
        g.setColor(origColor);
    }

    public static void drawLine(Graphics g, int x1, int y1, int x2, int y2, Color c) {
        GraphicsUtil.drawLine(g, x1, y1, x2, y2, 1, c);
    }

    public static void drawOval(Graphics g, int left, int top, int width, int height, int lineWidth) {
        left -= lineWidth / 2;
        top -= lineWidth / 2;
        width += lineWidth;
        height += lineWidth;
        int i = 0;
        while (i < lineWidth) {
            g.drawOval(left, top, width, height);
            if (i + 1 < lineWidth) {
                g.drawOval(left, top, width - 1, height - 1);
                g.drawOval(left + 1, top, width - 1, height - 1);
                g.drawOval(left, top + 1, width - 1, height - 1);
                g.drawOval(left + 1, top + 1, width - 1, height - 1);
                ++left;
                ++top;
                width -= 2;
                height -= 2;
            }
            ++i;
        }
    }

    public static void drawOval(Graphics g, int left, int top, int width, int height, int lineWidth, Color c) {
        Color origColor = g.getColor();
        g.setColor(c);
        GraphicsUtil.drawOval(g, left, top, width, height, lineWidth);
        g.setColor(origColor);
    }

    public static void drawOval(Graphics g, int left, int top, int width, int height, Color c) {
        GraphicsUtil.drawOval(g, left, top, width, height, 1, c);
    }

    public static void fillOval(Graphics g, int left, int top, int width, int height, Color c) {
        Color origColor = g.getColor();
        g.setColor(c);
        g.fillOval(left, top, width, height);
        g.setColor(origColor);
    }

    public static void drawPolygon(Graphics g, int[] xPoints, int[] yPoints, int numPoints, Color c) {
        Color origColor = g.getColor();
        g.setColor(c);
        g.drawPolygon(xPoints, yPoints, numPoints);
        g.setColor(origColor);
    }

    public static void drawPolygon(Graphics g, Polygon p, Color c) {
        Color origColor = g.getColor();
        g.setColor(c);
        g.drawPolygon(p);
        g.setColor(origColor);
    }

    public static void fillPolygon(Graphics g, int[] xs, int[] ys, int numPoints, Color c) {
        Color origColor = g.getColor();
        g.setColor(c);
        g.fillPolygon(xs, ys, numPoints);
        g.setColor(origColor);
    }

    public static void fillPolygon(Graphics g, Polygon p, Color c) {
        Color origColor = g.getColor();
        g.setColor(c);
        g.fillPolygon(p);
        g.setColor(origColor);
    }

    public static void drawRect(Graphics g, int left, int top, int width, int height, int lineWidth) {
        left -= lineWidth / 2;
        top -= lineWidth / 2;
        width += lineWidth;
        height += lineWidth;
        int i = 0;
        while (i < lineWidth) {
            g.drawRect(left, top, width, height);
            ++left;
            ++top;
            width -= 2;
            height -= 2;
            ++i;
        }
    }

    public static void drawRect(Graphics g, int left, int top, int width, int height, int lineWidth, Color c) {
        Color origColor = g.getColor();
        g.setColor(c);
        GraphicsUtil.drawRect(g, left, top, width, height, lineWidth);
        g.setColor(origColor);
    }

    public static void drawRect(Graphics g, int left, int top, int width, int height, Color c) {
        GraphicsUtil.drawRect(g, left, top, width, height, 1, c);
    }

    public static void fillRect(Graphics g, int left, int top, int width, int height, Color c) {
        Color origColor = g.getColor();
        g.setColor(c);
        g.fillRect(left, top, width, height);
        g.setColor(origColor);
    }

    public static void drawRoundRect(Graphics g, int left, int top, int width, int height, int arcWidth, int arcHeight, int lineWidth) {
        left -= lineWidth / 2;
        top -= lineWidth / 2;
        width += lineWidth;
        height += lineWidth;
        int i = 0;
        while (i < lineWidth) {
            g.drawRoundRect(left, top, width, height, arcWidth, arcHeight);
            if (i + 1 < lineWidth) {
                g.drawRoundRect(left, top, width - 1, height - 1, arcWidth, arcHeight);
                g.drawRoundRect(left + 1, top, width - 1, height - 1, arcWidth, arcHeight);
                g.drawRoundRect(left, top + 1, width - 1, height - 1, arcWidth, arcHeight);
                g.drawRoundRect(left + 1, top + 1, width - 1, height - 1, arcWidth, arcHeight);
                ++left;
                ++top;
                width -= 2;
                height -= 2;
            }
            ++i;
        }
    }

    public static void drawRoundRect(Graphics g, int left, int top, int width, int height, int arcWidth, int arcHeight, int lineWidth, Color c) {
        Color origColor = g.getColor();
        g.setColor(c);
        GraphicsUtil.drawRoundRect(g, left, top, width, height, arcWidth, arcHeight, lineWidth);
        g.setColor(origColor);
    }

    public static void drawRoundRect(Graphics g, int left, int top, int width, int height, int arcWidth, int arcHeight, Color c) {
        GraphicsUtil.drawRoundRect(g, left, top, width, height, arcWidth, arcHeight, 1, c);
    }

    public static void fillRoundRect(Graphics g, int left, int top, int width, int height, int arcWidth, int arcHeight, Color c) {
        Color origColor = g.getColor();
        g.setColor(c);
        g.fillRoundRect(left, top, width, height, arcWidth, arcHeight);
        g.setColor(origColor);
    }

    public static void draw3DRect(Graphics g, int left, int top, int width, int height, boolean isRaised, int lineWidth) {
        left -= lineWidth / 2;
        top -= lineWidth / 2;
        width += lineWidth;
        height += lineWidth;
        int i = 0;
        while (i < lineWidth) {
            g.draw3DRect(left, top, width, height, isRaised);
            ++left;
            ++top;
            width -= 2;
            height -= 2;
            ++i;
        }
    }

    public static void draw3DRect(Graphics g, int left, int top, int width, int height, boolean isRaised, int lineWidth, Color c) {
        Color origColor = g.getColor();
        g.setColor(c);
        GraphicsUtil.draw3DRect(g, left, top, width, height, isRaised, lineWidth);
        g.setColor(origColor);
    }

    public static void draw3DRect(Graphics g, int left, int top, int width, int height, boolean isRaised, Color c) {
        GraphicsUtil.draw3DRect(g, left, top, width, height, isRaised, 1, c);
    }

    public static void fill3DRect(Graphics g, int left, int top, int width, int height, boolean isRaised, Color c) {
        Color origColor = g.getColor();
        g.setColor(c);
        g.fill3DRect(left, top, width, height, isRaised);
        g.setColor(origColor);
    }

    public static void drawString(Graphics g, String s, int x, int y, Color c) {
        Color origColor = g.getColor();
        g.setColor(c);
        g.drawString(s, x, y);
        g.setColor(origColor);
    }

    public static void drawString(Graphics g, String s, int x, int y, Font f) {
        Font origFont = g.getFont();
        g.setFont(f);
        g.drawString(s, x, y);
        g.setFont(origFont);
    }

    public static void drawString(Graphics g, String s, int x, int y, Font f, Color c) {
        Font origFont = g.getFont();
        g.setFont(f);
        GraphicsUtil.drawString(g, s, x, y, c);
        g.setFont(origFont);
    }
}

