/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.Date;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import javax.swing.JFileChooser;
import javax.swing.JFrame;

public class DataLogger {
    public Maze myMaze;
    double precision = 0.001;
    double pjog = 0.3;
    double learningRate = 0.7;
    double epsilon = 0.1;
    boolean decayingLR = true;
    int maxBackups = 10;
    double tinyThreshold = 0.01;
    PrioritizedSweeping ps;

    public DataLogger() {
        JFileChooser fc = new JFileChooser("./mazes/");
        int returnVal = fc.showOpenDialog(new JFrame());
        if (returnVal == 0) {
            try {
                File file = fc.getSelectedFile();
                FileInputStream fis = new FileInputStream(file);
                GZIPInputStream gzis = new GZIPInputStream(fis);
                ObjectInputStream in = new ObjectInputStream(gzis);
                this.myMaze = (Maze)in.readObject();
                in.close();
            }
            catch (Exception e) {
                Utility.show(e.getMessage());
            }
        }
    }

    public void logValueIteration() {
        ValueIteration valItr = new ValueIteration(this.myMaze, this.pjog, this.precision);
        while (!valItr.step()) {
        }
        ValueFunction valuefunc = valItr.getValueFunction();
        System.out.print("0\t");
        valuefunc.displayValues();
    }

    public void logQLearning(int series, int cycles) {
        QLearning ql = new QLearning(this.myMaze, this.pjog, this.learningRate, this.epsilon, this.decayingLR);
        long startTime = new Date().getTime();
        int i = 0;
        while (i < series) {
            int j = 0;
            while (j < cycles) {
                while (!ql.step()) {
                }
                long endTime = new Date().getTime();
                System.out.print(String.valueOf(endTime - startTime) + "\t");
                System.out.print(String.valueOf(ql.evalPolicy()) + "\n");
                ++j;
            }
            ++i;
        }
    }

    public void logPSweeping(int cycles) {
        long startTime = new Date().getTime();
        long endTime = new Date().getTime();
        System.out.print("0\t");
        System.out.print(String.valueOf(endTime - startTime) + "\t");
        System.out.print(String.valueOf(this.ps.evalPolicy()) + "\t");
        System.out.print(String.valueOf(this.ps.averageBackups) + "\n");
        int j = 0;
        while (j < cycles) {
            while (!this.ps.step()) {
            }
            endTime = new Date().getTime();
            System.out.print(String.valueOf(j + 1) + "\t");
            System.out.print(String.valueOf(endTime - startTime) + "\t");
            System.out.print(String.valueOf(this.ps.evalPolicy()) + "\t");
            System.out.print(String.valueOf(this.ps.averageBackups) + "\n");
            ++j;
        }
    }

    public void logPSweeping() {
        this.maxBackups = 0;
        Random rand = new Random();
        this.ps = new PrioritizedSweeping(this.myMaze, this.pjog, this.epsilon, this.maxBackups, this.tinyThreshold);
        int trials = 0;
        while (trials < 10) {
            System.err.println("trial:" + trials);
            int seed = rand.nextInt();
            int i = 0;
            while (i < 6) {
                this.maxBackups = (int)Math.pow(3.0, i) - 1;
                System.err.println("i==>" + i + "|maxBackups=>" + this.maxBackups);
                this.ps.setProperty(PrioritizedSweeping.Properties.MaxBackups, "" + this.maxBackups);
                this.ps.initialize();
                this.ps.setSeed(seed);
                this.logPSweeping(100);
                ++i;
            }
            ++trials;
        }
    }

    public static void main(String[] args) {
        DataLogger dl = new DataLogger();
        dl.logPSweeping();
        System.exit(0);
    }
}

