/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.text.DecimalFormat;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class AlgoSimulator
extends JFrame
implements ActionListener {
    private JPanel jPanel;
    private JButton jLoadButton;
    private JPanel jGridPanel;
    private JSeparator jSeparator1;
    private JButton jInitialiseButton;
    private JButton jStepButton;
    private JButton jExecuteButton;
    private JFileChooser fc;
    private JLabel jLabelSqSize;
    private JCheckBox jPolicyCheckBox;
    private JCheckBox jValuesCheckBox;
    private JButton jUpdateButton;
    private JButton jRefreshButton;
    private JLabel jStatusLabel;
    private JTextField jFileNameTextField;
    private JTextField jCyclesTextField;
    private JLabel jCyclesLabel;
    private JTextField sqSizeTextField;
    private JTextField pjogTextField;
    private JLabel JLabelPJOG;
    private JLabel jConvErrorLabel;
    private JTextField jConverErrorTextField;
    private JLabel jDelayLabel;
    private JTextField jDelayTextField;
    private int algoType;
    private Algorithms alg = null;
    private Maze myMaze = null;
    private boolean ShowValue = true;
    private boolean ShowPolicy = true;
    private DecimalFormat df = new DecimalFormat("0");
    private String mazeStatus = "Load Maze First...";
    private String basicAlgStatus = "";
    private String additionalAlgStatus = "";
    private JLabel jLabelVFLimit;
    private JTextField jVFLimitTextField;
    private JLabel jLabelIterLimit;
    private JTextField jIterLimitTextField;
    int sqSize;
    int X;
    int Y;
    Color GoldColor;

    public AlgoSimulator(int _algoType) {
        super("RL-MDP:Simulation");
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.sqSize = 40;
        this.X = 192;
        this.Y = 100;
        this.GoldColor = new Color(200, 100, 55);
        this.algoType = _algoType;
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setSize(1000, 800);
            this.setExtendedState(6);
            this.setDefaultCloseOperation(2);
            this.jPanel = new JPanel();
            this.getContentPane().add((Component)this.jPanel, "Center");
            this.jPanel.setLayout(null);
            this.jPanel.setBackground(new Color(235, 241, 238));
            this.jPanel.setPreferredSize(new Dimension(900, 700));
            this.jLoadButton = new JButton();
            this.jPanel.add(this.jLoadButton);
            this.jLoadButton.setText("LoadMaze...");
            this.jLoadButton.setBounds(25, 62, 110, 28);
            this.jLoadButton.setActionCommand("LoadMaze");
            this.jLoadButton.addActionListener(this);
            if (this.algoType == 2) {
                this.jLabelVFLimit = new JLabel();
                this.jPanel.add(this.jLabelVFLimit);
                this.jLabelVFLimit.setText("Value Limit");
                this.jLabelVFLimit.setBounds(25, 115, 53, 21);
                this.jLabelVFLimit.setHorizontalAlignment(4);
                this.jVFLimitTextField = new JTextField();
                this.jPanel.add(this.jVFLimitTextField);
                this.jVFLimitTextField.setText("5000");
                this.jVFLimitTextField.setBounds(88, 117, 45, 20);
                this.jVFLimitTextField.setHorizontalAlignment(4);
                this.jLabelIterLimit = new JLabel();
                this.jPanel.add(this.jLabelIterLimit);
                this.jLabelIterLimit.setText("Iter. Limit");
                this.jLabelIterLimit.setBounds(25, 136, 53, 21);
                this.jLabelIterLimit.setHorizontalAlignment(4);
                this.jIterLimitTextField = new JTextField();
                this.jPanel.add(this.jIterLimitTextField);
                this.jIterLimitTextField.setText("500");
                this.jIterLimitTextField.setBounds(88, 138, 45, 20);
                this.jIterLimitTextField.setHorizontalAlignment(4);
            }
            this.JLabelPJOG = new JLabel();
            this.jPanel.add(this.JLabelPJOG);
            this.JLabelPJOG.setText("PJOG");
            this.JLabelPJOG.setBounds(25, 157, 53, 21);
            this.JLabelPJOG.setHorizontalAlignment(4);
            this.pjogTextField = new JTextField();
            this.jPanel.add(this.pjogTextField);
            this.pjogTextField.setText("0.3");
            this.pjogTextField.setBounds(88, 159, 45, 20);
            this.pjogTextField.setHorizontalAlignment(4);
            this.jConvErrorLabel = new JLabel();
            this.jPanel.add(this.jConvErrorLabel);
            this.jConvErrorLabel.setText("Precision");
            this.jConvErrorLabel.setBounds(29, 178, 51, 21);
            this.jConvErrorLabel.setHorizontalAlignment(4);
            this.jConverErrorTextField = new JTextField();
            this.jPanel.add(this.jConverErrorTextField);
            this.jConverErrorTextField.setText("0.001");
            this.jConverErrorTextField.setBounds(88, 180, 45, 20);
            this.jConverErrorTextField.setHorizontalAlignment(4);
            this.jInitialiseButton = new JButton();
            this.jPanel.add(this.jInitialiseButton);
            this.jInitialiseButton.setText("Initialize");
            this.jInitialiseButton.setBounds(25, 210, 110, 28);
            this.jInitialiseButton.addActionListener(this);
            this.jInitialiseButton.setActionCommand("Initialize");
            this.jUpdateButton = new JButton();
            this.jPanel.add(this.jUpdateButton);
            this.jUpdateButton.setText("Update");
            this.jUpdateButton.setBounds(25, 250, 110, 28);
            this.jUpdateButton.setActionCommand("Update");
            this.jUpdateButton.addActionListener(this);
            this.jStepButton = new JButton();
            this.jPanel.add(this.jStepButton);
            this.jStepButton.setText("Step");
            this.jStepButton.setBounds(25, 317, 110, 28);
            this.jStepButton.addActionListener(this);
            this.jStepButton.setActionCommand("Step");
            this.jExecuteButton = new JButton();
            this.jPanel.add(this.jExecuteButton);
            this.jExecuteButton.setText("Execute");
            this.jExecuteButton.setBounds(25, 357, 110, 28);
            this.jExecuteButton.addActionListener(this);
            this.jExecuteButton.setActionCommand("Execute");
            this.jLabelSqSize = new JLabel();
            this.jPanel.add(this.jLabelSqSize);
            this.jLabelSqSize.setText("Square Size");
            this.jLabelSqSize.setBounds(20, 420, 70, 21);
            this.jLabelSqSize.setHorizontalAlignment(4);
            this.sqSizeTextField = new JTextField();
            this.jPanel.add(this.sqSizeTextField);
            this.sqSizeTextField.setText("40");
            this.sqSizeTextField.setBounds(96, 421, 40, 20);
            this.sqSizeTextField.setHorizontalAlignment(4);
            this.sqSizeTextField.addActionListener(this);
            this.jDelayLabel = new JLabel();
            this.jPanel.add(this.jDelayLabel);
            this.jDelayLabel.setText("Delay(in ms)");
            this.jDelayLabel.setBounds(22, 442, 70, 21);
            this.jDelayLabel.setHorizontalAlignment(4);
            this.jDelayTextField = new JTextField();
            this.jPanel.add(this.jDelayTextField);
            this.jDelayTextField.setText("0");
            this.jDelayTextField.setBounds(96, 444, 40, 20);
            this.jDelayTextField.setHorizontalAlignment(4);
            this.jValuesCheckBox = new JCheckBox();
            this.jPanel.add(this.jValuesCheckBox);
            this.jValuesCheckBox.setText("Show Values");
            this.jValuesCheckBox.setBounds(34, 536, 93, 21);
            this.jValuesCheckBox.setOpaque(false);
            this.jValuesCheckBox.setSelected(true);
            this.jValuesCheckBox.addActionListener(this);
            this.jPolicyCheckBox = new JCheckBox();
            this.jPanel.add(this.jPolicyCheckBox);
            this.jPolicyCheckBox.setText("Show Policy");
            this.jPolicyCheckBox.setBounds(34, 558, 85, 22);
            this.jPolicyCheckBox.setOpaque(false);
            this.jPolicyCheckBox.setSelected(true);
            this.jPolicyCheckBox.addActionListener(this);
            this.jRefreshButton = new JButton();
            this.jPanel.add(this.jRefreshButton);
            this.jRefreshButton.setText("Refresh");
            this.jRefreshButton.setBounds(26, 481, 110, 28);
            this.jRefreshButton.setActionCommand("Refresh");
            this.jRefreshButton.addActionListener(this);
            this.jSeparator1 = new JSeparator();
            this.jPanel.add(this.jSeparator1);
            this.jSeparator1.setBounds(161, 2, 4, this.jPanel.getBounds().height);
            this.jSeparator1.setBorder(BorderFactory.createTitledBorder(null, "", 4, 2, new Font("MS Sans Serif", 0, 11), new Color(0, 0, 0)));
            this.jStatusLabel = new JLabel();
            this.jPanel.add(this.jStatusLabel);
            this.jStatusLabel.setText("Load Maze First...");
            this.jStatusLabel.setBounds(182, 14, 770, 34);
            this.jStatusLabel.setBackground(new Color(192, 192, 192));
            this.jStatusLabel.setBorder(BorderFactory.createTitledBorder(null, "", 4, 2, new Font("MS Sans Serif", 0, 11), new Color(0, 0, 0)));
            this.jStatusLabel.setFont(new Font("Georgia", 1, 12));
            this.jStatusLabel.setDebugGraphicsOptions(-1);
            this.jStatusLabel.setOpaque(true);
            this.jStatusLabel.setHorizontalAlignment(0);
            this.jStatusLabel.setPreferredSize(new Dimension(984, 35));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equals("LoadMaze")) {
            Utility.show("Loading maze");
            this.fc = new JFileChooser("./mazes/");
            int returnVal = this.fc.showOpenDialog(this);
            if (returnVal == 0) {
                try {
                    File file = this.fc.getSelectedFile();
                    FileInputStream fis = new FileInputStream(file);
                    GZIPInputStream gzis = new GZIPInputStream(fis);
                    ObjectInputStream in = new ObjectInputStream(gzis);
                    this.myMaze = (Maze)in.readObject();
                    in.close();
                    this.mazeStatus = " [ " + this.myMaze.width + " X " + this.myMaze.height + " Maze, Wall Penalty:" + ((Wall)this.myMaze.walls.get((int)0)).penalty + "] | ";
                    this.basicAlgStatus = this.algoType == 1 ? " Value Iteration" : " Policy Iteration";
                    this.additionalAlgStatus = "-> Click Initialise...";
                    this.sqSize = (int)Math.min(Math.floor((this.getSize().width - this.X - 10) / this.myMaze.width), Math.floor((this.getSize().height - this.Y - 10) / this.myMaze.height));
                    if (this.sqSize > 200) {
                        this.sqSize = 200;
                    }
                    this.sqSizeTextField.setText("" + this.sqSize);
                }
                catch (Exception e) {
                    Utility.show(e.getMessage());
                }
                this.alg = null;
            }
            this.repaint();
        } else if (evt.getActionCommand().equals("Initialize") && this.myMaze != null) {
            Utility.show("Initialize");
            double pjog = Double.parseDouble(this.pjogTextField.getText());
            double precision = Double.parseDouble(this.jConverErrorTextField.getText());
            this.additionalAlgStatus = "";
            if (this.algoType == 1) {
                this.alg = new ValueIteration(this.myMaze, pjog, precision);
            }
            if (this.algoType == 2) {
                int valueLimit = Integer.parseInt(this.jVFLimitTextField.getText());
                int iterLimit = Integer.parseInt(this.jIterLimitTextField.getText());
                this.alg = new PolicyIteration(this.myMaze, pjog, precision, valueLimit, iterLimit);
            }
            this.repaint();
        } else if (evt.getActionCommand().equals("Update")) {
            if (this.algoType == 1) {
                this.alg.setProperty(ValueIteration.Properties.PJOG, this.pjogTextField.getText());
                this.alg.setProperty(ValueIteration.Properties.ConvergenceError, this.jConverErrorTextField.getText());
            } else {
                this.alg.setProperty(PolicyIteration.Properties.PJOG, this.pjogTextField.getText());
                this.alg.setProperty(PolicyIteration.Properties.ConvergenceError, this.jConverErrorTextField.getText());
                this.alg.setProperty(PolicyIteration.Properties.ValueFunctionLimit, this.jVFLimitTextField.getText());
                this.alg.setProperty(PolicyIteration.Properties.IterationLimit, this.jIterLimitTextField.getText());
            }
        } else if (evt.getActionCommand().equals("Step")) {
            Utility.show("step");
            if (this.alg != null) {
                if (this.alg.step()) {
                    this.additionalAlgStatus = " -- Converged after " + this.alg.getNumOfIters() + " steps!!";
                    this.additionalAlgStatus = String.valueOf(this.additionalAlgStatus) + " TimeTaken: " + this.alg.getTime() + "ms";
                } else {
                    this.additionalAlgStatus = " -- " + this.alg.getNumOfIters() + " steps.";
                }
            }
            this.repaint();
        } else if (evt.getActionCommand().equals("Execute")) {
            Utility.show("execute");
            int delay = Integer.parseInt(this.jDelayTextField.getText());
            if (this.alg != null) {
                while (!this.alg.step()) {
                    this.additionalAlgStatus = " -- " + this.alg.getNumOfIters() + " steps.";
                    this.myUpdate();
                    Utility.delay(delay);
                }
                this.additionalAlgStatus = " -- Converged after " + this.alg.getNumOfIters() + " steps!!";
                this.additionalAlgStatus = String.valueOf(this.additionalAlgStatus) + " TimeTaken: " + this.alg.getTime() + "ms";
                this.myUpdate();
            }
        } else if (evt.getActionCommand().equals("Refresh")) {
            Utility.show("Refresh");
            this.repaint();
        } else if (evt.getSource().getClass().getName().equals("javax.swing.JTextField")) {
            this.repaint();
        } else if (evt.getSource().getClass().getName().equals("javax.swing.JCheckBox")) {
            JCheckBox jcb = (JCheckBox)evt.getSource();
            if (jcb.getText().equals("Show Values")) {
                this.ShowValue = jcb.isSelected();
            }
            if (jcb.getText().equals("Show Policy")) {
                this.ShowPolicy = jcb.isSelected();
            }
            this.repaint();
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.myUpdate(g);
    }

    public void myUpdate() {
        this.myUpdate(this.getGraphics());
    }

    private void myUpdate(Graphics g) {
        this.jSeparator1.setSize(4, this.jPanel.getBounds().height - 2);
        this.jStatusLabel.setText(String.valueOf(this.mazeStatus) + this.basicAlgStatus + this.additionalAlgStatus);
        this.showGrid(this.getGraphics());
    }

    public void showGrid(Graphics g) {
        this.sqSize = Integer.parseInt(this.sqSizeTextField.getText());
        if (this.alg != null) {
            this.drawInfo(g);
        }
        if (this.myMaze != null) {
            if (this.alg == null) {
                g.setColor(new Color(220, 220, 220));
                g.fillRect(this.X, this.Y, this.sqSize * this.myMaze.width, this.sqSize * this.myMaze.height);
                this.drawGoal(g);
            }
            this.drawMaze(g);
            this.drawWalls(g);
        }
    }

    private void drawMaze(Graphics g) {
        g.setColor(Color.black);
        int counter = 0;
        while (counter <= this.myMaze.width) {
            g.drawLine(this.X + this.sqSize * counter, this.Y + 0, this.X + this.sqSize * counter, this.Y + this.sqSize * this.myMaze.height);
            ++counter;
        }
        counter = 0;
        while (counter <= this.myMaze.height) {
            g.drawLine(this.X + 0, this.Y + this.sqSize * counter, this.X + this.sqSize * this.myMaze.width, this.Y + this.sqSize * counter);
            ++counter;
        }
    }

    private void drawGoal(Graphics g) {
        Vector goals = this.myMaze.goals;
        int i = 0;
        while (i < goals.size()) {
            State s = (State)goals.get(i);
            g.setColor(this.GoldColor);
            g.fillRect(this.X + s.x * this.sqSize + 1, this.Y + (this.myMaze.height - 1 - s.y) * this.sqSize + 1, this.sqSize - 2, this.sqSize - 2);
            ++i;
        }
    }

    private void drawWalls(Graphics g) {
        GraphicsUtil gr = new GraphicsUtil();
        int i = 0;
        while (i < this.myMaze.walls.size()) {
            Wall w = (Wall)this.myMaze.walls.get(i);
            int nodeX = w.x;
            int nodeY = w.y;
            switch (w.dir) {
                case 0: {
                    int aX = nodeX * this.sqSize;
                    int bX = (nodeX + 1) * this.sqSize;
                    int aY = (this.myMaze.height - nodeY - 1) * this.sqSize;
                    int bY = (this.myMaze.height - nodeY - 1) * this.sqSize;
                    GraphicsUtil.drawLine(g, this.X + aX, this.Y + aY, this.X + bX, this.Y + bY, 5);
                    break;
                }
                case 2: {
                    int aX = nodeX * this.sqSize;
                    int bX = (nodeX + 1) * this.sqSize;
                    int aY = (this.myMaze.height - nodeY) * this.sqSize;
                    int bY = (this.myMaze.height - nodeY) * this.sqSize;
                    GraphicsUtil.drawLine(g, this.X + aX, this.Y + aY, this.X + bX, this.Y + bY, 5);
                    break;
                }
                case 1: {
                    int aX = (nodeX + 1) * this.sqSize;
                    int bX = (nodeX + 1) * this.sqSize;
                    int aY = (this.myMaze.height - nodeY - 1) * this.sqSize;
                    int bY = (this.myMaze.height - nodeY) * this.sqSize;
                    GraphicsUtil.drawLine(g, this.X + aX, this.Y + aY, this.X + bX, this.Y + bY, 5);
                    break;
                }
                case 3: {
                    int aX = nodeX * this.sqSize;
                    int bX = nodeX * this.sqSize;
                    int aY = (this.myMaze.height - nodeY) * this.sqSize;
                    int bY = (this.myMaze.height - nodeY - 1) * this.sqSize;
                    GraphicsUtil.drawLine(g, this.X + aX, this.Y + aY, this.X + bX, this.Y + bY, 5);
                }
            }
            ++i;
        }
    }

    private void drawInfo(Graphics g) {
        ValueFunction valuefunc = this.alg.getValueFunction();
        double[][] values = valuefunc.stateValue;
        int max = 1 + (int)Math.ceil(valuefunc.getMax());
        int[][] policy = this.alg.getPolicy();
        int xval = 0;
        while (xval < this.myMaze.width) {
            int y = 0;
            while (y < this.myMaze.height) {
                block12: {
                    int yval = this.myMaze.height - 1 - y;
                    if (values[xval][y] > 0.0) {
                        int red = 155 - Math.min((int)(255.0 * values[xval][y] / (double)max), 155);
                        int green = 155 - Math.min((int)(255.0 * values[xval][y] / (double)max), 155);
                        int b = 255 - Math.min((int)(255.0 * values[xval][y] / (double)max), 220);
                        g.setColor(new Color(red, green, b));
                    } else {
                        g.setColor(this.GoldColor);
                    }
                    g.fillRect(this.X + xval * this.sqSize + 1, this.Y + yval * this.sqSize + 1, this.sqSize - 1, this.sqSize - 1);
                    g.setColor(Color.white);
                    if (this.ShowValue) {
                        g.drawString(this.df.format(values[xval][y]), this.X + xval * this.sqSize + 5, this.Y + (yval + 1) * this.sqSize - 5);
                    }
                    if (this.ShowPolicy) {
                        int x1 = xval * this.sqSize + this.sqSize / 2;
                        int y1 = yval * this.sqSize + this.sqSize / 2;
                        int x2 = x1;
                        int y2 = y1;
                        switch (policy[xval][y]) {
                            case 0: {
                                y2 = yval * this.sqSize;
                                break;
                            }
                            case 3: {
                                x2 = xval * this.sqSize;
                                break;
                            }
                            case 2: {
                                y2 = yval * this.sqSize + this.sqSize;
                                break;
                            }
                            case 1: {
                                x2 = xval * this.sqSize + this.sqSize;
                                break;
                            }
                            default: {
                                break block12;
                            }
                        }
                        g.drawLine(this.X + x1, this.Y + y1, this.X + x2, this.Y + y2);
                    }
                }
                ++y;
            }
            ++xval;
        }
    }
}

