/*
 * Decompiled with CFR 0.152.
 */
package org.acmestudio.ui.analysis.performance.util;

import org.acmestudio.ui.analysis.performance.util.PerformanceException;

public class Solver {
    public static void mvmult(double[][] A, double[] x, double[] b) {
        int i = 0;
        while (i < x.length) {
            int j = 0;
            while (j < x.length) {
                int n = i;
                b[n] = b[n] + A[i][j] * x[j];
                ++j;
            }
            ++i;
        }
    }

    public static void solve(double[][] A_in, double[] x, double[] b_in) throws PerformanceException {
        double[][] A = new double[A_in.length][A_in[0].length + 1];
        int row = 0;
        while (row < A_in.length) {
            int col = 0;
            while (col < A_in[row].length) {
                A[row][col] = A_in[row][col];
                ++col;
            }
            A[row][A_in[0].length] = b_in[row];
            ++row;
        }
        int n = b_in.length;
        int row2 = n - 1;
        while (row2 > 0) {
            double pivot = A[row2][row2];
            if (pivot == 0.0) {
                throw new PerformanceException("Zero pivot encountered");
            }
            int col = 0;
            while (col < n + 1) {
                double[] dArray = A[row2];
                int n2 = col++;
                dArray[n2] = dArray[n2] / pivot;
            }
            int row22 = row2 - 1;
            while (row22 >= 0) {
                double zero_me = A[row22][row2];
                if (zero_me != 0.0) {
                    int col2 = 0;
                    while (col2 < n + 1) {
                        double[] dArray = A[row22];
                        int n3 = col2;
                        dArray[n3] = dArray[n3] - A[row2][col2] * zero_me;
                        ++col2;
                    }
                }
                --row22;
            }
            --row2;
        }
        double pivot = A[0][0];
        int col = 0;
        while (col < n + 1) {
            double[] dArray = A[0];
            int n4 = col++;
            dArray[n4] = dArray[n4] / pivot;
        }
        col = 0;
        while (col < n - 1) {
            int row3 = col + 1;
            while (row3 < n) {
                double[] dArray = A[row3];
                int n5 = n;
                dArray[n5] = dArray[n5] - A[row3][col] * A[col][n];
                A[row3][col] = 0.0;
                ++row3;
            }
            ++col;
        }
        int row4 = 0;
        while (row4 < n) {
            x[row4] = A[row4][n];
            ++row4;
        }
    }
}

