/*
 * Decompiled with CFR 0.152.
 */
package org.acmestudio.ui.analysis.performance.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Display;

public class ResourceManager {
    private static HashMap m_ColorMap = new HashMap();
    private static HashMap m_ClassImageMap = new HashMap();
    private static HashMap m_DescriptorImageMap = new HashMap();
    private static HashMap m_ImageToDecoratorMap = new HashMap();
    private static HashMap m_URLImageMap = new HashMap();
    private static HashMap m_FontMap = new HashMap();
    private static HashMap m_FontToBoldFontMap = new HashMap();
    private static HashMap m_IdToCursorMap = new HashMap();

    public static void dispose() {
        ResourceManager.disposeColors();
        ResourceManager.disposeFonts();
        ResourceManager.disposeImages();
        ResourceManager.disposeCursors();
    }

    public static Color getColor(int systemColorID) {
        Display display = Display.getCurrent();
        return display.getSystemColor(systemColorID);
    }

    public static Color getColor(int r, int g, int b) {
        return ResourceManager.getColor(new RGB(r, g, b));
    }

    public static Color getColor(RGB rgb) {
        Color color = (Color)m_ColorMap.get(rgb);
        if (color == null) {
            Display display = Display.getCurrent();
            color = new Color((Device)display, rgb);
            m_ColorMap.put(rgb, color);
        }
        return color;
    }

    public static void disposeColors() {
        Iterator iter = m_ColorMap.values().iterator();
        while (iter.hasNext()) {
            ((Color)iter.next()).dispose();
        }
        m_ColorMap.clear();
    }

    private static Image getImage(InputStream is) {
        Display display = Display.getCurrent();
        ImageData data = new ImageData(is);
        if (data.transparentPixel > 0) {
            return new Image((Device)display, data, data.getTransparencyMask());
        }
        return new Image((Device)display, data);
    }

    public static Image getImage(String path) {
        String key = String.valueOf(ResourceManager.class.getName()) + "|" + path;
        Image image = (Image)m_ClassImageMap.get(key);
        if (image == null) {
            try {
                FileInputStream fis = new FileInputStream(path);
                image = ResourceManager.getImage(fis);
                m_ClassImageMap.put(key, image);
                fis.close();
            }
            catch (Exception exception) {
                return null;
            }
        }
        return image;
    }

    public static Image getImage(Class clazz, String path) {
        String key = String.valueOf(clazz.getName()) + "|" + path;
        Image image = (Image)m_ClassImageMap.get(key);
        if (image == null) {
            if (path.length() > 0 && path.charAt(0) == '/') {
                String newPath = path.substring(1, path.length());
                image = ResourceManager.getImage(clazz.getClassLoader().getResourceAsStream(newPath));
            } else {
                image = ResourceManager.getImage(clazz.getResourceAsStream(path));
            }
            m_ClassImageMap.put(key, image);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(Class clazz, String path) {
        return ImageDescriptor.createFromFile((Class)clazz, (String)path);
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        try {
            return ImageDescriptor.createFromURL((URL)new File(path).toURL());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static Image getImage(ImageDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        Image image = (Image)m_DescriptorImageMap.get(descriptor);
        if (image == null) {
            image = descriptor.createImage();
            m_DescriptorImageMap.put(descriptor, image);
        }
        return image;
    }

    public static Image decorateImage(Image baseImage, Image decorator) {
        Image result;
        HashMap<Image, Image> decoratedMap = (HashMap<Image, Image>)m_ImageToDecoratorMap.get(baseImage);
        if (decoratedMap == null) {
            decoratedMap = new HashMap<Image, Image>();
            m_ImageToDecoratorMap.put(baseImage, decoratedMap);
        }
        if ((result = (Image)decoratedMap.get(decorator)) == null) {
            ImageData bid = baseImage.getImageData();
            ImageData did = decorator.getImageData();
            result = new Image((Device)Display.getCurrent(), bid.width, bid.height);
            GC gc = new GC((Drawable)result);
            gc.drawImage(baseImage, 0, 0);
            gc.drawImage(decorator, bid.width - did.width - 1, bid.height - did.height - 1);
            gc.dispose();
            decoratedMap.put(decorator, result);
        }
        return result;
    }

    public static void disposeImages() {
        Iterator iter = m_ClassImageMap.values().iterator();
        while (iter.hasNext()) {
            ((Image)iter.next()).dispose();
        }
        m_ClassImageMap.clear();
        iter = m_DescriptorImageMap.values().iterator();
        while (iter.hasNext()) {
            ((Image)iter.next()).dispose();
        }
        m_DescriptorImageMap.clear();
    }

    /*
     * Loose catch block
     */
    public static Image getPluginImage(Object plugin, String name) {
        try {
            Image image;
            URL url;
            block8: {
                url = ResourceManager.getPluginImageURL(plugin, name);
                if (!m_URLImageMap.containsKey(url)) break block8;
                return (Image)m_URLImageMap.get(url);
            }
            InputStream is = url.openStream();
            try {
                image = ResourceManager.getImage(is);
                m_URLImageMap.put(url, image);
            }
            finally {
                is.close();
            }
            return image;
        }
        catch (Throwable throwable) {
            {
                catch (Throwable throwable2) {}
            }
        }
        return null;
    }

    public static ImageDescriptor getPluginImageDescriptor(Object plugin, String name) {
        try {
            URL url = ResourceManager.getPluginImageURL(plugin, name);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (Throwable throwable) {
            try {
            }
            catch (Throwable throwable2) {}
            return null;
        }
    }

    private static URL getPluginImageURL(Object plugin, String name) throws Exception {
        Class<?> pluginClass = Class.forName("org.eclipse.core.runtime.Plugin");
        Method getDescriptorMethod = pluginClass.getMethod("getDescriptor", null);
        Class<?> pluginDescriptorClass = Class.forName("org.eclipse.core.runtime.IPluginDescriptor");
        Method getInstallURLMethod = pluginDescriptorClass.getMethod("getInstallURL", null);
        Object pluginDescriptor = getDescriptorMethod.invoke(plugin, null);
        URL installURL = (URL)getInstallURLMethod.invoke(pluginDescriptor, null);
        URL url = new URL(installURL, name);
        return url;
    }

    public static Font getFont(String name, int height, int style) {
        String fullName = String.valueOf(name) + "|" + height + "|" + style;
        Font font = (Font)m_FontMap.get(fullName);
        if (font == null) {
            font = new Font((Device)Display.getCurrent(), name, height, style);
            m_FontMap.put(fullName, font);
        }
        return font;
    }

    public static Font getBoldFont(Font baseFont) {
        Font font = (Font)m_FontToBoldFontMap.get(baseFont);
        if (font == null) {
            FontData[] fontDatas = baseFont.getFontData();
            FontData data = fontDatas[0];
            font = new Font((Device)Display.getCurrent(), data.getName(), data.getHeight(), 1);
            m_FontToBoldFontMap.put(baseFont, font);
        }
        return font;
    }

    public static void disposeFonts() {
        Iterator iter = m_FontMap.values().iterator();
        while (iter.hasNext()) {
            ((Font)iter.next()).dispose();
        }
        m_FontMap.clear();
    }

    public static void fixCoolBarSize(CoolBar bar) {
        CoolItem item;
        CoolItem[] items = bar.getItems();
        int i = 0;
        while (i < items.length) {
            item = items[i];
            if (item.getControl() == null) {
                item.setControl((Control)new Canvas((Composite)bar, 0){

                    public Point computeSize(int wHint, int hHint, boolean changed) {
                        return new Point(20, 20);
                    }
                });
            }
            ++i;
        }
        i = 0;
        while (i < items.length) {
            item = items[i];
            Control control = item.getControl();
            control.pack();
            Point size = control.getSize();
            item.setSize(item.computeSize(size.x, size.y));
            ++i;
        }
    }

    public static Cursor getCursor(int id) {
        Integer key = new Integer(id);
        Cursor cursor = (Cursor)m_IdToCursorMap.get(key);
        if (cursor == null) {
            cursor = new Cursor((Device)Display.getDefault(), id);
            m_IdToCursorMap.put(key, cursor);
        }
        return cursor;
    }

    public static void disposeCursors() {
        Iterator iter = m_IdToCursorMap.values().iterator();
        while (iter.hasNext()) {
            ((Cursor)iter.next()).dispose();
        }
        m_IdToCursorMap.clear();
    }
}

