/*
 * Decompiled with CFR 0.152.
 */
package org.acmestudio.ui.analysis.performance.part;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.acmestudio.acme.element.IAcmeAttachment;
import org.acmestudio.acme.element.IAcmeComponent;
import org.acmestudio.acme.element.IAcmeConnector;
import org.acmestudio.acme.element.IAcmeSystem;
import org.acmestudio.ui.analysis.performance.model.Destination;
import org.acmestudio.ui.analysis.performance.model.PerformanceModelManager;
import org.acmestudio.ui.analysis.performance.model.QNComponent;
import org.acmestudio.ui.analysis.performance.model.QNConnector;
import org.acmestudio.ui.analysis.performance.model.Request;
import org.acmestudio.ui.analysis.performance.model.Server;
import org.acmestudio.ui.analysis.performance.part.DestinationContentProvider;
import org.acmestudio.ui.analysis.performance.part.DestinationLabelProvider;
import org.acmestudio.ui.analysis.performance.part.ProbCellModifier;
import org.acmestudio.ui.widget.AutoApplyTextCellEditor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class RequestDialog
extends TitleAreaDialog {
    private Text _txtRequestName;
    private Button _btnGenerated;
    protected TableViewer _tblProbabilities;
    protected Button _btnContinuation;
    protected Text _txtGenRate;
    protected boolean _generated;
    private QNComponent _comp;
    private Request _newRequest;
    private Collection _destinations;
    static final String[] PROPERTIES = new String[]{"component", "connector", "request", "prob"};

    public RequestDialog(Shell parentShell, QNComponent comp) {
        super(parentShell);
        this._comp = comp;
        this._newRequest = new Request(this._comp.getServer(), "unknown");
    }

    public RequestDialog(Shell parentShell, QNComponent comp, Request r) {
        super(parentShell);
        this._comp = comp;
        this._newRequest = r;
    }

    protected Control createDialogArea(Composite parent) {
        Composite top = (Composite)super.createDialogArea(parent);
        top.setLayout((Layout)new GridLayout());
        Composite area = new Composite(top, 0);
        area.setLayoutData((Object)new GridData(1792));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        area.setLayout((Layout)gridLayout);
        Label label = new Label(area, 0);
        label.setText("Request Name:");
        this._txtRequestName = new Text(area, 2048);
        this._txtRequestName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RequestDialog.this.validateRequest();
            }
        });
        this._txtRequestName.setLayoutData((Object)new GridData(768));
        Group reqGroup = new Group(area, 0);
        reqGroup.setLayout((Layout)new FillLayout(512));
        reqGroup.setText("Requests:");
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        reqGroup.setLayoutData((Object)gridData);
        this._btnGenerated = new Button((Composite)reqGroup, 16);
        this._btnGenerated.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RequestDialog.this._txtGenRate.setEnabled(RequestDialog.this._btnGenerated.getSelection());
                RequestDialog.this._generated = RequestDialog.this._btnGenerated.getSelection();
            }
        });
        this._btnGenerated.setText("Generated Here");
        Composite composite = new Composite((Composite)reqGroup, 0);
        composite.setLayout((Layout)new FillLayout(256));
        Label label2 = new Label(composite, 131072);
        label2.setText("Generation Rate:");
        this._txtGenRate = new Text(composite, 0);
        this._txtGenRate.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RequestDialog.this.validateRequest();
            }
        });
        Label label22 = new Label(composite, 0);
        label22.setText("request/ms");
        this._btnContinuation = new Button((Composite)reqGroup, 16);
        this._btnContinuation.setText("A Continuation");
        Group group = new Group(area, 0);
        group.setLayout((Layout)new FillLayout());
        group.setText("Transition Probabilities:");
        gridData = new GridData(1296);
        gridData.horizontalSpan = 2;
        group.setLayoutData((Object)gridData);
        this._tblProbabilities = new TableViewer((Composite)group, 67584);
        this._tblProbabilities.setContentProvider((IContentProvider)new DestinationContentProvider());
        this._tblProbabilities.setLabelProvider((IBaseLabelProvider)new DestinationLabelProvider());
        Table table = this._tblProbabilities.getTable();
        table.setBounds(8, 22, 33, 99);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn compColumn = new TableColumn(table, 16384, 0);
        TableColumn connColumn = new TableColumn(table, 16384, 1);
        TableColumn reqColumn = new TableColumn(table, 16384, 2);
        TableColumn probColumn = new TableColumn(table, 16384, 3);
        compColumn.setText("Component");
        connColumn.setText("Connector");
        reqColumn.setText("Request");
        probColumn.setText("Probability");
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(25, false));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(25, false));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(25, false));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(25, false));
        table.setLayout((Layout)layout);
        this._tblProbabilities.setCellEditors(this.getCellEditors());
        this._tblProbabilities.setColumnProperties(PROPERTIES);
        this._tblProbabilities.setCellModifier((ICellModifier)new ProbCellModifier(this._tblProbabilities));
        this.importRequest(this._newRequest);
        this.validateRequest();
        return top;
    }

    private CellEditor[] getCellEditors() {
        CellEditor[] editors = new CellEditor[]{null, null, null, new AutoApplyTextCellEditor((Composite)this._tblProbabilities.getTable())};
        return editors;
    }

    private void fillTable() {
        this._destinations = new ArrayList();
        IAcmeSystem sys = (IAcmeSystem)this._comp.getAcmeComponent().getParent();
        new ArrayList();
        Set attachments = sys.getAttachments();
        for (IAcmeAttachment a : attachments) {
            if (!a.getPort().getParent().equals(this._newRequest.getParent().getParent())) continue;
            Set inte = sys.getAttachments();
            for (IAcmeAttachment inta : inte) {
                if (!inta.getRole().getParent().equals(a.getRole().getParent()) || inta.getPort().getParent().equals(a.getPort().getParent())) continue;
                QNComponent qndc = PerformanceModelManager.getQNComponent((IAcmeComponent)inta.getPort().getParent());
                Server ss = qndc.getServer();
                for (String reqKey : ss.getRequests().keySet()) {
                    Request rr = ss.getRequest(reqKey);
                    QNConnector conn = PerformanceModelManager.getQNConnector((IAcmeConnector)a.getRole().getParent());
                    Destination dd = new Destination(rr.getName(), ss, conn, this._newRequest);
                    dd.setPointer();
                    for (Destination intd : this._newRequest.getDestinations()) {
                        if (intd.setPointer()) {
                            if (!intd.getTo().equals(dd.getTo()) || !intd.getToConn().equals(dd.getToConn())) continue;
                            dd = intd;
                            continue;
                        }
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Destination error", (String)"Destination invalid");
                        this._newRequest.deleteDestination(intd);
                    }
                    this._destinations.add(dd);
                }
            }
        }
        this._tblProbabilities.setInput((Object)this._destinations);
    }

    protected void validateRequest() {
        if (this._txtRequestName.getText() == "") {
            this.setErrorMessage("Enter a name for the request");
            this.getButton(0).setEnabled(false);
            return;
        }
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(true);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void importRequest(Request r) {
        if (r != null) {
            this._txtRequestName.setText(r.getName());
            MessageFormat mf = new MessageFormat("{0,number,#.#######}");
            String genRate = mf.format(new Object[]{new Double(r.getGenRate() * 1000.0)});
            this._txtGenRate.setText(genRate);
            this._btnGenerated.setSelection(r.isGenerated());
            this._btnContinuation.setSelection(!r.isGenerated());
            this.fillTable();
        } else {
            this.fillTable();
        }
    }

    protected void exportRequest() {
        this._newRequest = new Request(this._comp.getServer(), this._txtRequestName.getText());
        if (this._btnGenerated.getSelection()) {
            this._newRequest.setGenerated(true);
            this._newRequest.setGenRate(Double.parseDouble(this._txtGenRate.getText()) / 1000.0);
        } else {
            this._newRequest.setGenerated(false);
            Collection destinations = (Collection)this._tblProbabilities.getInput();
            for (Destination dest : destinations) {
                if (!(dest.getProb() > 0.0)) continue;
                this._newRequest.addDestination(dest);
            }
        }
    }

    protected void okPressed() {
        this.exportRequest();
        super.okPressed();
    }

    public Request getNewRequest() {
        return this._newRequest;
    }
}

