/*
 * Decompiled with CFR 0.152.
 */
package org.acmestudio.ui.analysis.performance.part;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.acmestudio.acme.core.IAcmeObject;
import org.acmestudio.acme.core.exception.AcmeException;
import org.acmestudio.acme.core.resource.IAcmeLanguageHelper;
import org.acmestudio.acme.core.resource.RegionManager;
import org.acmestudio.acme.core.type.IAcmeBooleanValue;
import org.acmestudio.acme.core.type.IAcmeFloatValue;
import org.acmestudio.acme.core.type.IAcmeRecordValue;
import org.acmestudio.acme.core.type.IAcmeSequenceValue;
import org.acmestudio.acme.core.type.IAcmeStringValue;
import org.acmestudio.acme.element.IAcmeComponent;
import org.acmestudio.acme.element.IAcmeComponentType;
import org.acmestudio.acme.element.IAcmeConnector;
import org.acmestudio.acme.element.IAcmeConnectorType;
import org.acmestudio.acme.element.IAcmeElement;
import org.acmestudio.acme.element.IAcmeFamily;
import org.acmestudio.acme.element.IAcmeSystem;
import org.acmestudio.acme.element.property.IAcmeProperty;
import org.acmestudio.acme.element.property.IAcmePropertyValue;
import org.acmestudio.acme.model.IAcmeCommandFactory;
import org.acmestudio.acme.model.command.IAcmePropertyCommand;
import org.acmestudio.acme.model.util.core.UMSequenceValue;
import org.acmestudio.ui.Debug;
import org.acmestudio.ui.analysis.performance.model.Destination;
import org.acmestudio.ui.analysis.performance.model.PerformanceModelManager;
import org.acmestudio.ui.analysis.performance.model.QNComponent;
import org.acmestudio.ui.analysis.performance.model.QNConnector;
import org.acmestudio.ui.analysis.performance.model.QNSystem;
import org.acmestudio.ui.analysis.performance.model.Request;
import org.acmestudio.ui.analysis.performance.model.Server;
import org.acmestudio.ui.analysis.performance.part.RequestDialog;
import org.acmestudio.ui.analysis.performance.util.PerformanceException;
import org.acmestudio.ui.editor.diagram.util.Constants;
import org.acmestudio.ui.resource.ResourceHelper;
import org.acmestudio.ui.util.Listeners;
import org.acmestudio.ui.view.element.ElementViewPart;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.PageBook;

public class PerformanceViewPart
extends ElementViewPart {
    private static final int TEXT_FIELD_WIDTH = 60;
    private Button _btnCalculateConnVisits;
    private Button _btnSpecifyConnVisits;
    private Button _btnCalculateCompVisits;
    private Button _btnSpecifyCompVisits;
    private Text _overloadedSystemLabel;
    private Label _overloadedComponentLabel;
    private Composite _blankControl;
    Composite _connectorControl = null;
    Composite _componentControl = null;
    Composite _systemControl = null;
    Text _txtDelayTime;
    Text _txtServiceTime;
    Text _txtReplication;
    Text _txtSysResponseTime;
    Text _txtCompResponseTime;
    Text _txtLength;
    Text _txtUtilization;
    Text _txtCompVisits;
    Text _txtConnVisits;
    Text _txtArrivalRate;
    Text _txtOverloaded;
    Text _txtNetworkPop;
    Text _txtNetworkResponse;
    IAcmeElement _selectedElement;
    public FocusAdapter _exportComponentOnFocus = new FocusAdapter(){

        public void focusLost(FocusEvent evt) {
            PerformanceViewPart.this.exportComponentProperties();
        }
    };
    public FocusAdapter _exportConnectorOnFocus = new FocusAdapter(){

        public void focusLost(FocusEvent evt) {
            PerformanceViewPart.this.exportConnectorProperties();
        }
    };
    public FocusAdapter _exportSystemOnFocus = new FocusAdapter(){

        public void focusLost(FocusEvent evt) {
            PerformanceViewPart.this.exportSystemProperties();
        }
    };
    private ListViewer _lstRequests;
    private Button _btnAddRequest;
    private Button _btnEditRequest;
    private Button _btnRemoveRequest;
    private QNComponent _qnComponent;
    private IAcmeSequenceValue _requestSequence;

    protected void exportSystemProperties() {
        try {
            if (this._selectedElement instanceof IAcmeSystem) {
                IAcmeSystem sys = (IAcmeSystem)this._selectedElement;
                IAcmeProperty arrRateProp = sys.getProperty("perf-arrivalRate");
                IAcmeLanguageHelper helper = ResourceHelper.languageHelperForAcmeObject((IAcmeObject)sys);
                IAcmePropertyValue newARVal = helper.propertyValueFromString(this._txtArrivalRate.getText(), new RegionManager());
                sys.getCommandFactory().propertyValueSetCommand(arrRateProp, newARVal).execute();
            }
        }
        catch (IllegalStateException e) {
            Debug.errorln((Throwable)e);
        }
        catch (AcmeException e) {
            Debug.errorln((Throwable)e);
        }
        catch (Exception e) {
            Debug.errorln((Throwable)e);
        }
    }

    protected void exportConnectorProperties() {
        try {
            if (this._selectedElement instanceof IAcmeConnector) {
                IAcmeConnector conn = (IAcmeConnector)this._selectedElement;
                IAcmeProperty delayTimeProp = conn.getProperty("perf-delayTime");
                IAcmeProperty visitsProp = conn.getProperty("perf-visits");
                IAcmeLanguageHelper helper = ResourceHelper.languageHelperForAcmeObject((IAcmeObject)conn);
                IAcmePropertyValue newDTVal = helper.propertyValueFromString(this._txtDelayTime.getText(), new RegionManager());
                IAcmePropertyValue newVVal = helper.propertyValueFromString(this._txtConnVisits.getText(), new RegionManager());
                LinkedList<IAcmePropertyCommand> cmds = new LinkedList<IAcmePropertyCommand>();
                cmds.add(conn.getCommandFactory().propertyValueSetCommand(delayTimeProp, newDTVal));
                cmds.add(conn.getCommandFactory().propertyValueSetCommand(visitsProp, newVVal));
                conn.getCommandFactory().compoundCommand(cmds).execute();
            }
        }
        catch (Exception e) {
            Debug.errorln((Throwable)e);
        }
    }

    protected void exportComponentProperties() {
        try {
            if (this._selectedElement instanceof IAcmeComponent) {
                IAcmeComponent comp = (IAcmeComponent)this._selectedElement;
                IAcmeProperty serviceTimeProperty = comp.getProperty("perf-serviceTime");
                IAcmeProperty replicationProperty = comp.getProperty("perf-replication");
                IAcmeProperty visitsProperty = comp.getProperty("perf-visits");
                IAcmeProperty requestsProperty = comp.getProperty("perf-requests");
                IAcmeLanguageHelper helper = ResourceHelper.languageHelperForAcmeObject((IAcmeObject)comp);
                IAcmePropertyValue newSTVal = helper.propertyValueFromString(this._txtServiceTime.getText(), new RegionManager());
                IAcmePropertyValue newRVal = helper.propertyValueFromString(this._txtReplication.getText(), new RegionManager());
                IAcmePropertyValue newVVal = helper.propertyValueFromString(this._txtCompVisits.getText(), new RegionManager());
                LinkedList<IAcmePropertyCommand> cmds = new LinkedList<IAcmePropertyCommand>();
                IAcmeCommandFactory cf = comp.getCommandFactory();
                cmds.add(cf.propertyValueSetCommand(serviceTimeProperty, newSTVal));
                cmds.add(cf.propertyValueSetCommand(replicationProperty, newRVal));
                cmds.add(cf.propertyValueSetCommand(visitsProperty, newVVal));
                cmds.add(cf.propertyValueSetCommand(requestsProperty, (IAcmePropertyValue)this._requestSequence));
                cf.compoundCommand(cmds).execute();
            }
        }
        catch (Exception e) {
            Debug.errorln((Throwable)e);
        }
    }

    public IContributionItem[] getContributions() {
        return new IContributionItem[0];
    }

    public boolean isValidFor(IAcmeObject o) {
        IAcmeConnector conn;
        Object type;
        if (o instanceof IAcmeSystem) {
            IAcmeSystem sys = (IAcmeSystem)o;
            Object fam = sys.lookupName("PerformanceFam", true);
            if (fam != null && fam instanceof IAcmeFamily) {
                return sys.declaresType((IAcmeFamily)fam);
            }
        } else if (o instanceof IAcmeComponent) {
            IAcmeComponent comp = (IAcmeComponent)o;
            Object type2 = comp.lookupName("PerformanceComponent", true);
            if (type2 != null && type2 instanceof IAcmeComponentType) {
                return comp.declaresType((IAcmeComponentType)type2);
            }
        } else if (o instanceof IAcmeConnector && (type = (conn = (IAcmeConnector)o).lookupName("PerformanceConnector", true)) != null && type instanceof IAcmeConnectorType) {
            return conn.declaresType(((IAcmeConnectorType)type).getName());
        }
        return false;
    }

    public void createControl(Composite parent, int style) {
        this._composite = new PageBook(parent, style);
        this.createSystemPage();
        this.createComponentPage();
        this.createConnectorPage();
        this.createBlankPage();
        this.showPage(this._blankControl);
    }

    private void showPage(Composite control) {
        ((PageBook)this._composite).showPage((Control)control);
    }

    private void createBlankPage() {
        FormToolkit toolkit = new FormToolkit(Display.getCurrent());
        this._blankControl = toolkit.createComposite(this.getComposite(), 0);
        this._blankControl.setLayout((Layout)new FillLayout());
        toolkit.createLabel(this._blankControl, "There is no performance data for the current selection.", 0);
        toolkit.dispose();
    }

    private void createConnectorPage() {
        FormToolkit toolkit = new FormToolkit(Display.getCurrent());
        Composite connCon = this._connectorControl = toolkit.createComposite(this.getComposite());
        connCon.setLayout((Layout)new GridLayout(3, false));
        toolkit.createLabel(connCon, "Delay Time:", 0);
        this._txtDelayTime = toolkit.createText(connCon, "", 2048);
        this._txtDelayTime.addFocusListener((FocusListener)this._exportConnectorOnFocus);
        toolkit.createLabel(connCon, "ms", 0);
        Label vptLabel = toolkit.createLabel(connCon, "Visits per task:", 0);
        GridData vptgd = new GridData();
        vptgd.horizontalSpan = 4;
        vptLabel.setLayoutData((Object)vptgd);
        this._btnSpecifyConnVisits = toolkit.createButton(connCon, "Specified", 16);
        this._btnSpecifyConnVisits.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (PerformanceViewPart.this._btnSpecifyConnVisits.getSelection()) {
                    PerformanceViewPart.this._txtConnVisits.setEnabled(true);
                }
            }
        });
        this._txtConnVisits = toolkit.createText(connCon, "", 2048);
        this._txtConnVisits.addFocusListener((FocusListener)this._exportConnectorOnFocus);
        this._btnCalculateConnVisits = toolkit.createButton(this._connectorControl, "Calculate from requests", 16);
        this._btnCalculateConnVisits.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (PerformanceViewPart.this._btnCalculateConnVisits.getSelection()) {
                    PerformanceViewPart.this._txtConnVisits.setEnabled(false);
                }
            }
        });
        connCon.setSize(connCon.computeSize(-1, -1));
        toolkit.dispose();
    }

    public void createSystemPage() {
        FormToolkit toolkit = new FormToolkit(Display.getCurrent());
        Composite sysCon = this._systemControl = toolkit.createComposite(this.getComposite());
        sysCon.setLayout((Layout)new GridLayout(2, false));
        Group userSetGroup = new Group(sysCon, 0);
        toolkit.adapt((Composite)userSetGroup);
        userSetGroup.setText("Specified Property:");
        userSetGroup.setLayout((Layout)new GridLayout(3, false));
        toolkit.createLabel((Composite)userSetGroup, "Arrival Rate:", 0);
        this._txtArrivalRate = toolkit.createText((Composite)userSetGroup, "", 2048);
        Listeners.DoubleValidator dValid = new Listeners.DoubleValidator();
        dValid.setTarget(this._txtArrivalRate);
        this._txtArrivalRate.addVerifyListener(dValid.getValidator());
        this._txtArrivalRate.addFocusListener((FocusListener)this._exportSystemOnFocus);
        toolkit.createLabel((Composite)userSetGroup, "requests/sec", 0);
        Group calcGroup = new Group(sysCon, 0);
        toolkit.adapt((Composite)calcGroup);
        calcGroup.setText("Calculated Properties:");
        calcGroup.setLayout((Layout)new GridLayout(3, false));
        toolkit.createLabel((Composite)calcGroup, "Network Response", 0);
        this._txtNetworkResponse = toolkit.createText((Composite)calcGroup, "", 2048);
        this._txtNetworkResponse.setEditable(false);
        toolkit.createLabel((Composite)calcGroup, "ms", 0);
        toolkit.createLabel((Composite)calcGroup, "Population", 0);
        this._txtNetworkPop = toolkit.createText((Composite)calcGroup, "", 2048);
        this._txtNetworkPop.setEditable(false);
        GridData npgd = new GridData(768);
        npgd.horizontalSpan = 2;
        this._txtNetworkPop.setLayoutData((Object)npgd);
        this._overloadedSystemLabel = toolkit.createText((Composite)calcGroup, "Not Overloaded", 0);
        this._overloadedSystemLabel.setEditable(false);
        GridData osgd = new GridData(768);
        osgd.horizontalSpan = 3;
        this._overloadedSystemLabel.setLayoutData((Object)osgd);
        sysCon.setSize(sysCon.computeSize(-1, -1));
        toolkit.dispose();
    }

    public void createComponentPage() {
        FormToolkit toolkit = new FormToolkit(Display.getCurrent());
        Composite compCon = this._componentControl = toolkit.createComposite(this.getComposite());
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.numColumns = 3;
        compCon.setLayout((Layout)gridLayout);
        Group specGroup = new Group(compCon, 512);
        toolkit.adapt((Composite)specGroup);
        specGroup.setLayoutData((Object)new GridData(1296));
        specGroup.setText("Specified Properties:");
        gridLayout = new GridLayout(3, false);
        gridLayout.numColumns = 3;
        specGroup.setLayout((Layout)gridLayout);
        toolkit.createLabel((Composite)specGroup, "Service Time:", 0);
        this._txtServiceTime = toolkit.createText((Composite)specGroup, "", 2048);
        Listeners.DoubleValidator dValid = new Listeners.DoubleValidator();
        dValid.setTarget(this._txtServiceTime);
        this._txtServiceTime.addVerifyListener(dValid.getValidator());
        this._txtServiceTime.addFocusListener((FocusListener)this._exportComponentOnFocus);
        GridData stgd = new GridData();
        stgd.horizontalAlignment = 4;
        stgd.grabExcessHorizontalSpace = true;
        this._txtServiceTime.setLayoutData((Object)stgd);
        toolkit.createLabel((Composite)specGroup, "ms", 0);
        toolkit.createLabel((Composite)specGroup, "Degree of Replication:", 0);
        this._txtReplication = toolkit.createText((Composite)specGroup, "", 2048);
        this._txtReplication.setLayoutData((Object)new GridData(768));
        this._txtReplication.addFocusListener((FocusListener)this._exportComponentOnFocus);
        toolkit.createLabel((Composite)specGroup, "", 0);
        Label vLabel = toolkit.createLabel((Composite)specGroup, "Visits per Task:", 0);
        GridData vgd = new GridData(256);
        vgd.horizontalSpan = 3;
        vLabel.setLayoutData((Object)vgd);
        this._btnSpecifyCompVisits = toolkit.createButton((Composite)specGroup, "Specified", 16);
        this._btnSpecifyCompVisits.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (PerformanceViewPart.this._btnSpecifyCompVisits.getSelection()) {
                    PerformanceViewPart.this._txtCompVisits.setEnabled(true);
                }
            }
        });
        this._txtCompVisits = toolkit.createText((Composite)specGroup, "", 2048);
        this._txtCompVisits.addFocusListener((FocusListener)this._exportComponentOnFocus);
        GridData cvgd = new GridData();
        cvgd.horizontalSpan = 2;
        this._txtCompVisits.setLayoutData((Object)cvgd);
        this._btnCalculateCompVisits = toolkit.createButton((Composite)specGroup, "Calculate from Requests", 16);
        this._btnCalculateCompVisits.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (PerformanceViewPart.this._btnCalculateCompVisits.getSelection()) {
                    PerformanceViewPart.this._txtCompVisits.setEnabled(false);
                }
            }
        });
        Group calcGroup = new Group(compCon, 0);
        toolkit.adapt((Composite)calcGroup);
        calcGroup.setLayoutData((Object)new GridData(272));
        calcGroup.setText("Calculated Properties:");
        gridLayout = new GridLayout(3, false);
        gridLayout.numColumns = 3;
        calcGroup.setLayout((Layout)gridLayout);
        Label uLabel = toolkit.createLabel((Composite)calcGroup, "", 0);
        uLabel.setText("Avg. Utilization:");
        this._txtUtilization = toolkit.createText((Composite)calcGroup, "", 0);
        this._txtUtilization.setEditable(false);
        GridData utgd = new GridData(128);
        utgd.widthHint = 60;
        this._txtUtilization.setLayoutData((Object)utgd);
        Label pLabel = toolkit.createLabel((Composite)calcGroup, "", 0);
        pLabel.setText("%");
        Label qLabel = toolkit.createLabel((Composite)calcGroup, "", 0);
        qLabel.setText("Avg. Queue Length:");
        this._txtLength = toolkit.createText((Composite)calcGroup, "", 0);
        this._txtLength.setEditable(false);
        GridData lngd = new GridData(256);
        lngd.widthHint = 60;
        this._txtLength.setLayoutData((Object)lngd);
        toolkit.createLabel((Composite)calcGroup, "", 0);
        Label rLabel = toolkit.createLabel((Composite)calcGroup, "", 0);
        rLabel.setText("Avg. Response Time:");
        this._txtCompResponseTime = toolkit.createText((Composite)calcGroup, "", 0);
        this._txtCompResponseTime.setEditable(false);
        GridData argd = new GridData(128);
        argd.widthHint = 60;
        this._txtCompResponseTime.setLayoutData((Object)argd);
        toolkit.createLabel((Composite)calcGroup, "ms", 0);
        this._overloadedComponentLabel = toolkit.createLabel((Composite)calcGroup, "", 0);
        this._overloadedComponentLabel.setText("Not overloaded");
        GridData ocgd = new GridData(256);
        ocgd.horizontalSpan = 768;
        this._overloadedComponentLabel.setLayoutData((Object)ocgd);
        Group requestGroup = new Group(compCon, 0);
        toolkit.adapt((Composite)requestGroup);
        requestGroup.setLayoutData((Object)new GridData(272));
        requestGroup.setText("Requests:");
        gridLayout = new GridLayout(2, false);
        gridLayout.numColumns = 4;
        requestGroup.setLayout((Layout)gridLayout);
        this._lstRequests = new ListViewer((Composite)requestGroup, 512);
        this._lstRequests.setContentProvider((IContentProvider)new RequestContentProvider());
        this._lstRequests.setLabelProvider((IBaseLabelProvider)new RequestLabelProvider());
        GridData lrgd = new GridData();
        lrgd.verticalSpan = 3;
        lrgd.verticalAlignment = 16;
        lrgd.horizontalAlignment = 256;
        this._lstRequests.getControl().setLayoutData((Object)new GridData(272));
        Composite composite = toolkit.createComposite((Composite)requestGroup, 0);
        composite.setLayout((Layout)new GridLayout());
        this._btnAddRequest = toolkit.createButton(composite, "Add...", 8);
        this._btnAddRequest.setLayoutData((Object)new GridData(256));
        this._btnAddRequest.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PerformanceViewPart.this.initializeQNComponent();
                RequestDialog d = new RequestDialog(Display.getCurrent().getActiveShell(), PerformanceViewPart.this._qnComponent);
                if (d.open() == 0) {
                    PerformanceViewPart.this._qnComponent.getServer().addRequest(d.getNewRequest());
                    PerformanceViewPart.this.updateRequestSequence();
                    PerformanceViewPart.this.exportComponentProperties();
                    PerformanceViewPart.this._lstRequests.setInput((Object)PerformanceViewPart.this._requestSequence);
                }
            }
        });
        this._btnEditRequest = toolkit.createButton(composite, "Edit...", 8);
        this._btnEditRequest.setLayoutData((Object)new GridData(256));
        this._btnEditRequest.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PerformanceViewPart.this.initializeQNComponent();
                String[] selection = PerformanceViewPart.this._lstRequests.getList().getSelection();
                if (selection.length > 0) {
                    Request rd = PerformanceViewPart.this._qnComponent.getServer().getRequest(selection[0]);
                    RequestDialog d = new RequestDialog(Display.getCurrent().getActiveShell(), PerformanceViewPart.this._qnComponent, rd);
                    if (d.open() == 0) {
                        PerformanceViewPart.this._qnComponent.getServer().deleteRequest(rd);
                        PerformanceViewPart.this._qnComponent.getServer().addRequest(d.getNewRequest());
                        PerformanceViewPart.this.updateRequestSequence();
                        PerformanceViewPart.this.exportComponentProperties();
                        PerformanceViewPart.this._lstRequests.add((Object)d.getNewRequest());
                    }
                }
            }
        });
        this._btnRemoveRequest = toolkit.createButton(composite, "Remove", 8);
        this._btnRemoveRequest.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                PerformanceViewPart.this.initializeQNComponent();
                String[] selection = PerformanceViewPart.this._lstRequests.getList().getSelection();
                int i = 0;
                while (i < selection.length) {
                    Request rd = PerformanceViewPart.this._qnComponent.getServer().getRequest(selection[i]);
                    QNSystem qnS = PerformanceModelManager.getQNSystem((IAcmeSystem)PerformanceViewPart.this._qnComponent.getAcmeComponent().getParent());
                    Set components = qnS.getAcmeSystem().getComponents();
                    for (IAcmeComponent comp : components) {
                        QNComponent qnComp = PerformanceModelManager.getQNComponent(comp);
                        Server qnServer = qnComp.getServer();
                        for (String reqKey : qnServer.getRequests().keySet()) {
                            Request req = qnServer.getRequest(reqKey);
                            for (Destination dest : req.getDestinations()) {
                                if (!rd.equals(dest.getTo())) continue;
                                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Request delete error", (String)"Delete the destinations involving this request first");
                            }
                        }
                    }
                    PerformanceViewPart.this._qnComponent.getServer().deleteRequest(rd);
                    PerformanceViewPart.this.updateRequestSequence();
                    PerformanceViewPart.this.exportComponentProperties();
                    PerformanceViewPart.this._lstRequests.setInput((Object)PerformanceViewPart.this._requestSequence);
                    ++i;
                }
            }
        });
        compCon.setSize(compCon.computeSize(-1, -1));
        toolkit.dispose();
    }

    protected void initializeQNComponent() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    QNComponent qnComp;
                    monitor.beginTask("Calculating performance properties: ", 3);
                    monitor.subTask("Calculating System Properties");
                    IAcmeComponent comp = (IAcmeComponent)PerformanceViewPart.this._selectedElement;
                    IAcmeSystem sys = (IAcmeSystem)comp.getParent();
                    QNSystem qnSys = PerformanceModelManager.getQNSystem(sys);
                    if (qnSys != null) {
                        qnSys.clearQnData();
                    }
                    qnSys = new QNSystem(sys);
                    qnSys.checkProps();
                    monitor.worked(1);
                    monitor.subTask("Establishing component network");
                    Set components = sys.getComponents();
                    for (IAcmeComponent cmp : components) {
                        qnComp = PerformanceModelManager.getQNComponent(cmp);
                        if (qnComp.getServer() != null) continue;
                        qnComp.addServer();
                    }
                    monitor.worked(1);
                    monitor.subTask("Extracting requests and destinations");
                    components = sys.getComponents();
                    for (IAcmeComponent cmp : components) {
                        qnComp = PerformanceModelManager.getQNComponent(cmp);
                        IAcmeSequenceValue seq = (IAcmeSequenceValue)cmp.getProperty("perf-requests").getValue();
                        List values = seq.getValues();
                        try {
                            for (IAcmePropertyValue value : values) {
                                IAcmeRecordValue rec = (IAcmeRecordValue)value;
                                Request r = new Request(rec, qnComp.getServer());
                                qnComp.getServer().addRequest(r);
                                r.processDestinations();
                            }
                        }
                        catch (PerformanceException e) {
                            Debug.errorln((Throwable)e);
                        }
                    }
                    monitor.worked(1);
                    PerformanceViewPart.this._qnComponent = PerformanceModelManager.getQNComponent(comp);
                }
                finally {
                    monitor.setCanceled(true);
                    monitor.done();
                }
            }
        };
        try {
            new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            Debug.errorln((Throwable)e);
        }
    }

    protected void refreshRequestsFromList() {
        String[] items = this._lstRequests.getList().getItems();
        LinkedList<IAcmePropertyValue> vals = new LinkedList<IAcmePropertyValue>();
        int i = 0;
        while (i < items.length) {
            vals.add((IAcmePropertyValue)this._lstRequests.getData(items[i]));
            ++i;
        }
        this._requestSequence = new UMSequenceValue(vals);
        this._lstRequests.setInput((Object)this._requestSequence);
    }

    public void setInput(IAcmeElement o) {
        super.setInput(o);
        if (o instanceof IAcmeComponent) {
            IAcmeComponent comp = (IAcmeComponent)o;
            this._selectedElement = comp;
            this.importComponentProperties();
            this.showPage(this._componentControl);
        } else if (o instanceof IAcmeConnector) {
            this._selectedElement = (IAcmeConnector)o;
            this.importConnectorProperty();
            this.showPage(this._connectorControl);
        } else if (o instanceof IAcmeSystem) {
            this._selectedElement = (IAcmeSystem)o;
            this.importSystemProperties();
            this.showPage(this._systemControl);
        } else {
            this._selectedElement = null;
            this.showPage(this._blankControl);
        }
    }

    private boolean importSystemProperties() {
        if (this._selectedElement instanceof IAcmeSystem) {
            IAcmeSystem sys = (IAcmeSystem)this._selectedElement;
            IAcmeProperty arrivalRateProp = sys.getProperty("perf-arrivalRate");
            IAcmeProperty networkPopProp = sys.getProperty("perf-networkPop");
            IAcmeProperty overloadedProp = sys.getProperty("perf-overloaded");
            IAcmeProperty networkResponse = sys.getProperty("perf-networkResponse");
            if (arrivalRateProp == null || networkPopProp == null || overloadedProp == null || networkResponse == null) {
                return false;
            }
            if (arrivalRateProp.getValue() != null) {
                this._txtArrivalRate.setText(arrivalRateProp.getValue().toString());
            }
            if (networkPopProp.getValue() != null) {
                this._txtNetworkPop.setText(networkPopProp.getValue().toString());
            }
            if (networkResponse.getValue() != null) {
                this._txtNetworkResponse.setText(networkResponse.getValue().toString());
            }
            if (overloadedProp.getValue() != null) {
                boolean overloaded = ((IAcmeBooleanValue)overloadedProp.getValue()).getValue();
                this._overloadedSystemLabel.setText(overloaded ? "System is overloaded" : "System is not overloaded");
            }
            return true;
        }
        return false;
    }

    private boolean importConnectorProperty() {
        if (this._selectedElement instanceof IAcmeConnector) {
            IAcmeConnector conn = (IAcmeConnector)this._selectedElement;
            IAcmeProperty delayTimeProp = conn.getProperty("perf-delayTime");
            IAcmeProperty visitsProp = conn.getProperty("perf-visits");
            if (visitsProp == null || delayTimeProp == null) {
                return false;
            }
            QNConnector qConn = PerformanceModelManager.getQNConnector(conn);
            if (qConn != null && qConn.getVisitsp()) {
                this._btnSpecifyConnVisits.setSelection(true);
            } else {
                this._btnCalculateConnVisits.setSelection(true);
            }
            if (delayTimeProp.getValue() != null) {
                this._txtDelayTime.setText(delayTimeProp.getValue().toString());
            }
            if (visitsProp.getValue() != null) {
                this._txtConnVisits.setText(visitsProp.getValue().toString());
            }
            return true;
        }
        return false;
    }

    private boolean importComponentProperties() {
        if (this._selectedElement instanceof IAcmeComponent) {
            IAcmeComponent comp = (IAcmeComponent)this._selectedElement;
            IAcmeProperty serviceTimeProp = comp.getProperty("perf-serviceTime");
            IAcmeProperty replicationProp = comp.getProperty("perf-replication");
            IAcmeProperty visitsProp = comp.getProperty("perf-visits");
            IAcmeProperty utilizationProp = comp.getProperty("perf-utilization");
            IAcmeProperty lengthProp = comp.getProperty("perf-length");
            IAcmeProperty responseTimeProp = comp.getProperty("perf-responseTime");
            IAcmeProperty overloadedProp = comp.getProperty("perf-overloaded");
            IAcmeProperty requests = comp.getProperty("perf-requests");
            if (serviceTimeProp == null || replicationProp == null || visitsProp == null || utilizationProp == null || lengthProp == null || responseTimeProp == null || overloadedProp == null) {
                return false;
            }
            QNComponent qC = PerformanceModelManager.getQNComponent(comp);
            if (qC != null && qC.getVisitsp()) {
                this._btnSpecifyCompVisits.setSelection(true);
            } else {
                this._btnCalculateCompVisits.setSelection(true);
            }
            if (serviceTimeProp.getValue() != null) {
                this._txtServiceTime.setText(serviceTimeProp.getValue().toString());
            }
            if (replicationProp.getValue() != null) {
                this._txtReplication.setText(replicationProp.getValue().toString());
            }
            if (visitsProp.getValue() != null) {
                this._txtCompVisits.setText(visitsProp.getValue().toString());
            }
            if (utilizationProp.getValue() != null) {
                this._txtUtilization.setText(new Float(((IAcmeFloatValue)utilizationProp.getValue()).getValue() * 100.0f).toString());
            }
            if (lengthProp.getValue() != null) {
                this._txtLength.setText(lengthProp.getValue().toString());
            }
            if (responseTimeProp.getValue() != null) {
                this._txtCompResponseTime.setText(responseTimeProp.getValue().toString());
            }
            if (overloadedProp.getValue() != null) {
                boolean overloaded = ((IAcmeBooleanValue)overloadedProp.getValue()).getValue();
                this._overloadedComponentLabel.setText(overloaded ? "Component is overloaded" : "Component is not overloaded");
                this._overloadedComponentLabel.setForeground(overloaded ? ColorConstants.red : ColorConstants.black);
            }
            if (requests != null) {
                this._requestSequence = (IAcmeSequenceValue)requests.getValue();
                this._lstRequests.setInput((Object)this._requestSequence);
            }
            return true;
        }
        return false;
    }

    public String getTitle() {
        return "Performance";
    }

    private void updateRequestSequence() {
        LinkedList<IAcmeRecordValue> vals = new LinkedList<IAcmeRecordValue>();
        for (Map.Entry<String, Request> entry : this._qnComponent.getServer().getRequests().entrySet()) {
            Request r = entry.getValue();
            vals.add(r.toAcme());
        }
        UMSequenceValue seq = new UMSequenceValue(vals);
        this._requestSequence = seq;
    }

    public class RequestLabelProvider
    extends LabelProvider {
        public String getText(Object element) {
            IAcmeRecordValue rec;
            if (element instanceof IAcmeRecordValue && (rec = (IAcmeRecordValue)element).getField("name").getValue() != null) {
                String name = ((IAcmeStringValue)rec.getField("name").getValue()).getValue();
                return name;
            }
            return "";
        }
    }

    public class RequestContentProvider
    implements IStructuredContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IAcmeSequenceValue) {
                IAcmeSequenceValue seq = (IAcmeSequenceValue)inputElement;
                seq.getValues().toArray();
            }
            return Constants.EMPTY_ELEMENTS;
        }
    }
}

