/*
 * Decompiled with CFR 0.152.
 */
package org.acmestudio.ui.analysis.performance.model;

import java.util.HashMap;
import java.util.Map;
import org.acmestudio.acme.element.IAcmeElementInstance;
import org.acmestudio.ui.analysis.performance.model.QNSystem;
import org.acmestudio.ui.analysis.performance.model.Request;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server {
    private IAcmeElementInstance parent;
    private QNSystem system;
    private Map<String, Request> m_requests = new HashMap<String, Request>();
    private double visit;

    public Server(IAcmeElementInstance p, QNSystem s) {
        this.parent = p;
        this.system = s;
    }

    public void deleteRequest(Request r) {
        this.m_requests.remove(r.getName());
    }

    public IAcmeElementInstance getParent() {
        return this.parent;
    }

    public QNSystem getSystem() {
        return this.system;
    }

    public Map<String, Request> getRequests() {
        return this.m_requests;
    }

    public void incrVisit(double d) {
        this.visit += d;
    }

    public double getVisit() {
        return this.visit;
    }

    public void addRequest(Request r) {
        this.m_requests.put(r.getName(), r);
    }

    public Request addOrGetRequest(String name) {
        Request r = this.m_requests.get(name);
        if (r != null) {
            return r;
        }
        r = new Request(this, name);
        this.m_requests.put(name, r);
        return r;
    }

    public Request getRequest(String name) {
        return this.m_requests.get(name);
    }

    public boolean processDestinations() {
        boolean flag = true;
        for (Request r : this.m_requests.values()) {
            flag = r.processDestinations() ? (flag &= true) : (flag &= false);
            this.getSystem().indexRequest(r);
        }
        return flag;
    }

    public void sumVisits() {
        this.visit = 0.0;
        for (Request r : this.m_requests.values()) {
            this.visit += r.getVisit();
        }
    }
}

