/*
 * Decompiled with CFR 0.152.
 */
package org.acmestudio.ui.analysis.performance.model;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.acmestudio.acme.core.IAcmeType;
import org.acmestudio.acme.core.type.IAcmeBooleanValue;
import org.acmestudio.acme.core.type.IAcmeFloatValue;
import org.acmestudio.acme.core.type.IAcmeRecordField;
import org.acmestudio.acme.core.type.IAcmeRecordValue;
import org.acmestudio.acme.core.type.IAcmeSequenceValue;
import org.acmestudio.acme.core.type.IAcmeStringValue;
import org.acmestudio.acme.element.property.IAcmePropertyValue;
import org.acmestudio.acme.model.DefaultAcmeModel;
import org.acmestudio.acme.model.util.core.UMBooleanValue;
import org.acmestudio.acme.model.util.core.UMFloatValue;
import org.acmestudio.acme.model.util.core.UMRecordValue;
import org.acmestudio.acme.model.util.core.UMSequenceValue;
import org.acmestudio.acme.model.util.core.UMStringValue;
import org.acmestudio.ui.analysis.performance.model.Destination;
import org.acmestudio.ui.analysis.performance.model.Server;
import org.acmestudio.ui.analysis.performance.util.PerformanceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Request {
    protected String name;
    protected Server parent;
    protected List<Destination> destinations = new ArrayList<Destination>();
    protected boolean generated = false;
    protected double genRate = 0.0;
    protected int index = 0;
    protected double visit = 0.0;

    public Request(IAcmeRecordValue rec, Server s) throws PerformanceException {
        this.parent = s;
        this.convertFromAcme(rec);
    }

    private void convertFromAcme(IAcmeRecordValue rec) throws PerformanceException {
        IAcmeRecordField nameField = rec.getField("name");
        IAcmeRecordField rateField = rec.getField("rate");
        IAcmeRecordField destField = rec.getField("dest");
        IAcmeRecordField startField = rec.getField("start");
        if (nameField != null) {
            this.name = ((IAcmeStringValue)nameField.getValue()).getValue();
        }
        if (startField != null) {
            this.generated = ((IAcmeBooleanValue)startField.getValue()).getValue();
        }
        if (rateField != null) {
            this.genRate = ((IAcmeFloatValue)rateField.getValue()).getValue() / 1000.0f;
        }
        if (destField != null) {
            List dests = ((IAcmeSequenceValue)destField.getValue()).getValues();
            for (IAcmePropertyValue val : dests) {
                Destination dest = new Destination((IAcmeRecordValue)val, this);
                this.destinations.add(dest);
            }
        }
    }

    public IAcmeRecordValue toAcme() {
        UMRecordValue rec = new UMRecordValue();
        rec.addRecordField("name", (IAcmeType)DefaultAcmeModel.defaultStringType(), (IAcmePropertyValue)new UMStringValue(this.name));
        rec.addRecordField("rate", (IAcmeType)DefaultAcmeModel.defaultFloatType(), (IAcmePropertyValue)new UMFloatValue((float)this.genRate));
        rec.addRecordField("start", (IAcmeType)DefaultAcmeModel.defaultBooleanType(), (IAcmePropertyValue)new UMBooleanValue(this.generated));
        LinkedList<IAcmeRecordValue> vals = new LinkedList<IAcmeRecordValue>();
        for (Destination dest : this.destinations) {
            vals.add(dest.toAcme());
        }
        UMSequenceValue seq = new UMSequenceValue(vals);
        rec.addRecordField("dest", (IAcmeType)DefaultAcmeModel.defaultSequenceType(), (IAcmePropertyValue)seq);
        return rec;
    }

    public Request(Server s, String name) {
        this.generated = false;
        this.name = name;
        this.index = 0;
        this.parent = s;
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public void setGenerated(boolean generated) {
        this.generated = generated;
    }

    public double getGenRate() {
        return this.genRate;
    }

    public void setGenRate(double rate) {
        this.genRate = rate;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getVisit() {
        return this.visit;
    }

    public void setVisit(double visit) {
        this.visit = visit;
    }

    public Server getParent() {
        return this.parent;
    }

    public void mulGenRate(double r) {
        this.genRate *= r;
    }

    public List<Destination> getDestinations() {
        return this.destinations;
    }

    public void addDestination(Destination d) {
        this.destinations.add(d);
    }

    public boolean processDestinations() {
        boolean flag = true;
        for (Destination d : this.getDestinations()) {
            if (d.getTo() != null) continue;
            if (d.setPointer()) {
                flag &= true;
                continue;
            }
            flag &= false;
        }
        return flag;
    }

    public void splitDestinations() {
        for (Destination d : this.getDestinations()) {
            if (d.getTo() != null) continue;
            d.split();
        }
    }

    public boolean containsDestination(Destination d) {
        return this.destinations.contains(d);
    }

    public void deleteDestination(Destination d) {
        this.destinations.remove(d);
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof Request) {
            Request req = (Request)arg0;
            return req.generated == this.generated && req.genRate == this.genRate && req.name.equals(this.name) && req.index == this.index;
        }
        return false;
    }
}

