/*
 * Decompiled with CFR 0.152.
 */
package org.acmestudio.ui.analysis.performance.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.acmestudio.acme.core.exception.AcmeException;
import org.acmestudio.acme.core.extension.IAcmeElementExtension;
import org.acmestudio.acme.core.type.IAcmeFloatValue;
import org.acmestudio.acme.core.type.IAcmeRecordValue;
import org.acmestudio.acme.core.type.IAcmeSequenceValue;
import org.acmestudio.acme.element.IAcmeComponent;
import org.acmestudio.acme.element.IAcmeConnector;
import org.acmestudio.acme.element.IAcmeElementInstance;
import org.acmestudio.acme.element.IAcmeSystem;
import org.acmestudio.acme.element.property.IAcmeProperty;
import org.acmestudio.acme.element.property.IAcmePropertyBearer;
import org.acmestudio.acme.element.property.IAcmePropertyValue;
import org.acmestudio.acme.element.representation.IAcmeRepresentation;
import org.acmestudio.acme.model.command.IAcmePropertyCommand;
import org.acmestudio.acme.model.command.IAcmePropertyCreateCommand;
import org.acmestudio.acme.model.util.core.UMBooleanValue;
import org.acmestudio.acme.model.util.core.UMFloatValue;
import org.acmestudio.ui.Debug;
import org.acmestudio.ui.analysis.performance.model.Destination;
import org.acmestudio.ui.analysis.performance.model.PerformanceModelManager;
import org.acmestudio.ui.analysis.performance.model.QNComponent;
import org.acmestudio.ui.analysis.performance.model.QNConnector;
import org.acmestudio.ui.analysis.performance.model.Request;
import org.acmestudio.ui.analysis.performance.model.Server;
import org.acmestudio.ui.analysis.performance.util.PerformanceException;
import org.acmestudio.ui.analysis.performance.util.Solver;

public class QNSystem
implements IAcmeElementExtension {
    private IAcmeSystem acmeSystem = null;
    protected int requestCount = 0;
    protected double genRate = 0.0;
    protected double arrivalRate = 0.0;
    protected double networkResponse = 0.0;
    protected double networkPop = 0.0;
    protected boolean overloaded = false;
    List requests = new ArrayList();
    List allRequests = new ArrayList();
    List genRequests = new ArrayList();
    Server server = null;

    public IAcmeSystem getAcmeSystem() {
        return this.acmeSystem;
    }

    protected void computeVisitsFromRequests() throws PerformanceException {
        int j;
        double[] b = new double[this.allRequests.size()];
        double[] x = new double[this.allRequests.size()];
        double[][] A = new double[this.allRequests.size()][this.allRequests.size()];
        int i = 0;
        while (i < this.allRequests.size()) {
            A[i][i] = -1.0;
            ++i;
        }
        for (Request r : this.allRequests) {
            if (r.isGenerated()) continue;
            int i2 = r.getIndex();
            for (Destination d : r.getDestinations()) {
                int j2 = d.getTo().getIndex();
                double[] dArray = A[j2];
                int n = i2;
                dArray[n] = dArray[n] + d.getProb();
            }
        }
        double R = this.arrivalRate + this.genRate;
        if (R <= 0.0) {
            this.arrivalRate = 0.0;
            return;
        }
        for (Request req : this.genRequests) {
            Iterator<Destination> f = req.getDestinations().iterator();
            double fraction = req.getGenRate() / R;
            while (f.hasNext()) {
                Destination destination = f.next();
                int n = j = destination.getTo().getIndex();
                b[n] = b[n] - destination.getProb() * fraction;
            }
        }
        Iterator<Object> i3 = this.server.getRequests().values().iterator();
        double fraction = this.arrivalRate / R;
        while (i3.hasNext()) {
            Request req = (Request)i3.next();
            for (Destination destination : req.getDestinations()) {
                int n = j = destination.getTo().getIndex();
                b[n] = b[n] - destination.getProb() / fraction;
            }
        }
        Solver.solve(A, x, b);
        for (Request r : this.allRequests) {
            int idx = r.getIndex();
            r.setVisit(x[idx]);
            r.getParent().incrVisit(x[idx]);
        }
        this.arrivalRate = R;
        Set comps = this.acmeSystem.getComponents();
        for (IAcmeComponent acmeComp : comps) {
            QNComponent comp = PerformanceModelManager.getQNComponent(acmeComp);
            Server ss = comp.getServer();
            ss.sumVisits();
            comp.setVisits(ss.getVisit());
        }
        Set conns = this.acmeSystem.getConnectors();
        for (IAcmeConnector iAcmeConnector : conns) {
            QNConnector conn = PerformanceModelManager.getQNConnector(iAcmeConnector);
            Server ss = conn.getServer();
            ss.sumVisits();
            conn.setVisits(ss.getVisit());
        }
    }

    protected void dumpProps() {
        IAcmeProperty networkResponseProperty = this.acmeSystem.getProperty("perf-networkResponse");
        IAcmeProperty networkPopProp = this.acmeSystem.getProperty("perf-networkPop");
        IAcmeProperty overloadedProp = this.acmeSystem.getProperty("perf-overloaded");
        UMFloatValue nrVal = new UMFloatValue((float)this.networkResponse);
        UMFloatValue npVal = new UMFloatValue((float)this.networkPop);
        UMBooleanValue oVal = new UMBooleanValue(this.overloaded);
        LinkedList<IAcmePropertyCommand> cmds = new LinkedList<IAcmePropertyCommand>();
        cmds.add(networkResponseProperty.getCommandFactory().propertyValueSetCommand(networkResponseProperty, (IAcmePropertyValue)nrVal));
        cmds.add(networkPopProp.getCommandFactory().propertyValueSetCommand(networkPopProp, (IAcmePropertyValue)npVal));
        cmds.add(overloadedProp.getCommandFactory().propertyValueSetCommand(overloadedProp, (IAcmePropertyValue)oVal));
        try {
            networkPopProp.getCommandFactory().compoundCommand(cmds).execute();
        }
        catch (IllegalStateException e) {
            Debug.errorln((Throwable)e);
        }
        catch (AcmeException e) {
            Debug.errorln((Throwable)e);
        }
    }

    public void clearQnData() {
        Set comps = this.acmeSystem.getComponents();
        for (IAcmeComponent comp : comps) {
            PerformanceModelManager.setQNComponent(comp, null);
            Set reps = comp.getRepresentations();
            for (IAcmeRepresentation rep : reps) {
                QNSystem sys = PerformanceModelManager.getQNSystem(rep.getSystem());
                sys.clearQnData();
            }
        }
        Set conns = this.acmeSystem.getConnectors();
        for (IAcmeConnector conn : conns) {
            PerformanceModelManager.setQNConnector(conn, null);
            Set reps = conn.getRepresentations();
            for (IAcmeRepresentation rep : reps) {
                QNSystem sys = PerformanceModelManager.getQNSystem(rep.getSystem());
                sys.clearQnData();
            }
        }
        PerformanceModelManager.setQNSystem(this.acmeSystem, null);
    }

    public QNSystem(IAcmeSystem s) {
        this.acmeSystem = s;
        PerformanceModelManager.setQNSystem(this.acmeSystem, this);
    }

    public void checkProps() {
        IAcmeProperty arrivalRateProp = this.acmeSystem.getProperty("perf-arrivalRate");
        IAcmeProperty networkResponseProp = this.acmeSystem.getProperty("perf-networkResponse");
        IAcmeProperty networkPopProp = this.acmeSystem.getProperty("perf-networkPop");
        IAcmeProperty overloadedProp = this.acmeSystem.getProperty("perf-overloaded");
        LinkedList<IAcmePropertyCreateCommand> propAddCmds = new LinkedList<IAcmePropertyCreateCommand>();
        UMFloatValue floatZero = new UMFloatValue(0.0f);
        if (arrivalRateProp == null) {
            propAddCmds.add(this.acmeSystem.getCommandFactory().propertyCreateCommand((IAcmePropertyBearer)this.acmeSystem, "perf-arrivalRate", "float", (IAcmePropertyValue)floatZero));
            this.arrivalRate = 0.0;
        }
        if (networkResponseProp == null) {
            propAddCmds.add(this.acmeSystem.getCommandFactory().propertyCreateCommand((IAcmePropertyBearer)this.acmeSystem, "perf-networkResponse", "float", (IAcmePropertyValue)floatZero));
        }
        if (networkPopProp == null) {
            propAddCmds.add(this.acmeSystem.getCommandFactory().propertyCreateCommand((IAcmePropertyBearer)this.acmeSystem, "perf-networkPop", "float", (IAcmePropertyValue)floatZero));
        }
        if (overloadedProp == null) {
            propAddCmds.add(this.acmeSystem.getCommandFactory().propertyCreateCommand((IAcmePropertyBearer)this.acmeSystem, "perf-overloaded", "boolean", (IAcmePropertyValue)new UMBooleanValue(false)));
        }
        if (!propAddCmds.isEmpty()) {
            try {
                List newProps = (List)this.acmeSystem.getCommandFactory().compoundCommand(propAddCmds).execute();
                arrivalRateProp = PerformanceModelManager.getNewProperty(arrivalRateProp, "perf-arrivalRate", newProps);
                networkResponseProp = PerformanceModelManager.getNewProperty(networkResponseProp, "perf-networkResponse", newProps);
                networkPopProp = PerformanceModelManager.getNewProperty(networkPopProp, "perf-networkPop", newProps);
                overloadedProp = PerformanceModelManager.getNewProperty(overloadedProp, "perf-overloaded", newProps);
            }
            catch (IllegalStateException e) {
                Debug.errorln((Throwable)e);
            }
            catch (AcmeException e) {
                Debug.errorln((Throwable)e);
            }
        }
        this.arrivalRate = ((IAcmeFloatValue)arrivalRateProp.getValue()).getValue() / 1000.0f;
        this.networkResponse = 0.0;
        this.networkPop = 0.0;
        this.overloaded = false;
        Set comps = this.acmeSystem.getComponents();
        for (IAcmeComponent component : comps) {
            QNComponent comp = PerformanceModelManager.getQNComponent(component);
            comp.checkProps();
        }
        Set conns = this.acmeSystem.getConnectors();
        for (IAcmeConnector connector : conns) {
            QNConnector conn = PerformanceModelManager.getQNConnector(connector);
            conn.checkProps();
        }
    }

    public boolean calculatePerformance() throws PerformanceException {
        boolean visitsp = false;
        boolean requestsp = false;
        Set comps = this.acmeSystem.getComponents();
        if (!comps.isEmpty()) {
            requestsp = true;
            visitsp = true;
        }
        for (IAcmeComponent component : comps) {
            QNComponent comp = PerformanceModelManager.getQNComponent(component);
            if (!(visitsp &= comp.getVisitsp()) && !requestsp) break;
        }
        boolean ok = visitsp | requestsp;
        boolean flag = false;
        if (requestsp) {
            this.processRequests();
            if (this.processDestinations()) {
                flag = true;
            }
            this.computeVisitsFromRequests();
        }
        if (this.arrivalRate == 0.0) {
            ok = false;
        }
        comps = this.acmeSystem.getComponents();
        for (IAcmeComponent component : comps) {
            QNComponent comp = PerformanceModelManager.getQNComponent(component);
            if (comp.calculatePerformance(ok)) {
                flag &= true;
                continue;
            }
            flag &= false;
        }
        Set conns = this.acmeSystem.getConnectors();
        for (IAcmeConnector connector : conns) {
            QNConnector conn = PerformanceModelManager.getQNConnector(connector);
            if (conn.calculatePerformance(ok)) {
                flag &= true;
                continue;
            }
            flag &= false;
        }
        if (ok) {
            if (this.arrivalRate == 0.0) {
                this.networkResponse = 0.0;
            } else {
                this.networkResponse = this.networkPop / this.arrivalRate;
                this.dumpProps();
            }
        }
        return flag;
    }

    public Server getServer() {
        return this.server;
    }

    public double getArrivalRate() {
        return this.arrivalRate;
    }

    public void incrPop(double p) {
        this.networkPop += p;
    }

    public void overload() {
        this.overloaded = true;
    }

    public void indexRequest(Request r) {
        if (r.isGenerated()) {
            this.genRequests.add(r);
            this.genRate += r.getGenRate();
        }
        this.allRequests.add(r);
        r.setIndex(this.allRequests.size() - 1);
    }

    public void processRequests() throws PerformanceException {
        QNComponent comp;
        Set conns = this.acmeSystem.getConnectors();
        for (IAcmeConnector connector : conns) {
            Iterator conn = PerformanceModelManager.getQNConnector(connector);
            ((QNConnector)((Object)conn)).addServer();
        }
        Set comps = this.acmeSystem.getComponents();
        for (IAcmeComponent component : comps) {
            comp = PerformanceModelManager.getQNComponent(component);
            comp.addServer();
        }
        comps = this.acmeSystem.getComponents();
        for (IAcmeComponent component : comps) {
            comp = PerformanceModelManager.getQNComponent(component);
            comp.processRequests();
        }
        this.server = new Server((IAcmeElementInstance)this.acmeSystem, this);
        if (this.acmeSystem.getProperty("perf-requests") != null) {
            IAcmeSequenceValue myRequestSeq = (IAcmeSequenceValue)this.acmeSystem.getProperty("perf-requests").getValue();
            List pve = myRequestSeq.getValues();
            for (IAcmePropertyValue value : pve) {
                IAcmeRecordValue rec = (IAcmeRecordValue)value;
                Request r = new Request(rec, this.server);
                r.processDestinations();
                this.server.addRequest(r);
            }
        }
    }

    public boolean processDestinations() {
        Set comps = this.acmeSystem.getComponents();
        boolean flag = true;
        for (IAcmeComponent component : comps) {
            QNComponent comp = PerformanceModelManager.getQNComponent(component);
            Server server = comp.getServer();
            flag &= server.processDestinations();
        }
        Set conns = this.acmeSystem.getConnectors();
        for (IAcmeConnector connector : conns) {
            QNConnector conn = PerformanceModelManager.getQNConnector(connector);
            Server server = conn.getServer();
            flag &= server.processDestinations();
        }
        return flag;
    }

    public boolean isPersistent() {
        return false;
    }

    public boolean isDistinctInDerivedViews() {
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

