/*
 * Decompiled with CFR 0.152.
 */
package org.acmestudio.ui.analysis.performance.model;

import java.util.LinkedList;
import java.util.List;
import org.acmestudio.acme.core.exception.AcmeException;
import org.acmestudio.acme.core.extension.IAcmeElementExtension;
import org.acmestudio.acme.core.type.IAcmeFloatValue;
import org.acmestudio.acme.element.IAcmeConnector;
import org.acmestudio.acme.element.IAcmeElementInstance;
import org.acmestudio.acme.element.IAcmeSystem;
import org.acmestudio.acme.element.property.IAcmeProperty;
import org.acmestudio.acme.element.property.IAcmePropertyBearer;
import org.acmestudio.acme.element.property.IAcmePropertyValue;
import org.acmestudio.acme.model.command.IAcmePropertyCreateCommand;
import org.acmestudio.acme.model.util.core.UMFloatValue;
import org.acmestudio.ui.Debug;
import org.acmestudio.ui.analysis.performance.model.PerformanceModelManager;
import org.acmestudio.ui.analysis.performance.model.QNSystem;
import org.acmestudio.ui.analysis.performance.model.Server;

public class QNConnector
implements IAcmeElementExtension {
    protected IAcmeConnector connector;
    protected Server server;
    protected double delayTime;
    protected double visits;
    protected boolean visitsp = true;

    public IAcmeConnector getConnector() {
        return this.connector;
    }

    public void setConnector(IAcmeConnector connector) {
        this.connector = connector;
    }

    protected void dumpProps() {
        IAcmeProperty visitsProp = this.connector.getProperty("perf-visits");
        if (visitsProp == null) {
            try {
                visitsProp = (IAcmeProperty)this.connector.getCommandFactory().propertyCreateCommand((IAcmePropertyBearer)this.connector, "perf-visits", "float", null).execute();
            }
            catch (IllegalStateException e) {
                Debug.errorln((Throwable)e);
            }
            catch (AcmeException e) {
                Debug.errorln((Throwable)e);
            }
        }
        UMFloatValue vVal = new UMFloatValue((float)this.visits);
        visitsProp.getCommandFactory().propertyValueSetCommand(visitsProp, (IAcmePropertyValue)vVal);
    }

    public QNConnector(IAcmeConnector conn) {
        this.connector = conn;
        this.visitsp = true;
        PerformanceModelManager.setQNConnector(conn, this);
    }

    public void checkProps() {
        IAcmeProperty delayTimeProp = this.connector.getProperty("perf-delayTime");
        IAcmeProperty visitsProp = this.connector.getProperty("perf-visits");
        LinkedList<IAcmePropertyCreateCommand> cmds = new LinkedList<IAcmePropertyCreateCommand>();
        if (delayTimeProp == null) {
            cmds.add(this.connector.getCommandFactory().propertyCreateCommand((IAcmePropertyBearer)this.connector, "perf-delayTime", "float", (IAcmePropertyValue)new UMFloatValue(0.0f)));
            this.delayTime = 0.0;
        }
        if (visitsProp == null) {
            cmds.add(this.connector.getCommandFactory().propertyCreateCommand((IAcmePropertyBearer)this.connector, "perf-visits", "float", (IAcmePropertyValue)new UMFloatValue(0.0f)));
            this.visits = 0.0;
            this.visitsp = false;
        }
        if (!cmds.isEmpty()) {
            try {
                List newProps = (List)this.connector.getCommandFactory().compoundCommand(cmds).execute();
                delayTimeProp = PerformanceModelManager.getNewProperty(delayTimeProp, "perf-delayTime", newProps);
                visitsProp = PerformanceModelManager.getNewProperty(visitsProp, "perf-visits", newProps);
            }
            catch (IllegalStateException e) {
                Debug.errorln((Throwable)e);
            }
            catch (AcmeException e) {
                Debug.errorln((Throwable)e);
            }
        }
        this.delayTime = ((IAcmeFloatValue)delayTimeProp.getValue()).getValue();
        if (this.delayTime < 0.0) {
            this.delayTime = 0.0;
        }
        this.visits = ((IAcmeFloatValue)visitsProp.getValue()).getValue();
        if (this.visits < 0.0) {
            this.visits = 0.0;
        }
    }

    public boolean calculatePerformance(boolean ok) {
        QNSystem mom = PerformanceModelManager.getQNSystem((IAcmeSystem)this.connector.getParent());
        if (ok && this.delayTime > 0.0 && this.visits > 0.0) {
            double pop = mom.getArrivalRate() * this.visits * this.delayTime;
            mom.incrPop(pop);
        }
        this.dumpProps();
        return true;
    }

    public void addServer() {
        QNSystem mom = PerformanceModelManager.getQNSystem((IAcmeSystem)this.connector.getParent());
        this.server = new Server((IAcmeElementInstance)this.connector, mom);
    }

    public Server getServer() {
        return this.server;
    }

    public boolean getVisitsp() {
        return this.visitsp;
    }

    public void setVisitsp(boolean b) {
        this.visitsp = b;
    }

    public void setVisits(double v) {
        this.visits = v;
    }

    public boolean isPersistent() {
        return false;
    }

    public boolean isDistinctInDerivedViews() {
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

