/*
 * Decompiled with CFR 0.152.
 */
package org.acmestudio.ui.analysis.performance.model;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.acmestudio.acme.core.IAcmeType;
import org.acmestudio.acme.core.exception.AcmeException;
import org.acmestudio.acme.core.extension.IAcmeElementExtension;
import org.acmestudio.acme.core.type.IAcmeFloatValue;
import org.acmestudio.acme.core.type.IAcmeIntValue;
import org.acmestudio.acme.core.type.IAcmeRecordValue;
import org.acmestudio.acme.core.type.IAcmeSequenceValue;
import org.acmestudio.acme.element.IAcmeComponent;
import org.acmestudio.acme.element.IAcmeElementInstance;
import org.acmestudio.acme.element.IAcmeSystem;
import org.acmestudio.acme.element.property.IAcmeProperty;
import org.acmestudio.acme.element.property.IAcmePropertyBearer;
import org.acmestudio.acme.element.property.IAcmePropertyValue;
import org.acmestudio.acme.element.representation.IAcmeRepresentation;
import org.acmestudio.acme.model.DefaultAcmeModel;
import org.acmestudio.acme.model.command.IAcmePropertyCommand;
import org.acmestudio.acme.model.command.IAcmePropertyCreateCommand;
import org.acmestudio.acme.model.util.core.UMBooleanValue;
import org.acmestudio.acme.model.util.core.UMFloatValue;
import org.acmestudio.acme.model.util.core.UMIntValue;
import org.acmestudio.ui.Debug;
import org.acmestudio.ui.analysis.performance.model.PerformanceModelManager;
import org.acmestudio.ui.analysis.performance.model.QNSystem;
import org.acmestudio.ui.analysis.performance.model.Request;
import org.acmestudio.ui.analysis.performance.model.Server;
import org.acmestudio.ui.analysis.performance.util.PerformanceException;

public class QNComponent
implements IAcmeElementExtension {
    protected IAcmeComponent component;
    protected Server server;
    protected boolean servicetimep = true;
    protected boolean visitsp = true;
    protected boolean replicationp = true;
    protected boolean requestsp = true;
    protected double serviceTime;
    protected double visits;
    protected int replication;
    protected double utilization;
    protected double length;
    protected double responseTime;
    protected boolean overloaded;

    public boolean isPersistent() {
        return false;
    }

    protected void doUnreplicated() {
        QNSystem mom = PerformanceModelManager.getQNSystem((IAcmeSystem)this.component.getParent());
        double arrivalRate = mom.getArrivalRate();
        if (this.visits > 0.0) {
            this.utilization = arrivalRate * this.visits * this.serviceTime;
            if (this.utilization >= 1.0) {
                this.utilization = 0.0;
                this.overload();
                mom.overload();
            }
            this.length = this.utilization / (1.0 - this.utilization);
            this.responseTime = arrivalRate == 0.0 || this.visits == 0.0 ? 0.0 : this.length / (arrivalRate * this.visits);
        }
    }

    protected void doReplicated(int m) throws PerformanceException {
        double prob0;
        QNSystem mom = PerformanceModelManager.getQNSystem((IAcmeSystem)this.component.getParent());
        double relArrival = this.visits * mom.getArrivalRate();
        if (relArrival == 0.0) {
            this.length = 0.0;
            this.responseTime = 0.0;
            this.overloaded = false;
            return;
        }
        double rs = relArrival * this.serviceTime;
        double term = 1.0;
        double prob0Inv = 0.0;
        int i = 0;
        while (i < this.replication) {
            prob0Inv += term;
            term *= rs;
            term /= (double)(i + 1);
            ++i;
        }
        prob0Inv += term;
        if ((double)this.replication == rs) {
            throw new PerformanceException("Division by zero");
        }
        if ((prob0Inv += term * rs / ((double)this.replication - rs)) == 0.0) {
            throw new PerformanceException("Division by zero");
        }
        double probI = prob0 = 1.0 / prob0Inv;
        this.utilization = 1.0;
        int i2 = 0;
        while (i2 < this.replication) {
            this.utilization = probI * (double)(this.replication - i2) / (double)this.replication;
            probI *= rs / (double)(i2 + 1);
            ++i2;
        }
        if (this.utilization < 0.0) {
            this.utilization = 0.0;
        }
        this.length = 0.0;
        probI = prob0;
        i2 = 0;
        while (i2 < this.replication) {
            this.length += probI * (double)i2;
            probI *= rs / (double)(i2 + 1);
            ++i2;
        }
        double rs_m = rs / (double)this.replication;
        this.length += probI * ((double)this.replication + (double)(1 - this.replication) * rs_m) / ((rs_m - 1.0) * (rs_m - 1.0));
        this.responseTime = this.length / relArrival;
    }

    protected void overload() {
        this.overloaded = true;
    }

    public QNComponent(IAcmeComponent comp) {
        this.component = comp;
        this.visitsp = true;
        PerformanceModelManager.setQNComponent(comp, this);
    }

    public void checkProps() {
        List pve;
        IAcmeProperty serviceTimeProp = this.component.getProperty("perf-serviceTime");
        IAcmeProperty visitsProp = this.component.getProperty("perf-visits");
        IAcmeProperty requestsProp = this.component.getProperty("perf-requests");
        IAcmeProperty replicationProp = this.component.getProperty("perf-replication");
        IAcmeProperty utilizationProp = this.component.getProperty("perf-utilization");
        IAcmeProperty lengthProp = this.component.getProperty("perf-length");
        IAcmeProperty responseTimeProp = this.component.getProperty("perf-responseTime");
        IAcmeProperty overloadedProp = this.component.getProperty("perf-overloaded");
        LinkedList<IAcmePropertyCreateCommand> propAddCmds = new LinkedList<IAcmePropertyCreateCommand>();
        UMFloatValue floatZero = new UMFloatValue(0.0f);
        if (serviceTimeProp == null) {
            propAddCmds.add(this.component.getCommandFactory().propertyCreateCommand((IAcmePropertyBearer)this.component, "perf-serviceTime", (IAcmeType)DefaultAcmeModel.defaultFloatType(), (IAcmePropertyValue)floatZero));
            this.servicetimep = false;
            this.serviceTime = 0.0;
        }
        if (visitsProp == null) {
            propAddCmds.add(this.component.getCommandFactory().propertyCreateCommand((IAcmePropertyBearer)this.component, "perf-visits", (IAcmeType)DefaultAcmeModel.defaultFloatType(), (IAcmePropertyValue)floatZero));
            this.visitsp = false;
            this.visits = 0.0;
        }
        if (requestsProp == null) {
            propAddCmds.add(this.component.getCommandFactory().propertyCreateCommand((IAcmePropertyBearer)this.component, "perf-requests", "ReqSeqT", null));
            this.requestsp = false;
        }
        if (replicationProp == null) {
            propAddCmds.add(this.component.getCommandFactory().propertyCreateCommand((IAcmePropertyBearer)this.component, "perf-replication", (IAcmeType)DefaultAcmeModel.defaultIntType(), (IAcmePropertyValue)new UMIntValue(1)));
            this.replicationp = false;
        }
        if (utilizationProp == null) {
            propAddCmds.add(this.component.getCommandFactory().propertyCreateCommand((IAcmePropertyBearer)this.component, "perf-utilization", (IAcmeType)DefaultAcmeModel.defaultFloatType(), (IAcmePropertyValue)floatZero));
        }
        if (lengthProp == null) {
            propAddCmds.add(this.component.getCommandFactory().propertyCreateCommand((IAcmePropertyBearer)this.component, "perf-length", (IAcmeType)DefaultAcmeModel.defaultFloatType(), (IAcmePropertyValue)floatZero));
        }
        if (responseTimeProp == null) {
            propAddCmds.add(this.component.getCommandFactory().propertyCreateCommand((IAcmePropertyBearer)this.component, "perf-responseTime", (IAcmeType)DefaultAcmeModel.defaultFloatType(), (IAcmePropertyValue)floatZero));
        }
        if (overloadedProp == null) {
            propAddCmds.add(this.component.getCommandFactory().propertyCreateCommand((IAcmePropertyBearer)this.component, "perf-overloaded", (IAcmeType)DefaultAcmeModel.defaultBooleanType(), (IAcmePropertyValue)new UMBooleanValue(false)));
        }
        if (!propAddCmds.isEmpty()) {
            try {
                List newProps = (List)this.component.getCommandFactory().compoundCommand(propAddCmds).execute();
                serviceTimeProp = PerformanceModelManager.getNewProperty(serviceTimeProp, "perf-serviceTime", newProps);
                visitsProp = PerformanceModelManager.getNewProperty(visitsProp, "perf-visits", newProps);
                requestsProp = PerformanceModelManager.getNewProperty(requestsProp, "perf-requests", newProps);
                replicationProp = PerformanceModelManager.getNewProperty(replicationProp, "perf-replication", newProps);
                utilizationProp = PerformanceModelManager.getNewProperty(utilizationProp, "perf-utilization", newProps);
                lengthProp = PerformanceModelManager.getNewProperty(lengthProp, "perf-length", newProps);
                responseTimeProp = PerformanceModelManager.getNewProperty(responseTimeProp, "perf-responseTime", newProps);
                overloadedProp = PerformanceModelManager.getNewProperty(overloadedProp, "perf-overloaded", newProps);
            }
            catch (IllegalStateException e) {
                Debug.errorln((Throwable)e);
            }
            catch (AcmeException e) {
                Debug.errorln((Throwable)e);
            }
        }
        this.serviceTime = ((IAcmeFloatValue)serviceTimeProp.getValue()).getValue();
        if (this.serviceTime < 0.0) {
            this.serviceTime = 0.0;
        }
        this.visits = ((IAcmeFloatValue)visitsProp.getValue()).getValue();
        IAcmeSequenceValue seq = (IAcmeSequenceValue)requestsProp.getValue();
        this.requestsp = seq == null ? false : (pve = seq.getValues()).size() != 0;
        this.replication = ((IAcmeIntValue)replicationProp.getValue()).getValue();
        this.replicationp = this.replication > 1;
        this.utilization = 0.0;
        this.length = 0.0;
        this.responseTime = 0.0;
        this.overloaded = false;
        Set reps = this.component.getRepresentations();
        for (IAcmeRepresentation rep : reps) {
            QNSystem sys = new QNSystem(rep.getSystem());
            sys.checkProps();
        }
    }

    public boolean calculatePerformance(boolean ok) throws PerformanceException {
        if (ok) {
            if (this.replicationp) {
                this.doReplicated(this.replication);
            } else {
                this.doUnreplicated();
            }
            this.dumpProps();
            QNSystem mom = PerformanceModelManager.getQNSystem((IAcmeSystem)this.component.getParent());
            mom.incrPop(this.length);
        }
        Set reps = this.component.getRepresentations();
        boolean flag = true;
        for (IAcmeRepresentation rep : reps) {
            QNSystem sys = new QNSystem(rep.getSystem());
            flag &= sys.calculatePerformance();
        }
        return flag;
    }

    public void processRequests() throws PerformanceException {
        IAcmeSequenceValue seq = (IAcmeSequenceValue)this.component.getProperty("perf-requests").getValue();
        if (seq == null) {
            return;
        }
        List pve = seq.getValues();
        for (IAcmePropertyValue value : pve) {
            IAcmeRecordValue rec = (IAcmeRecordValue)value;
            Request r = new Request(rec, this.server);
            if (this.replicationp) {
                r.mulGenRate(this.replication);
            }
            r.splitDestinations();
            this.server.addRequest(r);
        }
    }

    public void addServer() {
        QNSystem mom = PerformanceModelManager.getQNSystem((IAcmeSystem)this.component.getParent());
        this.server = new Server((IAcmeElementInstance)this.component, mom);
    }

    public boolean getVisitsp() {
        return this.visitsp;
    }

    public void setVisitsp(boolean visitsp) {
        this.visitsp = visitsp;
    }

    public boolean getRequestsp() {
        return this.requestsp;
    }

    public Server getServer() {
        return this.server;
    }

    public void dumpProps() {
        UMFloatValue uVal = new UMFloatValue((float)this.utilization);
        UMFloatValue lVal = new UMFloatValue((float)this.length);
        UMFloatValue rVal = new UMFloatValue((float)this.responseTime);
        UMFloatValue vVal = new UMFloatValue((float)this.visits);
        UMBooleanValue oVal = new UMBooleanValue(this.overloaded);
        IAcmeProperty uProp = this.component.getProperty("perf-utilization");
        IAcmeProperty lProp = this.component.getProperty("perf-length");
        IAcmeProperty rProp = this.component.getProperty("perf-responseTime");
        IAcmeProperty vProp = this.component.getProperty("perf-visits");
        IAcmeProperty oProp = this.component.getProperty("perf-overloaded");
        LinkedList<IAcmePropertyCommand> cmds = new LinkedList<IAcmePropertyCommand>();
        cmds.add(uProp.getCommandFactory().propertyValueSetCommand(uProp, (IAcmePropertyValue)uVal));
        cmds.add(lProp.getCommandFactory().propertyValueSetCommand(lProp, (IAcmePropertyValue)lVal));
        cmds.add(rProp.getCommandFactory().propertyValueSetCommand(rProp, (IAcmePropertyValue)rVal));
        cmds.add(vProp.getCommandFactory().propertyValueSetCommand(vProp, (IAcmePropertyValue)vVal));
        cmds.add(oProp.getCommandFactory().propertyValueSetCommand(oProp, (IAcmePropertyValue)oVal));
        try {
            uProp.getCommandFactory().compoundCommand(cmds).execute();
        }
        catch (IllegalStateException e) {
            Debug.errorln((Throwable)e);
        }
        catch (AcmeException e) {
            Debug.errorln((Throwable)e);
        }
    }

    public IAcmeComponent getAcmeComponent() {
        return this.component;
    }

    public void setReplication(int rep) {
        this.replication = rep;
    }

    public void setServiceTime(double st) {
        this.serviceTime = st;
    }

    public void setVisits(double v) {
        this.visits = v;
    }

    public boolean isDistinctInDerivedViews() {
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

