/*
 * Decompiled with CFR 0.152.
 */
package org.acmestudio.ui.analysis.performance.model;

import java.util.Iterator;
import java.util.List;
import org.acmestudio.acme.core.exception.AcmeException;
import org.acmestudio.acme.core.extension.IAcmeElementExtension;
import org.acmestudio.acme.element.IAcmeComponent;
import org.acmestudio.acme.element.IAcmeConnector;
import org.acmestudio.acme.element.IAcmeElement;
import org.acmestudio.acme.element.IAcmeSystem;
import org.acmestudio.acme.element.property.IAcmeProperty;
import org.acmestudio.ui.Debug;
import org.acmestudio.ui.analysis.performance.model.QNComponent;
import org.acmestudio.ui.analysis.performance.model.QNConnector;
import org.acmestudio.ui.analysis.performance.model.QNSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformanceModelManager {
    public static final String KEY = "org.acmestudio.ui.analysis.performance.udkey";

    public static QNComponent getQNComponent(IAcmeComponent comp) {
        IAcmeElementExtension c = comp.getUserData(KEY);
        if (c instanceof QNComponent) {
            return (QNComponent)c;
        }
        return null;
    }

    public static QNConnector getQNConnector(IAcmeConnector conn) {
        IAcmeElementExtension c = conn.getUserData(KEY);
        if (c instanceof QNConnector) {
            return (QNConnector)c;
        }
        return null;
    }

    public static QNSystem getQNSystem(IAcmeSystem sys) {
        IAcmeElementExtension c = sys.getUserData(KEY);
        if (c instanceof QNSystem) {
            return (QNSystem)c;
        }
        return null;
    }

    public static void setQNComponent(IAcmeComponent acmeComp, QNComponent qnComp) {
        PerformanceModelManager.setQNData((IAcmeElement)acmeComp, qnComp);
    }

    private static void setQNData(IAcmeElement element, IAcmeElementExtension data) {
        try {
            element.getCommandFactory().setElementUserData(element, KEY, data).execute();
        }
        catch (IllegalStateException e) {
            Debug.errorln((Throwable)e);
        }
        catch (AcmeException e) {
            Debug.errorln((Throwable)e);
        }
    }

    public static void setQNConnector(IAcmeConnector acmeConn, QNConnector qnConn) {
        PerformanceModelManager.setQNData((IAcmeElement)acmeConn, qnConn);
    }

    public static IAcmeProperty getNewProperty(IAcmeProperty prop, String name, List<Object> props) {
        if (prop == null) {
            Iterator<Object> i = props.iterator();
            while (i.hasNext() && prop == null) {
                IAcmeProperty p;
                Object o = i.next();
                if (!(o instanceof IAcmeProperty) || !name.equals((p = (IAcmeProperty)o).getName())) continue;
                prop = p;
            }
        }
        return prop;
    }

    public static void setQNSystem(IAcmeSystem acmeSystem, QNSystem qnSys) {
        PerformanceModelManager.setQNData((IAcmeElement)acmeSystem, qnSys);
    }
}

