/*
 * Decompiled with CFR 0.152.
 */
package org.acmestudio.ui.analysis.performance.model;

import org.acmestudio.acme.core.IAcmeType;
import org.acmestudio.acme.core.type.IAcmeFloatValue;
import org.acmestudio.acme.core.type.IAcmeRecordField;
import org.acmestudio.acme.core.type.IAcmeRecordValue;
import org.acmestudio.acme.core.type.IAcmeStringValue;
import org.acmestudio.acme.element.property.IAcmePropertyValue;
import org.acmestudio.acme.model.DefaultAcmeModel;
import org.acmestudio.acme.model.util.core.UMFloatValue;
import org.acmestudio.acme.model.util.core.UMRecordValue;
import org.acmestudio.acme.model.util.core.UMStringValue;
import org.acmestudio.ui.analysis.performance.model.PerformanceModelManager;
import org.acmestudio.ui.analysis.performance.model.QNComponent;
import org.acmestudio.ui.analysis.performance.model.QNConnector;
import org.acmestudio.ui.analysis.performance.model.QNSystem;
import org.acmestudio.ui.analysis.performance.model.Request;
import org.acmestudio.ui.analysis.performance.model.Server;
import org.acmestudio.ui.analysis.performance.util.PerformanceException;

public class Destination {
    private Request from;
    private double prob;
    private String to_name;
    private Server to_server;
    private QNConnector to_conn;
    private Request to;

    public Destination(IAcmeRecordValue rec, Request from) throws PerformanceException {
        IAcmeRecordField rf = rec.getField("name");
        this.from = from;
        this.to = null;
        QNSystem system = from.getParent().getSystem();
        IAcmeStringValue str = (IAcmeStringValue)rf.getValue();
        this.to_name = str.getValue();
        rf = rec.getField("parent");
        str = (IAcmeStringValue)rf.getValue();
        String tmp = str.getValue();
        QNComponent comp = PerformanceModelManager.getQNComponent(system.getAcmeSystem().getComponent(tmp));
        if (comp == null) {
            throw new PerformanceException("Cannot find referenced component " + tmp);
        }
        this.to_server = comp.getServer();
        this.to_conn = null;
        rf = rec.getField("via");
        if (rf != null) {
            str = (IAcmeStringValue)rf.getValue();
            tmp = str.getValue();
            this.to_conn = PerformanceModelManager.getQNConnector(system.getAcmeSystem().getConnector(tmp));
            if (this.to_conn == null) {
                throw new PerformanceException("Cannot find referenced connector " + tmp);
            }
        }
        rf = rec.getField("prob");
        IAcmeFloatValue fl = (IAcmeFloatValue)rf.getValue();
        this.prob = fl.getValue();
        if (this.prob < 0.0 || this.prob > 1.0) {
            this.prob = 0.0;
        }
    }

    public IAcmeRecordValue toAcme() {
        UMRecordValue rec = new UMRecordValue();
        rec.addRecordField("name", (IAcmeType)DefaultAcmeModel.defaultStringType(), (IAcmePropertyValue)new UMStringValue(this.to_name));
        rec.addRecordField("parent", (IAcmeType)DefaultAcmeModel.defaultStringType(), (IAcmePropertyValue)new UMStringValue(this.to_server.getParent().getName()));
        rec.addRecordField("via", (IAcmeType)DefaultAcmeModel.defaultStringType(), (IAcmePropertyValue)new UMStringValue(this.to_conn.connector.getName()));
        rec.addRecordField("prob", (IAcmeType)DefaultAcmeModel.defaultFloatType(), (IAcmePropertyValue)new UMFloatValue((float)this.prob));
        return rec;
    }

    public Destination(String name, Server server, Request r, double prob) {
        this.to_name = name;
        this.to_server = server;
        this.to = null;
        this.from = r;
        this.prob = prob;
    }

    public Destination(String name, Server s, QNConnector q, Request r) {
        this.to_name = name;
        this.to_server = s;
        this.to = null;
        this.to_conn = q;
        this.from = r;
        this.prob = 0.0;
    }

    public String getName() {
        return this.to_name;
    }

    public Request getFrom() {
        return this.from;
    }

    public Request getTo() {
        return this.to;
    }

    public double getProb() {
        return this.prob;
    }

    public void setProb(double p) {
        this.prob = p;
    }

    public void split() {
        String tmp = this.to_name;
        Server to_s = this.to_server;
        this.to_name = this.strmunge(this.from.getName(), this.from.getParent().getParent().getName());
        this.to_server = this.to_conn.getServer();
        this.to = this.to_server.addOrGetRequest(this.to_name);
        Destination middle_dest = new Destination(tmp, to_s, this.to, 1.0);
        this.to.addDestination(middle_dest);
    }

    private String strmunge(String a, String b) {
        return String.valueOf(a) + "_" + b;
    }

    public boolean setPointer() {
        if (this.to != null) {
            return true;
        }
        this.to = this.to_server.getRequest(this.to_name);
        return this.to != null;
    }

    public QNConnector getToConn() {
        return this.to_conn;
    }

    public Server getToServer() {
        return this.to_server;
    }
}

